/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Description;
import pcgen.core.PObject;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public class DomainBasePanel
extends BasePanel {
    private DescriptionPanel pnlDescription;

    public DomainBasePanel() {
        this.initComponents();
    }

    public void setDescIsPI(boolean bl) {
        this.pnlDescription.setDescIsPI(bl);
    }

    public boolean getDescIsPI() {
        return this.pnlDescription.getDescIsPI();
    }

    public void setDescriptionText(String string) {
        this.pnlDescription.setText(string);
    }

    public String getDescriptionText() {
        return this.pnlDescription.getText();
    }

    public void updateData(PObject pObject) {
        String string = this.getDescriptionText();
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(GlobalLstToken.class);
        GlobalLstToken globalLstToken = (GlobalLstToken)map.get("DESC");
        if (globalLstToken != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    globalLstToken.parse(pObject, stringTokenizer.nextToken(), -9);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Invalid Description: " + string);
                    Logging.errorPrint("  Token Parse Failed: " + persistenceLayerException.getLocalizedMessage());
                }
            }
        }
        pObject.setDescIsPI(this.getDescIsPI());
    }

    public void updateView(PObject pObject) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Description description : pObject.getDescriptionList()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(description.getPCCText());
        }
        this.setDescriptionText(stringBuffer.toString());
        this.setDescIsPI(pObject.getDescIsPI());
    }

    private void initComponents() {
        this.pnlDescription = new DescriptionPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlDescription, gridBagConstraints);
    }
}

