/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.WholeNumberField;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.DecimalNumberField;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatBasePanel
extends BasePanel {
    private DecimalNumberField txtCost;
    private DescriptionPanel pnlDescription;
    private JCheckBox chkMultiple;
    private JCheckBox chkStack;
    private JComboBoxEx cmbVisible;
    private JLabel lblCost;
    private JLabel lblSpellLevels;
    private JLabel lblVisible;
    private JPanel pnlMisc;
    private TypePanel pnlFeatType;
    private WholeNumberField txtSpellLevels;

    public FeatBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setCost(double d) {
        this.txtCost.setValue(d);
    }

    public double getCost() {
        return this.txtCost.getValue();
    }

    public void setDescIsPI(boolean bl) {
        this.pnlDescription.setDescIsPI(bl);
    }

    public boolean getDescIsPI() {
        return this.pnlDescription.getDescIsPI();
    }

    public void setDescriptionText(String string) {
        this.pnlDescription.setText(string);
    }

    public String getDescriptionText() {
        return this.pnlDescription.getText();
    }

    public void setMultiples(boolean bl) {
        this.chkMultiple.setSelected(bl);
    }

    public boolean getMultiples() {
        return this.chkMultiple.isSelected();
    }

    public void setSpellLevels(int n) {
        this.txtSpellLevels.setValue(n);
    }

    public int getSpellLevels() {
        return this.txtSpellLevels.getValue();
    }

    public void setStacks(boolean bl) {
        this.chkStack.setSelected(bl);
    }

    public boolean getStacks() {
        return this.chkStack.isSelected();
    }

    public void setTypesAvailableList(List<String> list, boolean bl) {
        this.pnlFeatType.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<String> list, boolean bl) {
        this.pnlFeatType.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlFeatType.getSelectedList();
    }

    public void setVisible(Visibility visibility) {
        this.cmbVisible.setSelectedIndex(visibility.ordinal());
    }

    public Visibility getVisible() {
        return Visibility.values()[this.cmbVisible.getSelectedIndex()];
    }

    @Override
    public void updateData(PObject pObject) {
        Object[] objectArray;
        Ability ability = (Ability)pObject;
        String string = this.getDescriptionText();
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(GlobalLstToken.class);
        GlobalLstToken globalLstToken = (GlobalLstToken)map.get("DESC");
        if (globalLstToken != null) {
            objectArray = new StringTokenizer(string, "\t");
            while (objectArray.hasMoreTokens()) {
                try {
                    globalLstToken.parse(ability, objectArray.nextToken(), -9);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Invalid Description: " + string);
                    Logging.errorPrint("  Token Parse Failed: " + persistenceLayerException.getLocalizedMessage());
                }
            }
        }
        ability.setDescIsPI(this.getDescIsPI());
        ability.setMultiples(this.getMultiples() ? "Y" : "N");
        ability.setStacks(this.getStacks() ? "Y" : "N");
        ability.setVisibility(this.getVisible());
        ability.setCost(Double.toString(this.getCost()));
        ability.setAddSpellLevel(this.getSpellLevels());
        objectArray = this.getTypesSelectedList();
        ability.setTypeInfo(".CLEAR");
        for (int i = 0; i < objectArray.length; ++i) {
            ability.setTypeInfo(objectArray[i].toString());
        }
    }

    @Override
    public void updateView(PObject pObject) {
        Ability ability = (Ability)pObject;
        StringBuffer stringBuffer = new StringBuffer();
        for (Description cloneable2 : pObject.getDescriptionList()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(cloneable2.getPCCText());
        }
        this.setDescriptionText(stringBuffer.toString());
        this.setDescIsPI(pObject.getDescIsPI());
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
        while (iterator.hasNext()) {
            Ability ability2 = (Ability)iterator.next();
            for (String string : ability2.getTypeList(false)) {
                if (string.equals("CUSTOM") || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        for (String string : ability.getTypeList(false)) {
            if (string.equals("CUSTOM")) continue;
            arrayList2.add(string);
            arrayList.remove(string);
        }
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        this.setVisible(ability.getVisibility());
        this.setMultiples(ability.isMultiples());
        this.setStacks(ability.isStacks());
        this.setCost(ability.getCost());
        this.setSpellLevels(ability.getAddSpellLevel());
    }

    private void initComponentContents() {
        Vector<String> vector = new Vector<String>();
        for (Visibility visibility : Visibility.values()) {
            vector.add(visibility.toString());
        }
        this.cmbVisible.setModel(new DefaultComboBoxModel(vector));
    }

    private void initComponents() {
        this.pnlDescription = new DescriptionPanel();
        this.pnlFeatType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.pnlMisc = new JPanel();
        this.lblCost = new JLabel();
        this.lblVisible = new JLabel();
        this.cmbVisible = new JComboBoxEx();
        this.chkMultiple = new JCheckBox();
        this.chkStack = new JCheckBox();
        this.txtCost = new DecimalNumberField(0.0, 5);
        this.lblSpellLevels = new JLabel();
        this.txtSpellLevels = new WholeNumberField(0, 3);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.pnlDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFeatType, gridBagConstraints);
        this.pnlMisc.setLayout(new GridBagLayout());
        this.lblCost.setText("Cost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        this.pnlMisc.add((Component)this.lblCost, gridBagConstraints);
        this.lblVisible.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        this.pnlMisc.add((Component)this.lblVisible, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.cmbVisible, gridBagConstraints);
        this.chkMultiple.setText("Multiples allowed");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.chkMultiple, gridBagConstraints);
        this.chkStack.setText("Stacks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.chkStack, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlMisc.add((Component)this.txtCost, gridBagConstraints);
        this.lblSpellLevels.setText("Spell Levels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        this.pnlMisc.add((Component)this.lblSpellLevels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.txtSpellLevels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlMisc, gridBagConstraints);
    }
}

