/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

final class JListModel
extends AbstractListModel {
    private List listData = null;
    private boolean sort = false;

    JListModel(List list, boolean bl) {
        this.initModel(list, bl);
    }

    public void setData(List list) {
        this.listData = (List)((ArrayList)list).clone();
        if (this.sort) {
            Collections.sort(this.listData);
        }
        this.fireIntervalAdded(this, 0, this.listData.size());
    }

    public Object getElementAt(int n) {
        if (this.listData != null && n < this.listData.size()) {
            return this.listData.get(n);
        }
        return null;
    }

    public int getSize() {
        if (this.listData != null) {
            return this.listData.size();
        }
        return 0;
    }

    Object[] getElements() {
        return this.listData.toArray();
    }

    void setSort(boolean bl) {
        this.sort = bl;
    }

    void addElement(Object object, boolean bl) {
        if (bl || !this.listData.contains(object)) {
            this.addElement(object);
        }
    }

    void addElement(Object object) {
        this.listData.add(object);
        if (this.sort) {
            Collections.sort(this.listData);
        }
        this.fireIntervalAdded(this, 0, this.listData.size());
    }

    void addElement(int n, Object object) {
        this.listData.add(n, object);
        if (this.sort) {
            Collections.sort(this.listData);
        }
        this.fireIntervalAdded(this, 0, this.listData.size());
    }

    boolean removeElement(Object object) {
        int n = this.listData.indexOf(object);
        if (n >= 0) {
            this.listData.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
        return n >= 0;
    }

    private void initModel(List list, boolean bl) {
        this.sort = bl;
        this.setData(list);
    }
}

