/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Equipment;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NaturalAttacksPanel
extends JPanel {
    static final long serialVersionUID = 7072891779087323350L;
    private JButton btnAdd;
    private JButton btnRemove;
    private JCheckBox chbBludgeoning;
    private JCheckBox chbPiercing;
    private JCheckBox chbSlashing;
    private JCheckBox chbWeaponPrimary;
    private JComboBoxEx cmbDamageDie;
    private JComboBoxEx cmbHandsRequired;
    private JComboBoxEx cmbNumDice;
    private JComboBoxEx cmbNumNaturalAttacks;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtNaturalAttackName;

    NaturalAttacksPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public List<Equipment> getNaturalWeapons() {
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        int n = jListModel.getSize();
        for (int i = 0; i < n; ++i) {
            int n2;
            String string;
            int n3;
            Equipment equipment = new Equipment();
            String string2 = (String)jListModel.getElementAt(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
            equipment.setName(stringTokenizer.nextToken());
            equipment.setTypeInfo(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Natural Weapons Editor: non-numeric value for number of attacks: '" + string3 + "'");
                n3 = 1;
            }
            if (n3 > 1) {
                string = "WEAPON|ATTACKS|" + (n3 - 1);
                equipment.addBonusList(string);
            }
            equipment.setDamage(stringTokenizer.nextToken());
            string = stringTokenizer.nextToken();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Natural Weapons Editor: non-numeric value for number of hands: '" + string + "'");
                n2 = 0;
            }
            equipment.setHands(n2);
            equipment.setAttacksProgress(false);
            arrayList.add(equipment);
        }
        return arrayList;
    }

    void setSelectedList(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            String string = "";
            String string2 = ((Equipment)list.get(i)).getSimpleName();
            string = string + string2 + ",";
            String string3 = ((Equipment)list.get(i)).modifiedName();
            if (string3.indexOf("Primary") >= 0) {
                bl = true;
            }
            String string4 = ((Equipment)list.get(i)).getType();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ".", true);
            string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                string4 = string4 + string5.substring(0, 1).toUpperCase() + string5.substring(1).toLowerCase();
            }
            string = string + string4 + ",";
            int n2 = 1 + (int)((Equipment)list.get(i)).bonusTo(null, "WEAPON", "ATTACKS", true);
            string = string + n2 + ",";
            String string6 = ((Equipment)list.get(i)).getDamage(null);
            string = string + string6 + ",";
            int n3 = ((Equipment)list.get(i)).getHands(null);
            string = string + n3;
            this.addToSelectedLst(string, bl);
        }
    }

    private static boolean isDoubleClick(MouseEvent mouseEvent, JList jList, JButton jButton) {
        if (jList.getMinSelectionIndex() >= 0) {
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    jButton.setEnabled(true);
                    break;
                }
                case 2: {
                    if (!jButton.isEnabled()) break;
                    return true;
                }
            }
        }
        return false;
    }

    private void addToSelectedLst(String string, boolean bl) {
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        int n = 0;
        int n2 = jListModel.getSize();
        for (int i = 0; i < n2; ++i) {
            Object object = jListModel.getElementAt(i);
            if (!((String)object).startsWith(string.substring(0, string.indexOf(",")))) continue;
            jListModel.removeElement(object);
            n = i;
            break;
        }
        if (bl) {
            jListModel.addElement(0, string);
        } else if (n != 0) {
            jListModel.addElement(n, string);
        } else {
            jListModel.addElement(string);
        }
    }

    private void btnAddActionPerformed() {
        String string = this.txtNaturalAttackName.getText();
        if (string.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demNatWeaponNoName"), "PCGen", MessageType.ERROR);
            return;
        }
        string = string + ",Weapon.Natural.Melee";
        boolean bl = false;
        if (this.chbPiercing.isSelected()) {
            string = string + ".Piercing";
            bl = true;
        }
        if (this.chbSlashing.isSelected()) {
            string = string + ".Slashing";
            bl = true;
        }
        if (this.chbBludgeoning.isSelected()) {
            string = string + ".Bludgeoning";
            bl = true;
        }
        if (!bl) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demNatWeaponNoType"), "PCGen", MessageType.ERROR);
            return;
        }
        string = string + "," + this.cmbNumNaturalAttacks.getSelectedItem();
        string = string + "," + (String)this.cmbNumDice.getSelectedItem() + this.cmbDamageDie.getSelectedItem();
        string = string + "," + this.cmbHandsRequired.getSelectedItem();
        this.addToSelectedLst(string, this.chbWeaponPrimary.isSelected());
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        Object[] objectArray = this.lstSelected.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            jListModel.removeElement(objectArray[i]);
        }
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exception) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblSelected = new JLabel(PropertyFactory.getString("in_selected"));
        this.lstSelected = new JList(new JListModel(new ArrayList(), false));
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        this.txtNaturalAttackName = new JTextField();
        this.txtNaturalAttackName.setMaximumSize(new Dimension(100, 21));
        this.txtNaturalAttackName.setPreferredSize(new Dimension(100, 21));
        this.cmbNumNaturalAttacks = new JComboBoxEx(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
        this.cmbNumNaturalAttacks.setMaximumSize(new Dimension(21, 21));
        this.cmbNumNaturalAttacks.setPreferredSize(new Dimension(21, 21));
        this.cmbNumDice = new JComboBoxEx(new String[]{"1", "2", "3", "4"});
        this.cmbNumDice.setMaximumSize(new Dimension(21, 21));
        this.cmbNumDice.setPreferredSize(new Dimension(21, 21));
        this.cmbDamageDie = new JComboBoxEx(new String[]{"d1", "d2", "d3", "d4", "d6", "d8", "d10"});
        this.cmbDamageDie.setMaximumSize(new Dimension(65, 21));
        this.cmbDamageDie.setPreferredSize(new Dimension(65, 21));
        this.cmbDamageDie.setMinimumSize(new Dimension(65, 21));
        this.cmbHandsRequired = new JComboBoxEx(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
        this.cmbHandsRequired.setMaximumSize(new Dimension(21, 21));
        this.cmbHandsRequired.setPreferredSize(new Dimension(21, 21));
        this.chbPiercing = new JCheckBox();
        this.chbBludgeoning = new JCheckBox();
        this.chbSlashing = new JCheckBox();
        this.chbWeaponPrimary = new JCheckBox();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, PropertyFactory.getString("in_demTag"));
        titledBorder.setTitleJustification(1);
        this.pnlAvailable.setBorder(titledBorder);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_demNatWeaponName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.add(this.txtNaturalAttackName);
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.txtNaturalAttackName.setPreferredSize(new Dimension(100, 21));
        this.txtNaturalAttackName.setMinimumSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demWeaponPrimary"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbWeaponPrimary, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demWeaponBludgeoning"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbBludgeoning, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demWeaponPiercing"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbPiercing, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demWeaponSlashing"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbSlashing, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demNatWeaponNumAttacks"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        jPanel = new JPanel();
        jPanel.add(this.cmbNumNaturalAttacks);
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.cmbNumNaturalAttacks.setPreferredSize(new Dimension(35, 21));
        this.cmbNumNaturalAttacks.setMinimumSize(new Dimension(35, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demNatWeaponNumHands"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        jPanel = new JPanel();
        jPanel.add(this.cmbHandsRequired);
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.cmbHandsRequired.setPreferredSize(new Dimension(35, 21));
        this.cmbHandsRequired.setMinimumSize(new Dimension(35, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demWeaponDamage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        jPanel = new JPanel();
        jPanel.add(this.cmbNumDice);
        jPanel.add(this.cmbDamageDie);
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.cmbNumDice.setPreferredSize(new Dimension(35, 21));
        this.cmbNumDice.setMinimumSize(new Dimension(35, 21));
        this.cmbDamageDie.setPreferredSize(new Dimension(45, 21));
        this.cmbDamageDie.setMinimumSize(new Dimension(45, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlAvailable.add((Component)jPanel, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NaturalAttacksPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NaturalAttacksPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                NaturalAttacksPanel.this.lstSelectedMouseClicked(mouseEvent);
            }
        });
        this.lstSelected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (NaturalAttacksPanel.this.lstSelected.getSelectedIndex() >= 0) {
                    NaturalAttacksPanel.this.lstSelected.ensureIndexIsVisible(NaturalAttacksPanel.this.lstSelected.getSelectedIndex());
                }
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.lstSelected)) {
            String string = (String)this.lstSelected.getSelectedValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            this.txtNaturalAttackName.setText(stringTokenizer.nextToken());
            if (this.lstSelected.getSelectedIndex() == 0) {
                this.chbWeaponPrimary.setSelected(true);
            } else {
                this.chbWeaponPrimary.setSelected(false);
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("Slashing") != -1) {
                this.chbSlashing.setSelected(true);
            } else {
                this.chbSlashing.setSelected(false);
            }
            if (string2.indexOf("Piercing") != -1) {
                this.chbPiercing.setSelected(true);
            } else {
                this.chbPiercing.setSelected(false);
            }
            if (string2.indexOf("Bludgeoning") != -1) {
                this.chbBludgeoning.setSelected(true);
            } else {
                this.chbBludgeoning.setSelected(false);
            }
            String string3 = stringTokenizer.nextToken().trim();
            this.cmbNumNaturalAttacks.setSelectedItem(string3);
            String string4 = stringTokenizer.nextToken();
            this.cmbNumDice.setSelectedItem(string4.substring(0, 1));
            this.cmbDamageDie.setSelectedItem(string4.substring(1));
            String string5 = stringTokenizer.nextToken().trim();
            this.cmbHandsRequired.setSelectedItem(string5);
            if (NaturalAttacksPanel.isDoubleClick(mouseEvent, this.lstSelected, this.btnRemove)) {
                this.btnRemoveActionPerformed();
            }
        }
    }
}

