/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaceBasePanel
extends BasePanel {
    private static final String[] sizeTitles = new String[]{"Fine", "Diminutive", "Tiny", "Small", "Medium", "Large", "Huge", "Gargantuan", "Colossal"};
    private static final String[] sizeAbbrev = new String[]{"F", "D", "T", "S", "M", "L", "H", "G", "C"};
    private static final String[] hitDiceSizeValues = new String[]{"1", "2", "4", "6", "8", "10", "12", "14", "16", "18", "20"};
    private static final String[] crValues = new String[]{"1/10", "1/8", "1/6", "1/4", "1/3", "1/2", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
    private JComboBoxEx cmbBonusFeats;
    private JComboBoxEx cmbBonusSkillPoints;
    private JComboBoxEx cmbCR;
    private JComboBoxEx cmbHands;
    private JComboBoxEx cmbHitDiceNumber;
    private JComboBoxEx cmbHitDiceSize;
    private JComboBoxEx cmbLegs;
    private JComboBoxEx cmbMonsterClass;
    private JComboBoxEx cmbMonsterLevel;
    private JComboBoxEx cmbReach;
    private JComboBoxEx cmbSize;
    private JComboBoxEx cmbSkillMult;
    private JPanel pnlTemplateMisc;
    private JTextField txtDisplayName;
    private JTextField txtHitDiceAdvancement;
    private JTextField txtLevelAdj;
    private TypePanel pnlTemplateTypes;

    public RaceBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setBonusFeats(int n) {
        if (n >= 0 && n < this.cmbBonusFeats.getItemCount()) {
            this.cmbBonusFeats.setSelectedIndex(n);
        }
    }

    public int getBonusFeats() {
        return this.cmbBonusFeats.getSelectedIndex();
    }

    public void setBonusSkillPoints(int n) {
        if (n >= 0 && n < this.cmbBonusSkillPoints.getItemCount()) {
            this.cmbBonusSkillPoints.setSelectedIndex(n);
        }
    }

    public int getBonusSkillPoints() {
        return this.cmbBonusSkillPoints.getSelectedIndex();
    }

    public void setCR(int n) {
        String string = n < 0 ? "1/" + Integer.toString(-n) : Integer.toString(n);
        this.cmbCR.setSelectedItem(string);
    }

    public int getCR() {
        String string = null;
        try {
            string = this.cmbCR.getSelectedItem().toString();
            if (string == null) {
                return 0;
            }
            if (string.startsWith("1/")) {
                return Integer.parseInt(string.substring(2));
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Couldn't figure out what CR " + string + " means.");
            return 0;
        }
    }

    public void setDisplayName(String string) {
        this.txtDisplayName.setText(string);
    }

    public String getDisplayName() {
        return this.txtDisplayName.getText();
    }

    public void setHands(int n) {
        if (n >= 0 && n < this.cmbHands.getItemCount()) {
            this.cmbHands.setSelectedIndex(n);
        }
    }

    public int getHands() {
        return this.cmbHands.getSelectedIndex();
    }

    public void setHitDiceAdvancement(Race race) {
        if (race == null || race.getNumberOfHitDiceAdvancements() == 0) {
            this.txtHitDiceAdvancement.setText("");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < race.getNumberOfHitDiceAdvancements(); ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                if (race.getHitDiceAdvancement(i) == -1 && race.isAdvancementUnlimited()) {
                    stringBuffer.append('*');
                    continue;
                }
                stringBuffer.append(String.valueOf(race.getHitDiceAdvancement(i)));
            }
            this.txtHitDiceAdvancement.setText(stringBuffer.toString());
        }
    }

    public int[] getHitDiceAdvancement() {
        if (this.txtHitDiceAdvancement.getText() == null || this.txtHitDiceAdvancement.getText().trim().length() == 0) {
            return new int[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.txtHitDiceAdvancement.getText(), ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (int i = 0; i < nArray.length; ++i) {
            String string = stringTokenizer.nextToken();
            nArray[i] = string.length() > 0 && string.charAt(0) == '*' ? -1 : Integer.parseInt(string);
        }
        return nArray;
    }

    public boolean getHitDiceAdvancementUnlimited() {
        if (this.txtHitDiceAdvancement.getText() != null && this.txtHitDiceAdvancement.getText().trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.txtHitDiceAdvancement.getText(), ",");
            int[] nArray = new int[stringTokenizer.countTokens()];
            for (int i = 0; i < nArray.length; ++i) {
                String string = stringTokenizer.nextToken();
                if (string.length() <= 0 || string.charAt(0) != '*') continue;
                return true;
            }
        }
        return false;
    }

    public void setHitDiceNumber(int n) {
        if (n >= 0 && n < this.cmbMonsterLevel.getItemCount()) {
            this.cmbHitDiceNumber.setSelectedItem(String.valueOf(n));
        }
    }

    public int getHitDiceNumber() {
        return Integer.parseInt((String)this.cmbHitDiceNumber.getSelectedItem());
    }

    public void setHitDiceSize(int n) {
        if (n >= 0 && n < this.cmbMonsterLevel.getItemCount()) {
            this.cmbHitDiceSize.setSelectedItem(String.valueOf(n));
        }
    }

    public int getHitDiceSize() {
        return Integer.parseInt((String)this.cmbHitDiceSize.getSelectedItem());
    }

    public void setLegs(int n) {
        if (n >= 0 && n < this.cmbLegs.getItemCount()) {
            this.cmbLegs.setSelectedIndex(n);
        }
    }

    public int getLegs() {
        return this.cmbLegs.getSelectedIndex();
    }

    public void setLevelAdjustment(String string) {
        this.txtLevelAdj.setText(string);
    }

    public String getLevelAdjustment() {
        return this.txtLevelAdj.getText();
    }

    public void setMonsterClass(String string) {
        if (string == null || string.length() == 0) {
            this.cmbMonsterClass.setSelectedItem("(None)");
        } else {
            this.cmbMonsterClass.setSelectedItem(string);
        }
    }

    public String getMonsterClass() {
        return (String)this.cmbMonsterClass.getSelectedItem();
    }

    public void setMonsterClassList(List<String> list) {
        this.cmbMonsterClass.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    public void setMonsterLevel(int n) {
        if (n >= 0 && n < this.cmbMonsterLevel.getItemCount()) {
            this.cmbMonsterLevel.setSelectedIndex(n);
        }
    }

    public int getMonsterLevel() {
        return this.cmbMonsterLevel.getSelectedIndex();
    }

    public void setRaceSize(String string) {
        this.cmbSize.setSelectedIndex(0);
        for (int i = 0; i < sizeAbbrev.length; ++i) {
            if (!sizeAbbrev[i].equals(string)) continue;
            this.cmbSize.setSelectedIndex(i);
            break;
        }
    }

    public String getRaceSize() {
        int n = this.cmbSize.getSelectedIndex();
        if (n >= 0 && n < sizeAbbrev.length) {
            return sizeAbbrev[n];
        }
        return "";
    }

    public void setReach(int n) {
        this.cmbReach.setSelectedItem(String.valueOf(n));
    }

    public int getReach() {
        return Integer.parseInt((String)this.cmbReach.getSelectedItem());
    }

    public void setSkillMultiplier(int n) {
        if (n >= 0 && n < this.cmbSkillMult.getItemCount()) {
            this.cmbSkillMult.setSelectedIndex(n);
        }
    }

    public int getSkillMultiplier() {
        return this.cmbSkillMult.getSelectedIndex();
    }

    public void setTypesAvailableList(List<String> list, boolean bl) {
        this.pnlTemplateTypes.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<String> list, boolean bl) {
        this.pnlTemplateTypes.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    @Override
    public void updateData(PObject pObject) {
        Race race = (Race)pObject;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FEAT|POOL|").append(this.getBonusFeats());
        BonusObj bonusObj = Bonus.newBonus(stringBuffer.toString());
        race.setBonusInitialFeats(bonusObj);
        race.setBonusSkillsPerLevel(this.getBonusSkillPoints());
        race.setCR(this.getCR());
        race.setDisplayName(this.getDisplayName());
        race.setHands(this.getHands());
        race.setHitDiceAdvancement(this.getHitDiceAdvancement());
        race.setAdvancementUnlimited(this.getHitDiceAdvancementUnlimited());
        race.setLegs(this.getLegs());
        race.setLevelAdjustment(this.getLevelAdjustment());
        race.setMonsterClass(this.getMonsterClass());
        race.setMonsterClassLevels(this.getMonsterLevel());
        race.setSize(this.getRaceSize());
        race.setReach(this.getReach());
        race.setInitialSkillMultiplier(this.getSkillMultiplier());
        race.setHitDice(this.getHitDiceNumber());
        race.setHitDiceSize(this.getHitDiceSize());
        Object[] objectArray = this.getTypesSelectedList();
        pObject.setTypeInfo(".CLEAR");
        for (int i = 0; i < objectArray.length; ++i) {
            pObject.setTypeInfo(objectArray[i].toString());
        }
    }

    @Override
    public void updateView(PObject pObject) {
        Race race = (Race)pObject;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Race race2 : Globals.getAllRaces()) {
            for (String string : race2.getTypeList(false)) {
                if (string.equals("CUSTOM") || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        for (String string : race.getTypeList(false)) {
            if (string.equals("CUSTOM")) continue;
            arrayList2.add(string);
            arrayList.remove(string);
        }
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        arrayList.clear();
        arrayList.add("(None)");
        for (PCClass pCClass : Globals.getClassList()) {
            if (!pCClass.isMonster()) continue;
            arrayList.add(pCClass.getKeyName());
        }
        this.setMonsterClassList(arrayList);
        this.setBonusFeats(0);
        this.setBonusSkillPoints(race.getBonusSkillsPerLevel());
        this.setCR(race.getCR());
        this.setDisplayName(race.getDisplayName());
        this.setHands(race.getHands());
        this.setHitDiceAdvancement(race);
        this.setLegs(race.getLegs());
        this.setLevelAdjustment(race.getLevelAdjustmentFormula());
        this.setMonsterClass(race.getMonsterClass(null, false));
        this.setMonsterLevel(race.getMonsterClassLevels(null, false));
        this.setRaceSize(race.getSize());
        this.setReach(race.getReach());
        this.setSkillMultiplier(race.getInitialSkillMultiplier());
        this.setHitDiceNumber(race.hitDice(null, false));
        this.setHitDiceSize(race.getHitDiceSize(null, false));
    }

    private static GridBagConstraints buildConstraints(int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        return gridBagConstraints;
    }

    private void initComponentContents() {
        int n;
        this.cmbSize.setModel(new DefaultComboBoxModel<String>(sizeTitles));
        String[] stringArray = new String[20];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n);
        }
        this.cmbBonusSkillPoints.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbBonusFeats.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbLegs.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbHands.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbSkillMult.setModel(new DefaultComboBoxModel<String>(stringArray));
        stringArray = new String[10];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n * 5);
        }
        this.cmbReach.setModel(new DefaultComboBoxModel<String>(stringArray));
        stringArray = new String[40];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n);
        }
        this.cmbMonsterLevel.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbHitDiceNumber.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbHitDiceSize.setModel(new DefaultComboBoxModel<String>(hitDiceSizeValues));
        this.cmbCR.setModel(new DefaultComboBoxModel<String>(crValues));
    }

    private void initComponents() {
        this.cmbBonusSkillPoints = new JComboBoxEx();
        this.cmbBonusFeats = new JComboBoxEx();
        this.cmbCR = new JComboBoxEx();
        this.txtDisplayName = new JTextField();
        this.cmbHands = new JComboBoxEx();
        this.txtHitDiceAdvancement = new JTextField();
        this.cmbHitDiceNumber = new JComboBoxEx();
        this.cmbHitDiceSize = new JComboBoxEx();
        this.cmbLegs = new JComboBoxEx();
        this.txtLevelAdj = new JTextField();
        this.cmbMonsterClass = new JComboBoxEx();
        this.cmbMonsterLevel = new JComboBoxEx();
        this.cmbReach = new JComboBoxEx();
        this.cmbSize = new JComboBoxEx();
        this.cmbSkillMult = new JComboBoxEx();
        this.pnlTemplateMisc = new JPanel();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlTemplateMisc.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Display Name");
        GridBagConstraints gridBagConstraints = RaceBasePanel.buildConstraints(0, 0);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtDisplayName, gridBagConstraints);
        jLabel = new JLabel("Hands");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 1);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 1);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbHands, gridBagConstraints);
        jLabel = new JLabel("Legs");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 1);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 1);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbLegs, gridBagConstraints);
        jLabel = new JLabel("Reach");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 2);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 2);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbReach, gridBagConstraints);
        jLabel = new JLabel("Skill Multiplier");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 2);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 2);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSkillMult, gridBagConstraints);
        jLabel = new JLabel("Bonus Skill Pts / Level");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 3);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 3);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusSkillPoints, gridBagConstraints);
        jLabel = new JLabel("Bonus Starting Feats");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 3);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 3);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusFeats, gridBagConstraints);
        jLabel = new JLabel("CR");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 4);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        this.cmbCR.setEditable(true);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 4);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbCR, gridBagConstraints);
        jLabel = new JLabel("Level Adjustment");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 4);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 4);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtLevelAdj, gridBagConstraints);
        jLabel = new JLabel("Size");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 5);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSize, gridBagConstraints);
        jLabel = new JLabel("Hit Dice Advancement");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 5);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtHitDiceAdvancement, gridBagConstraints);
        jLabel = new JLabel("Monster Class");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 6);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 6);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbMonsterClass, gridBagConstraints);
        jLabel = new JLabel("Monster Level");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 6);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 6);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbMonsterLevel, gridBagConstraints);
        jLabel = new JLabel("Number of Hit Dice");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 7);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 7);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbHitDiceNumber, gridBagConstraints);
        jLabel = new JLabel("Hit Dice Size");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 7);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 7);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbHitDiceSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlTemplateMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

