/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SkillBasePanel
extends BasePanel {
    private static final String[] acheckValues = new String[]{"No", "Yes", "Non-proficiency", "Weight"};
    private JCheckBox chkExclusive;
    private JCheckBox chkUntrained;
    private JComboBoxEx cmbArmorCheck;
    private JComboBoxEx cmbKeyStat;
    private JLabel lblArmorCheck;
    private JLabel lblKeyStat;
    private JPanel pnlSkillMisc;
    private TypePanel pnlSkillType;

    public SkillBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setArmorCheck(int n) {
        if (n >= 0 && n < acheckValues.length) {
            this.cmbArmorCheck.setSelectedItem(acheckValues[n]);
        }
    }

    public int getArmorCheck() {
        return this.cmbArmorCheck.getSelectedIndex();
    }

    public void setIsExclusive(boolean bl) {
        this.chkExclusive.setSelected(bl);
    }

    public boolean getIsExclusive() {
        return this.chkExclusive.isSelected();
    }

    public void setIsUntrained(boolean bl) {
        this.chkUntrained.setSelected(bl);
    }

    public boolean getIsUntrained() {
        return this.chkUntrained.isSelected();
    }

    public void setKeyStat(String string) {
        if (string.length() == 0) {
            this.cmbKeyStat.setSelectedItem("None");
        } else {
            for (int i = SettingsHandler.getGame().getUnmodifiableStatList().size() - 1; i >= 0; --i) {
                PCStat pCStat = SettingsHandler.getGame().getUnmodifiableStatList().get(i);
                if (!pCStat.getAbb().equals(string)) continue;
                this.cmbKeyStat.setSelectedItem(pCStat.getKeyName());
                break;
            }
        }
    }

    public String getKeyStat() {
        int n = this.cmbKeyStat.getSelectedIndex() - 1;
        if (n < 0) {
            return "";
        }
        return SettingsHandler.getGame().getUnmodifiableStatList().get(n).getAbb();
    }

    public void setTypesAvailableList(List<String> list, boolean bl) {
        this.pnlSkillType.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<String> list, boolean bl) {
        this.pnlSkillType.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlSkillType.getSelectedList();
    }

    @Override
    public void updateData(PObject pObject) {
        Skill skill = (Skill)pObject;
        Object[] objectArray = this.getTypesSelectedList();
        pObject.setTypeInfo(".CLEAR");
        for (int i = 0; i < objectArray.length; ++i) {
            skill.setTypeInfo(objectArray[i].toString());
        }
        skill.setUntrained(this.getIsUntrained());
        skill.setIsExclusive(this.getIsExclusive());
        skill.setKeyStat(this.getKeyStat());
        skill.setACheck(this.getArmorCheck());
    }

    @Override
    public void updateView(PObject pObject) {
        Skill skill = (Skill)pObject;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Skill object : Globals.getSkillList()) {
            for (String string : object.getTypeList(false)) {
                if (string.equals("CUSTOM") || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        for (String string : skill.getTypeList(false)) {
            if (string.equals("CUSTOM")) continue;
            arrayList2.add(string);
            arrayList.remove(string);
        }
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        this.setKeyStat(skill.getKeyStat());
        this.setArmorCheck(skill.getACheck());
        this.setIsExclusive(skill.isExclusive());
        this.setIsUntrained(skill.isUntrained());
    }

    private void initComponentContents() {
        ArrayList<String> arrayList = new ArrayList<String>(SettingsHandler.getGame().getUnmodifiableStatList().size() + 1);
        arrayList.add("None");
        Iterator<PCStat> iterator = SettingsHandler.getGame().getUnmodifiableStatList().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getKeyName());
        }
        this.cmbKeyStat.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.cmbArmorCheck.setModel(new DefaultComboBoxModel<String>(acheckValues));
    }

    private void initComponents() {
        this.pnlSkillMisc = new JPanel();
        this.lblKeyStat = new JLabel();
        this.cmbKeyStat = new JComboBoxEx();
        this.lblArmorCheck = new JLabel();
        this.cmbArmorCheck = new JComboBoxEx();
        this.chkUntrained = new JCheckBox();
        this.chkExclusive = new JCheckBox();
        this.pnlSkillType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlSkillMisc.setLayout(new GridBagLayout());
        this.lblKeyStat.setText("Key Stat");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlSkillMisc.add((Component)this.lblKeyStat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlSkillMisc.add((Component)this.cmbKeyStat, gridBagConstraints);
        this.lblArmorCheck.setText("Armor Check");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlSkillMisc.add((Component)this.lblArmorCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlSkillMisc.add((Component)this.cmbArmorCheck, gridBagConstraints);
        this.chkUntrained.setText("Use Untrained");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlSkillMisc.add((Component)this.chkUntrained, gridBagConstraints);
        this.chkExclusive.setText("Exclusive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlSkillMisc.add((Component)this.chkExclusive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlSkillMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSkillType, gridBagConstraints);
    }
}

