/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Campaign;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Source;
import pcgen.core.SourceEntry;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;

class SourceBasePanel
extends BasePanel {
    static final long serialVersionUID = -8057486950329356072L;
    private Campaign theCampaign = null;
    private JCheckBox isD20;
    private JCheckBox isLicensed;
    private JCheckBox isOGL;
    private JCheckBox showInMenu;
    private JCheckBox gm35e;
    private JCheckBox gm3e;
    private JCheckBox gmmodern;
    private JCheckBox gmspycraft;
    private JCheckBox gmxcrawl;
    private JCheckBox gmsidewinder;
    private JComboBoxEx bookType;
    private JScrollPane scrollPane;
    private JTableEx sourceTable;
    private JTextField destination;
    private String game;
    private JTextField genre;
    private JTextField infoText;
    private JTextField pubNameLong;
    private JTextField pubNameShort;
    private JTextField pubNameWeb;
    private JTextField setting;
    private SourceTableModel sourceModel;
    private JSpinner rank;

    public SourceBasePanel() {
        this.initComponents();
        this.intComponentContents();
    }

    public void updateData(PObject pObject) {
        this.theCampaign.setRank(Integer.parseInt(this.rank.getValue().toString()));
        this.game = "";
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.gm35e.isSelected()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("35e");
            } else {
                stringBuffer.append("|35e");
            }
        }
        if (this.gm3e.isSelected()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("3e");
            } else {
                stringBuffer.append("|3e");
            }
        }
        if (this.gmmodern.isSelected()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("Modern");
            } else {
                stringBuffer.append("|Modern");
            }
        }
        if (this.gmspycraft.isSelected()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("Spycraft");
            } else {
                stringBuffer.append("|Spycraft");
            }
        }
        if (this.gmxcrawl.isSelected()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("XCrawl");
            } else {
                stringBuffer.append("|XCrawl");
            }
        }
        if (this.gmsidewinder.isSelected()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("Sidewinder");
            } else {
                stringBuffer.append("|Sidewinder");
            }
        }
        this.game = stringBuffer.toString();
        this.theCampaign.setGameMode(this.game);
        Source source = new Source();
        source.setLongName(this.pubNameLong.getText().trim());
        source.setShortName(this.pubNameShort.getText().trim());
        source.setWebsite(this.pubNameWeb.getText().trim());
        this.theCampaign.setSource(new SourceEntry(source));
        this.theCampaign.setIsOGL(this.isOGL.getSelectedObjects() != null);
        this.theCampaign.setIsD20(this.isD20.getSelectedObjects() != null);
        this.theCampaign.setShowInMenu(this.showInMenu.getSelectedObjects() != null);
        this.theCampaign.setIsLicensed(this.isLicensed.getSelectedObjects() != null);
        this.theCampaign.setInfoText(this.infoText.getText().trim());
        this.theCampaign.setBookType(this.bookType.getSelectedItem().toString());
        this.theCampaign.setDestination(this.destination.getText().trim());
        this.theCampaign.addLicense(".CLEAR");
        this.theCampaign.addSection15(".CLEAR");
        this.theCampaign.setSetting(this.setting.getText().trim());
        this.theCampaign.setGenre(this.genre.getText().trim());
        Properties properties = new Properties();
        for (int i = 0; i < this.sourceModel.getOptionList().size(); ++i) {
            properties.setProperty(this.sourceModel.getOptionList().get(i).toString(), this.sourceModel.getOptionValues().get(i));
        }
        this.theCampaign.setOptions(properties);
        Iterator<String> iterator = this.sourceModel.getLicenseList().iterator();
        while (iterator.hasNext()) {
            this.theCampaign.addLicense(iterator.next());
        }
        iterator = this.sourceModel.getCopyrightList().iterator();
        while (iterator.hasNext()) {
            this.theCampaign.addSection15(iterator.next());
        }
    }

    public void updateView(PObject pObject) {
        Object object;
        if (!(pObject instanceof Campaign)) {
            return;
        }
        this.theCampaign = (Campaign)pObject;
        this.sourceModel.setLists(this.theCampaign.getOptionsList(), this.theCampaign.getLicenses(), this.theCampaign.getSection15s());
        this.rank.setValue(this.theCampaign.getRank());
        this.game = this.theCampaign.getGameModeString();
        StringTokenizer stringTokenizer = new StringTokenizer(this.game, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if ("35e".equals(object)) {
                this.gm35e.setSelected(true);
                continue;
            }
            if ("3e".equals(object)) {
                this.gm3e.setSelected(true);
                continue;
            }
            if ("Modern".equals(object)) {
                this.gmmodern.setSelected(true);
                continue;
            }
            if ("Spycraft".equals(object)) {
                this.gmspycraft.setSelected(true);
                continue;
            }
            if ("XCrawl".equals(object)) {
                this.gmxcrawl.setSelected(true);
                continue;
            }
            if (!"Sidewinder".equals(object)) continue;
            this.gmsidewinder.setSelected(true);
        }
        object = this.theCampaign.getSourceEntry().getSourceBook();
        if (object != null) {
            this.pubNameLong.setText(((Source)object).getLongName());
            this.pubNameShort.setText(((Source)object).getShortName());
            this.pubNameWeb.setText(((Source)object).getWebsite());
        }
        this.pubNameLong.setCaretPosition(0);
        this.pubNameShort.setCaretPosition(0);
        this.pubNameWeb.setCaretPosition(0);
        this.isOGL.setSelected(this.theCampaign.isOGL());
        this.isD20.setSelected(this.theCampaign.isD20());
        this.isLicensed.setSelected(this.theCampaign.isLicensed());
        this.showInMenu.setSelected(this.theCampaign.canShowInMenu());
        this.infoText.setText(this.theCampaign.getInfoText());
        this.infoText.setCaretPosition(0);
        this.bookType.setSelectedItem(this.theCampaign.getBookType());
        this.setting.setText(this.theCampaign.getSetting());
        this.setting.setCaretPosition(0);
        this.genre.setText(this.theCampaign.getGenre());
        this.genre.setCaretPosition(0);
        String string = this.theCampaign.getDestination();
        if (string.equals("") && this.theCampaign.getSourceURI() != null) {
            URI uRI = this.theCampaign.getSourceURI();
            string = uRI.getPath();
            string = string.replace('\\', File.separator.charAt(0));
            string = string.replace('/', File.separator.charAt(0));
            String string2 = SettingsHandler.getPccFilesLocation().toString();
            string2 = string2.replace('\\', File.separator.charAt(0));
            if (string.startsWith(string2 = string2.replace('/', File.separator.charAt(0)))) {
                string = string.substring(string2.length() + 1);
            }
            this.destination.setText(string);
        } else {
            this.destination.setText(this.theCampaign.getDestination());
        }
        this.destination.setCaretPosition(0);
    }

    private void addCopyright() {
        this.sourceModel.addCopyright();
    }

    private void addLicense() {
        this.sourceModel.addLicense();
    }

    private void addOption() {
        this.sourceModel.addOption();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.sourceTable = new JTableEx();
        this.sourceModel = new SourceTableModel();
        this.gm35e = new JCheckBox("35e");
        this.gm3e = new JCheckBox("3e");
        this.gmmodern = new JCheckBox("MSRD Modern");
        this.gmspycraft = new JCheckBox("Spycraft");
        this.gmxcrawl = new JCheckBox("XCrawl");
        this.gmsidewinder = new JCheckBox("Sidewinder");
        this.infoText = new JTextField();
        this.infoText.setHorizontalAlignment(2);
        this.pubNameWeb = new JTextField();
        this.pubNameWeb.setHorizontalAlignment(2);
        this.pubNameShort = new JTextField();
        this.pubNameShort.setHorizontalAlignment(2);
        this.pubNameLong = new JTextField();
        this.pubNameLong.setHorizontalAlignment(2);
        this.setting = new JTextField();
        this.setting.setHorizontalAlignment(2);
        this.destination = new JTextField();
        this.destination.setHorizontalAlignment(2);
        this.genre = new JTextField();
        this.genre.setHorizontalAlignment(2);
        this.isOGL = new JCheckBox("OGL");
        this.isD20 = new JCheckBox("D20");
        this.showInMenu = new JCheckBox("In Menu");
        this.isLicensed = new JCheckBox("Licensed");
        this.bookType = new JComboBoxEx();
        this.bookType.setEditable(true);
        this.bookType.addItem("Campaign Setting");
        this.bookType.addItem("Core Rulebook ");
        this.bookType.addItem("Magazine");
        this.bookType.addItem("Module");
        this.bookType.addItem("Sourcebook");
        this.bookType.addItem("Supplement");
        this.bookType.addItem("Web Enhancement");
        this.bookType.setSelectedIndex(0);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Rank is a number between 1 and 9. Higher Rank loads before lower Rank. Rank 1 highest.");
        JLabel jLabel2 = new JLabel(SettingsHandler.getPccFilesLocation().toString());
        int n = 1;
        int n2 = 9;
        int n3 = 1;
        int n4 = 9;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n4, n, n2, n3);
        this.rank = new JSpinner(spinnerNumberModel);
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SourceBasePanel.this.destination.getText();
                String string2 = "";
                if (SourceBasePanel.this.theCampaign != null) {
                    string2 = SourceBasePanel.this.theCampaign.getDestination();
                }
                if (string2 == null || string2.equals("")) {
                    string2 = SettingsHandler.getPccFilesLocation().toString().concat("\\").concat(string);
                }
                final JFileChooser jFileChooser = new JFileChooser();
                File file = jFileChooser.getCurrentDirectory();
                jFileChooser.setDialogTitle("" + file.getAbsolutePath());
                jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                            File file = jFileChooser.getCurrentDirectory();
                            jFileChooser.setDialogTitle("" + file.getAbsolutePath());
                        }
                    }
                });
                jFileChooser.setCurrentDirectory(new File(string2));
                int n = jFileChooser.showOpenDialog(SourceBasePanel.this);
                if (n == 0) {
                    string = jFileChooser.getSelectedFile().toString();
                    if (string.startsWith(SettingsHandler.getPccFilesLocation().toString())) {
                        string = string.substring(SettingsHandler.getPccFilesLocation().toString().length() + 1);
                    } else if (string.startsWith(SourceBasePanel.this.theCampaign.getSourceURI().toString())) {
                        string = string.substring(SourceBasePanel.this.theCampaign.getSourceURI().toString().length() + 1);
                    }
                }
                SourceBasePanel.this.destination.setText(string);
            }
        });
        jPanel.add((Component)new JLabel("Location of file"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.rank, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gm35e, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gm3e, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmmodern, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmspycraft, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmxcrawl, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmsidewinder, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(8, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Info Text"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Game Mode"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Pub Name Web"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Pub Name Long"), new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Pub Name Short"), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Setting"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Genre"), new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Book Type"), new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Rank"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Current Directory that Location of file is relative to:"), new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(4, 5, 5, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 5, 5), 0, 0));
        jPanel.add((Component)this.infoText, new GridBagConstraints(1, 0, 8, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 5, 5), 0, 0));
        jPanel.add((Component)this.pubNameWeb, new GridBagConstraints(1, 2, 2, 1, 0.8, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.pubNameLong, new GridBagConstraints(7, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 5), 0, 0));
        jPanel.add((Component)this.pubNameShort, new GridBagConstraints(4, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.setting, new GridBagConstraints(1, 3, 2, 1, 0.8, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.genre, new GridBagConstraints(4, 3, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.bookType, new GridBagConstraints(7, 3, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 5), 0, 0));
        jPanel.add((Component)this.destination, new GridBagConstraints(1, 6, 7, 1, 0.9, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(2, 4, 7, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, "North");
        this.sourceTable.setModel(this.sourceModel);
        this.sourceTable.setSelectionMode(0);
        this.sourceTable.setDoubleBuffered(false);
        this.scrollPane.setViewportView(this.sourceTable);
        this.add((Component)this.scrollPane, "Center");
        jPanel = new JPanel();
        final JComboBoxEx jComboBoxEx = new JComboBoxEx();
        jComboBoxEx.addItem("COPYRIGHT");
        jComboBoxEx.addItem("LICENSE");
        jComboBoxEx.addItem("OPTION");
        jComboBoxEx.setSelectedIndex(0);
        jPanel.add(jComboBoxEx);
        JButton jButton2 = new JButton("Add Tag");
        jButton2.setToolTipText("Adds the specified tag line in .pcc file");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (jComboBoxEx.getSelectedIndex()) {
                    case 0: {
                        SourceBasePanel.this.addCopyright();
                        break;
                    }
                    case 1: {
                        SourceBasePanel.this.addLicense();
                        break;
                    }
                    case 2: {
                        SourceBasePanel.this.addOption();
                    }
                }
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        jPanel.add(jButton2);
        jButton2 = new JButton("Remove Tag");
        jButton2.setToolTipText("Removes selected tag line from being inserted in .pcc file");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceBasePanel.this.removeLine();
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        jPanel.add(jButton2);
        jPanel.add(this.showInMenu);
        jPanel.add(this.isLicensed);
        jPanel.add(this.isOGL);
        jPanel.add(this.isD20);
        this.add((Component)jPanel, "South");
    }

    private void intComponentContents() {
    }

    private void removeLine() {
        this.sourceModel.removeLine(this.sourceTable.getSelectedRow());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SourceTableModel
    extends AbstractTableModel {
        List<String> copyrightList = null;
        List<String> licenseList = null;
        List<String> optionList = null;
        List<String> optionValues = null;

        SourceTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n < this.optionList.size() || n2 == 1;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Label";
                }
                case 1: {
                    return "Value";
                }
            }
            return "Out Of Bounds";
        }

        public List<String> getCopyrightList() {
            return this.copyrightList;
        }

        public List<String> getLicenseList() {
            return this.licenseList;
        }

        public void setLists(List<String> arrayList, List<String> arrayList2, List<String> arrayList3) {
            this.optionList = arrayList == null ? new ArrayList() : arrayList;
            this.optionValues = new ArrayList<String>();
            if (this.optionList != null) {
                for (String string : this.optionList) {
                    String string2 = SourceBasePanel.this.theCampaign.getOptions().getProperty(string);
                    this.optionValues.add(string2);
                }
            }
            this.licenseList = arrayList2 == null ? new ArrayList() : arrayList2;
            this.copyrightList = arrayList3 == null ? new ArrayList() : arrayList3;
        }

        public List<String> getOptionList() {
            return this.optionList;
        }

        public List<String> getOptionValues() {
            return this.optionValues;
        }

        @Override
        public int getRowCount() {
            if (SourceBasePanel.this.theCampaign == null) {
                return 0;
            }
            return this.optionList.size() + this.licenseList.size() + this.copyrightList.size();
        }

        public void setValueAt(String string, int n, int n2) {
            if (n < this.optionList.size()) {
                String string2 = string;
                if (n2 == 0 && string2.startsWith("OPTION:")) {
                    string2 = string2.substring(7);
                }
                if (n2 == 0) {
                    this.optionList.set(n, string2);
                } else if (n2 == 1) {
                    this.optionValues.set(n, string2);
                }
                return;
            }
            if ((n -= this.optionList.size()) < this.copyrightList.size()) {
                this.copyrightList.set(n, string);
                return;
            }
            if ((n -= this.copyrightList.size()) < this.licenseList.size()) {
                this.licenseList.set(n, string);
                return;
            }
        }

        @Override
        public String getValueAt(int n, int n2) {
            if (n < this.optionList.size()) {
                String string = this.optionList.get(n);
                if (n2 == 0) {
                    return "OPTION:" + string;
                }
                return this.optionValues.get(n);
            }
            if ((n -= this.optionList.size()) < this.copyrightList.size()) {
                if (n2 == 0) {
                    return "COPYRIGHT:";
                }
                return this.copyrightList.get(n);
            }
            if ((n -= this.copyrightList.size()) < this.licenseList.size()) {
                if (n2 == 0) {
                    return "LICENSE:";
                }
                return this.licenseList.get(n);
            }
            return "";
        }

        public void addCopyright() {
            this.copyrightList.add("");
        }

        public void addLicense() {
            this.licenseList.add("");
        }

        public void addOption() {
            this.optionList.add("");
            this.optionValues.add("");
        }

        public void removeLine(int n) {
            if (n < 0) {
                return;
            }
            if (n < this.optionList.size()) {
                this.optionList.remove(n);
                this.optionValues.remove(n);
                return;
            }
            if ((n -= this.optionList.size()) < this.copyrightList.size()) {
                this.copyrightList.remove(n);
                return;
            }
            if ((n -= this.copyrightList.size()) < this.licenseList.size()) {
                this.licenseList.remove(n);
            }
        }
    }
}

