/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Vision;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VisionPanel
extends JPanel {
    static final long serialVersionUID = 7340632645513314167L;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBoxEx cmbVisionType;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtVisionDistance;

    VisionPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    void setSelectedList(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addToSelectedLst((String)list.get(i));
        }
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstSelected.getModel()).getElements();
    }

    List<Vision> getVision() {
        ArrayList<Vision> arrayList = new ArrayList<Vision>();
        for (Object object : this.getSelectedList()) {
            String string = (String)object;
            int n = string.indexOf(",");
            VisionType visionType = VisionType.getVisionType(string.substring(0, n));
            arrayList.add(new Vision(visionType, string.substring(n + 1)));
        }
        return arrayList;
    }

    private void addToSelectedLst(String string) {
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        int n = jListModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object object = jListModel.getElementAt(i);
            if (!((String)object).startsWith(string.substring(0, string.indexOf(",")))) continue;
            jListModel.removeElement(object);
            --n;
        }
        jListModel.addElement(string);
    }

    private void btnAddActionPerformed() {
        String string = (String)this.cmbVisionType.getSelectedItem();
        if (string == null || string.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demVisionInfoMissing"), "PCGen", MessageType.ERROR);
            return;
        }
        String string2 = (String)this.cmbVisionType.getSelectedItem() + ",";
        string2 = this.txtVisionDistance.getText().trim().length() == 0 ? string2 + "0" : string2 + this.txtVisionDistance.getText().trim();
        this.addToSelectedLst(string2);
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        Object[] objectArray = this.lstSelected.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            jListModel.removeElement(objectArray[i]);
        }
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        this.cmbVisionType = new JComboBoxEx(new String[]{"Normal", "Low-light", "Keen Low-light", "Darkvision", "Blindsight", "Keen Scent", "Tremorsense"});
        this.cmbVisionType.setEditable(true);
        this.txtVisionDistance = new JTextField();
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exception) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblSelected = new JLabel(PropertyFactory.getString("in_selected"));
        this.lstSelected = new JList(new JListModel(new ArrayList(), true));
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, PropertyFactory.getString("in_demTag"));
        titledBorder.setTitleJustification(1);
        this.pnlAvailable.setBorder(titledBorder);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_demVisionType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbVisionType, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_demDistance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtVisionDistance, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisionPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisionPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                VisionPanel.this.lstSelectedMouseClicked(mouseEvent);
            }
        });
        this.lstSelected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (VisionPanel.this.lstSelected.getSelectedIndex() >= 0) {
                    VisionPanel.this.lstSelected.ensureIndexIsVisible(VisionPanel.this.lstSelected.getSelectedIndex());
                }
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.lstSelected)) {
            String string = (String)this.lstSelected.getSelectedValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            this.cmbVisionType.setSelectedItem(stringTokenizer.nextToken());
            this.txtVisionDistance.setText(stringTokenizer.nextToken());
            if (EditUtil.isDoubleClick(mouseEvent, this.lstSelected, this.btnRemove)) {
                this.btnRemoveActionPerformed();
            }
        }
    }
}

