/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.gui.filter.CustomFilter;
import pcgen.gui.filter.FilterConstants;
import pcgen.gui.filter.PObjectFilter;
import pcgen.util.PropertyFactory;

final class CompoundFilter
extends AbstractPObjectFilter
implements CustomFilter,
FilterConstants {
    private PObjectFilter filter1;
    private PObjectFilter filter2;
    private String connect;

    CompoundFilter(PObjectFilter pObjectFilter, PObjectFilter pObjectFilter2, String string) {
        this.connect = string.trim().toUpperCase();
        this.filter1 = pObjectFilter;
        this.filter2 = pObjectFilter2;
        this.setCategory(PropertyFactory.getString("in_custom"));
        this.setName("(" + this.filter1.getName() + " " + this.connect.toLowerCase() + " " + this.filter2.getName() + ")");
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if ("AND".equals(this.connect)) {
            return this.filter1.accept(playerCharacter, pObject) && this.filter2.accept(playerCharacter, pObject);
        }
        if ("OR".equals(this.connect)) {
            return this.filter1.accept(playerCharacter, pObject) || this.filter2.accept(playerCharacter, pObject);
        }
        return false;
    }

    public String toString() {
        return "((" + this.filter1.toString() + ") " + this.connect.toLowerCase() + " (" + this.filter2.toString() + "))";
    }
}

