/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.PObjectFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterAdapterPanel
extends JPanel
implements Filterable {
    private List<PObjectFilter> availableFilters = new ArrayList<PObjectFilter>(0);
    private List<PObjectFilter> removedFilters = new ArrayList<PObjectFilter>(0);
    private List<PObjectFilter> selectedFilters = new ArrayList<PObjectFilter>(0);
    private int filterMode = 0;

    @Override
    public final List<PObjectFilter> getAvailableFilters() {
        return this.availableFilters;
    }

    @Override
    public final void setFilterMode(int n) {
        this.filterMode = n;
    }

    @Override
    public final int getFilterMode() {
        return this.filterMode;
    }

    @Override
    public final List<PObjectFilter> getRemovedFilters() {
        return this.removedFilters;
    }

    @Override
    public final List<PObjectFilter> getSelectedFilters() {
        return this.selectedFilters;
    }

    public final void registerFilter(PObjectFilter pObjectFilter) {
        if (pObjectFilter != null) {
            this.availableFilters.add(pObjectFilter);
        }
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return false;
    }

    @Override
    public boolean isNegateEnabled() {
        return false;
    }

    @Override
    public int getSelectionMode() {
        return -1;
    }

    @Override
    public abstract void initializeFilters();

    @Override
    public abstract void refreshFiltering();

    @Override
    public final boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        int n = this.getFilterMode();
        for (PObjectFilter pObjectFilter : this.getSelectedFilters()) {
            if (n == 0 && !pObjectFilter.accept(playerCharacter, pObject)) {
                return false;
            }
            if (n == 1 && !pObjectFilter.accept(playerCharacter, pObject)) {
                return true;
            }
            if (n == 2 && pObjectFilter.accept(playerCharacter, pObject)) {
                return true;
            }
            if (n != 3 || !pObjectFilter.accept(playerCharacter, pObject)) continue;
            return false;
        }
        if (n == 0 || n == 3) {
            return true;
        }
        if (n == 2 || n == 1) {
            return this.getSelectedFilters().size() == 0;
        }
        return true;
    }
}

