/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import pcgen.core.Constants;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.CustomFilter;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.FilterList;
import pcgen.gui.filter.FilterNameDialog;
import pcgen.gui.filter.FilterParseException;
import pcgen.gui.filter.FilterParser;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GBLPanel;
import pcgen.gui.filter.NamedFilter;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.filter.SortedListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FilterEditorDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 6455344467032929848L;
    private static final String HELP_MESSAGE = PropertyFactory.getString("in_filterHelpMessage");
    private FilterList customList;
    private FilterList standardList;
    private final FilterNameDialog filterNameDialog = new FilterNameDialog();
    private Filterable filterable;
    private JButton addCustomButton;
    private JButton addStandardButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton clearButton;
    private JButton createButton;
    private JButton deleteButton;
    private JTextArea editorArea;
    private List customFilters = new ArrayList();
    private Map<String, String> customFiltersOrigin = new HashMap<String, String>();
    private SortedListModel customModel;
    private SortedListModel standardModel;

    public FilterEditorDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filterCustom"));
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block12: {
            Object object;
            block16: {
                PObjectFilter pObjectFilter;
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                object = actionEvent.getSource();
                                if (!object.equals(this.addStandardButton)) break block11;
                                int[] nArray = this.standardList.getSelectedIndices();
                                for (int i = 0; i < nArray.length; ++i) {
                                    PObjectFilter pObjectFilter2 = (PObjectFilter)this.standardModel.get(nArray[i]);
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append(Constants.s_LINE_SEP).append("[").append(pObjectFilter2.getCategory()).append(" :  ");
                                    stringBuffer.append(pObjectFilter2.getName()).append("]");
                                    this.editorArea.append(stringBuffer.toString());
                                }
                                break block12;
                            }
                            if (!object.equals(this.addCustomButton)) break block13;
                            int[] nArray = this.customList.getSelectedIndices();
                            for (int i = 0; i < nArray.length; ++i) {
                                PObjectFilter pObjectFilter3 = (PObjectFilter)this.customModel.get(nArray[i]);
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(Constants.s_LINE_SEP).append("[").append(pObjectFilter3.getCategory()).append(" :  ");
                                stringBuffer.append(pObjectFilter3.getName()).append("]");
                                this.editorArea.append(stringBuffer.toString());
                            }
                            break block12;
                        }
                        if (!object.equals(this.applyButton)) break block14;
                        if (this.filterable != null) {
                            this.storeFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters());
                            FilterDialogFactory.setFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters());
                            SettingsHandler.storeFilterSettings(this.filterable);
                            PCGen_Frame1.restoreFilterSettings(this.filterable.getName());
                            this.filterable = null;
                        }
                        this.setVisible(false);
                        break block12;
                    }
                    if (!object.equals(this.cancelButton)) break block15;
                    if (this.filterable != null) {
                        this.unStoreFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters());
                    }
                    this.filterable = null;
                    this.setVisible(false);
                    break block12;
                }
                if (!object.equals(this.createButton)) break block16;
                try {
                    pObjectFilter = new FilterParser(new List[]{this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters(), this.customFilters}).parse(this.editorArea.getText());
                }
                catch (FilterParseException filterParseException) {
                    pObjectFilter = null;
                    Logging.errorPrint("Error in FilterDialogFactory::actionPerformed", filterParseException);
                    ShowMessageDelegate.showMessageDialog(filterParseException.getMessage(), PropertyFactory.getString("in_error"), MessageType.ERROR);
                }
                if (pObjectFilter == null) break block12;
                this.filterNameDialog.setIllegalNames(this.createIllegalNamesList());
                this.filterNameDialog.setVisible(true);
                if ((this.filterNameDialog.getName() + this.filterNameDialog.getDescription()).length() > 0) {
                    pObjectFilter = FilterFactory.createNamedFilter(pObjectFilter, this.filterNameDialog.getName(), this.filterNameDialog.getDescription());
                }
                this.customModel.addElement(pObjectFilter);
                this.customFilters.add(pObjectFilter);
                break block12;
            }
            if (object.equals(this.clearButton)) {
                this.editorArea.setText("");
            } else if (object.equals(this.deleteButton)) {
                int[] nArray = this.customList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    this.customModel.removeElementAt(nArray[i] - i);
                }
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.editorArea.setText(HELP_MESSAGE);
            this.settings(PCGen_Frame1.getCurrentFilterable());
        }
        super.setVisible(bl);
    }

    private void setFilters(List list, List list2, List list3) {
        Object e;
        this.standardModel.clear();
        this.customModel.clear();
        this.customFilters.clear();
        this.customFiltersOrigin.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof CustomFilter) {
                this.customFiltersOrigin.put(e.getClass().getName(), "available");
                this.customFilters.add(e);
                this.customModel.addElement(e);
                iterator.remove();
                continue;
            }
            this.standardModel.addElement(e);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof CustomFilter) {
                this.customFiltersOrigin.put(e.getClass().getName(), "selected");
                this.customFilters.add(e);
                this.customModel.addElement(e);
                iterator.remove();
                continue;
            }
            this.standardModel.addElement(e);
        }
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof CustomFilter) {
                this.customFiltersOrigin.put(e.getClass().getName(), "removed");
                this.customFilters.add(e);
                this.customModel.addElement(e);
                iterator.remove();
                continue;
            }
            this.standardModel.addElement(e);
        }
    }

    private void _init() {
        GBLPanel gBLPanel = new GBLPanel();
        GBLPanel gBLPanel2 = new GBLPanel();
        GBLPanel gBLPanel3 = new GBLPanel();
        ListMouseHandler listMouseHandler = new ListMouseHandler();
        Dimension dimension = new Dimension(95, 27);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.setPreferredSize(dimension);
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(PropertyFactory.getString("in_cancel"));
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        jPanel.add(this.applyButton);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        jPanel2.add(this.cancelButton);
        GBLPanel gBLPanel4 = new GBLPanel();
        gBLPanel4.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        gBLPanel4.gbc.weightx = 0.0;
        gBLPanel4.gbc.weighty = 0.0;
        gBLPanel4.gbc.fill = 0;
        gBLPanel4.add(jPanel, 0, 0, 1, 1);
        gBLPanel4.add(jPanel2, 0, 1, 1, 1);
        this.createButton = new JButton(PropertyFactory.getString("in_create"));
        this.createButton.setPreferredSize(dimension);
        this.createButton.addActionListener(this);
        this.clearButton = new JButton(PropertyFactory.getString("in_clear"));
        this.clearButton.setPreferredSize(dimension);
        this.clearButton.addActionListener(this);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        jPanel3.add(this.createButton);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        jPanel4.add(this.clearButton);
        GBLPanel gBLPanel5 = new GBLPanel();
        gBLPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        gBLPanel5.gbc.weightx = 0.0;
        gBLPanel5.gbc.weighty = 0.0;
        gBLPanel5.gbc.fill = 0;
        gBLPanel5.add(jPanel3, 0, 0, 1, 1);
        gBLPanel5.add(jPanel4, 0, 1, 1, 1);
        this.deleteButton = new JButton(PropertyFactory.getString("in_delete"));
        this.deleteButton.setPreferredSize(dimension);
        this.deleteButton.addActionListener(this);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 1));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel5.add(this.deleteButton);
        gBLPanel.gbc.anchor = 18;
        gBLPanel.gbc.weighty = 0.0;
        gBLPanel.add(new JLabel(PropertyFactory.getString("in_standardFils") + ": "), 0, 0, 1, 1);
        Dimension dimension2 = new Dimension(200, 295);
        this.standardModel = new SortedListModel();
        this.standardList = new FilterList((ListModel)this.standardModel);
        this.standardList.setSelectionMode(0);
        this.standardList.addMouseListener(listMouseHandler);
        JScrollPane jScrollPane = new JScrollPane(this.standardList);
        jScrollPane.setMinimumSize(dimension2);
        jScrollPane.setPreferredSize(dimension2);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 1));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel6.add(jScrollPane);
        this.addStandardButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.addStandardButton.addActionListener(this);
        JPanel jPanel7 = new JPanel(new GridLayout(1, 1));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel7.add(this.addStandardButton);
        gBLPanel.gbc.weightx = 0.0;
        gBLPanel.gbc.weighty = 10.0;
        gBLPanel.gbc.fill = 1;
        gBLPanel.gbc.anchor = 10;
        gBLPanel.add(jPanel6, 1, 0, 1, 1);
        gBLPanel.gbc.weighty = 0.0;
        gBLPanel.gbc.fill = 0;
        gBLPanel.gbc.anchor = 11;
        gBLPanel.add(jPanel7, 1, 1, 1, 1);
        gBLPanel2.gbc.weightx = 0.0;
        gBLPanel2.gbc.weighty = 0.0;
        gBLPanel2.gbc.fill = 0;
        gBLPanel2.gbc.anchor = 18;
        gBLPanel2.add(new JLabel(PropertyFactory.getString("in_editor") + ": "), 0, 0, 1, 1);
        Dimension dimension3 = new Dimension(dimension2.width * 2, dimension2.height);
        this.editorArea = new JTextArea();
        JScrollPane jScrollPane2 = new JScrollPane(this.editorArea);
        jScrollPane2.setMinimumSize(dimension3);
        jScrollPane2.setPreferredSize(dimension3);
        JPanel jPanel8 = new JPanel(new GridLayout(1, 1));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel8.add(jScrollPane2);
        gBLPanel2.gbc.weightx = 10.0;
        gBLPanel2.gbc.weighty = 10.0;
        gBLPanel2.gbc.fill = 1;
        gBLPanel2.gbc.anchor = 11;
        gBLPanel2.add(jPanel8, 1, 0, 1, 1);
        gBLPanel2.gbc.weighty = 0.0;
        gBLPanel2.gbc.fill = 2;
        gBLPanel2.gbc.anchor = 11;
        gBLPanel2.add(gBLPanel5, 2, 0, 1, 1);
        gBLPanel3.gbc.weighty = 0.0;
        gBLPanel3.gbc.anchor = 18;
        gBLPanel3.add(new JLabel(PropertyFactory.getString("in_customFils") + ": "), 0, 1, 1, 1);
        this.customModel = new SortedListModel();
        this.customList = new FilterList((ListModel)this.customModel);
        this.customList.setSelectionMode(0);
        this.customList.addMouseListener(listMouseHandler);
        JScrollPane jScrollPane3 = new JScrollPane(this.customList);
        jScrollPane3.setMinimumSize(dimension2);
        jScrollPane3.setPreferredSize(dimension2);
        JPanel jPanel9 = new JPanel(new GridLayout(1, 1));
        jPanel9.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel9.add(jScrollPane3);
        this.addCustomButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.addCustomButton.addActionListener(this);
        JPanel jPanel10 = new JPanel(new GridLayout(1, 1));
        jPanel10.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel10.add(this.addCustomButton);
        gBLPanel3.gbc.weightx = 0.0;
        gBLPanel3.gbc.weighty = 0.0;
        gBLPanel3.gbc.fill = 0;
        gBLPanel3.gbc.anchor = 11;
        gBLPanel3.add(jPanel10, 1, 0, 1, 1);
        gBLPanel3.gbc.weighty = 10.0;
        gBLPanel3.gbc.fill = 1;
        gBLPanel3.gbc.anchor = 10;
        gBLPanel3.add(jPanel9, 1, 1, 1, 1);
        gBLPanel3.gbc.weighty = 0.0;
        gBLPanel3.gbc.fill = 0;
        gBLPanel3.gbc.anchor = 13;
        gBLPanel3.add(jPanel5, 2, 1, 1, 1);
        GBLPanel gBLPanel6 = new GBLPanel();
        gBLPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gBLPanel6.gbc.fill = 1;
        gBLPanel6.gbc.anchor = 11;
        gBLPanel6.gbc.weighty = 10.0;
        gBLPanel6.gbc.weightx = 0.0;
        gBLPanel6.add(gBLPanel, 0, 0, 1, 1);
        gBLPanel6.gbc.weightx = 10.0;
        gBLPanel6.add(gBLPanel2, 0, 1, 1, 1);
        gBLPanel6.gbc.weightx = 0.0;
        gBLPanel6.add(gBLPanel3, 0, 2, 1, 1);
        JPanel jPanel11 = new JPanel(new BorderLayout());
        jPanel11.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel11.add((Component)gBLPanel6, "Center");
        jPanel11.add((Component)gBLPanel4, "South");
        this.setContentPane(jPanel11);
    }

    private void activateDisplayOnlyMode() {
        this.standardModel.clear();
        this.customModel.clear();
        this.standardList.setEnabled(false);
        this.customList.setEnabled(false);
        this.addStandardButton.setEnabled(false);
        this.addCustomButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.createButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    private void activateMultiMultiMode() {
        this.standardList.setSelectionMode(2);
        this.customList.setSelectionMode(2);
    }

    private List<String> createIllegalNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PObjectFilter pObjectFilter : this.customFilters) {
            if (!(pObjectFilter instanceof NamedFilter)) continue;
            arrayList.add(pObjectFilter.getName());
        }
        return arrayList;
    }

    private void init() {
        Dimension dimension = Utility.getScreenSize(Toolkit.getDefaultToolkit());
        this.setLocation(dimension.width / 24, dimension.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this._init();
        this.pack();
        this.activateMultiMultiMode();
    }

    private void settings(Filterable filterable) {
        if (filterable == null) {
            this.activateDisplayOnlyMode();
        } else {
            this.filterable = filterable;
            if (filterable.getSelectionMode() < 0) {
                this.activateDisplayOnlyMode();
                return;
            }
            this.standardList.setEnabled(true);
            this.customList.setEnabled(true);
            this.setFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters());
            this.addStandardButton.setEnabled(true);
            this.addCustomButton.setEnabled(true);
            this.applyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.createButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void storeFilters(List list, List list2, List list3) {
        Enumeration enumeration = this.customModel.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = this.customFiltersOrigin.get(e.getClass().getName());
            if (string == null || "available".equals(string)) {
                list.add(e);
                continue;
            }
            if ("selected".equals(string)) {
                list2.add(e);
                continue;
            }
            if (!"removed".equals(string)) continue;
            list3.add(e);
        }
    }

    private void unStoreFilters(List list, List list2, List list3) {
        for (Object e : this.customFilters) {
            String string = this.customFiltersOrigin.get(e.getClass().getName());
            if (string == null) continue;
            if ("available".equals(string)) {
                list.add(e);
                continue;
            }
            if ("selected".equals(string)) {
                list2.add(e);
                continue;
            }
            if (!"removed".equals(string)) continue;
            list3.add(e);
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2) {
                int n;
                if (object.equals(FilterEditorDialog.this.standardList)) {
                    int n2 = FilterEditorDialog.this.standardList.getSelectedIndex();
                    if (n2 > -1) {
                        PObjectFilter pObjectFilter = (PObjectFilter)FilterEditorDialog.this.standardModel.get(n2);
                        FilterEditorDialog.this.editorArea.append(Constants.s_LINE_SEP);
                        FilterEditorDialog.this.editorArea.append("[" + pObjectFilter.getCategory() + " :  " + pObjectFilter.getName() + "]");
                    }
                } else if (object.equals(FilterEditorDialog.this.customList) && (n = FilterEditorDialog.this.customList.getSelectedIndex()) > -1) {
                    PObjectFilter pObjectFilter = (PObjectFilter)FilterEditorDialog.this.customModel.get(n);
                    FilterEditorDialog.this.editorArea.append(Constants.s_LINE_SEP);
                    FilterEditorDialog.this.editorArea.append("[" + pObjectFilter.getCategory() + " :  " + pObjectFilter.getName() + "]");
                }
            }
        }
    }
}

