/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.filter.GBLPanel;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FilterNameDialog
extends JDialog
implements ActionListener {
    private JButton applyButton;
    private JTextArea descriptionArea;
    private JTextField nameField;
    private final List<String> illegalNamesList = new ArrayList<String>();

    public FilterNameDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filterCustom"));
        this.init();
    }

    public String getDescription() {
        return this.descriptionArea.getText().trim();
    }

    public void setIllegalNames(List<String> list) {
        this.illegalNamesList.clear();
        this.illegalNamesList.addAll(list);
    }

    @Override
    public String getName() {
        return this.nameField.getText().trim();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.nameField.getText();
        if (this.isLegalName(string)) {
            this.setVisible(false);
        } else if (this.illegalNamesList.contains(string.trim())) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_filterEr2P1", string), PropertyFactory.getString("in_filterErWarn"), MessageType.ERROR);
        } else {
            int n = FilterNameDialog.indexOfIllegalChar(string);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_filterEr3P1", String.valueOf(string.charAt(n))), PropertyFactory.getString("in_filterErWarn"), MessageType.ERROR);
            this.nameField.requestFocus();
            this.nameField.setCaretPosition(n);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.nameField.setText("");
            this.descriptionArea.setText("");
        }
        super.setVisible(bl);
    }

    private boolean isLegalName(String string) {
        return !this.illegalNamesList.contains(string.trim()) && FilterNameDialog.indexOfIllegalChar(string.trim()) == -1;
    }

    private void _init() {
        this.nameField = new JTextField();
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel.add(this.nameField);
        this.descriptionArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.descriptionArea);
        jScrollPane.setMinimumSize(new Dimension(300, 300));
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel2.add(jScrollPane);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.setMinimumSize(new Dimension(95, 27));
        this.applyButton.setPreferredSize(new Dimension(95, 27));
        this.applyButton.addActionListener(this);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel3.add(this.applyButton);
        GBLPanel gBLPanel = new GBLPanel();
        gBLPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gBLPanel.gbc.anchor = 11;
        gBLPanel.gbc.weightx = 10.0;
        gBLPanel.gbc.weighty = 0.0;
        gBLPanel.gbc.fill = 2;
        gBLPanel.add(new JLabel(PropertyFactory.getString("in_nameLabel") + ":"), 0, 0, 1, 1);
        gBLPanel.add(jPanel, 1, 0, 1, 1);
        gBLPanel.add(new JLabel(PropertyFactory.getString("in_descrip") + ":"), 2, 0, 1, 1);
        gBLPanel.gbc.weighty = 10.0;
        gBLPanel.gbc.fill = 1;
        gBLPanel.add(jPanel2, 3, 0, 1, 1);
        gBLPanel.gbc.weightx = 0.0;
        gBLPanel.gbc.weighty = 0.0;
        gBLPanel.gbc.fill = 0;
        gBLPanel.gbc.anchor = 13;
        gBLPanel.add(jPanel3, 4, 0, 1, 1);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.add((Component)gBLPanel, "Center");
        this.setContentPane(jPanel4);
    }

    private static int indexOfIllegalChar(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierStart(cArray[i]) || Character.isWhitespace(cArray[i]) || cArray[i] == '(' || cArray[i] == ')') continue;
            return i;
        }
        return -1;
    }

    private void init() {
        Dimension dimension = Utility.getScreenSize(Toolkit.getDefaultToolkit());
        this.setLocation(dimension.width / 4, dimension.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this._init();
        this.pack();
        this.setResizable(false);
    }
}

