/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Deity;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.gui.filter.AlignmentFilter;
import pcgen.util.PropertyFactory;

final class PCAlignmentFilter
extends AlignmentFilter {
    PCAlignmentFilter() {
        this(AlignmentFilter.Mode.DEFAULT);
    }

    PCAlignmentFilter(AlignmentFilter.Mode mode) {
        super(PropertyFactory.getString("in_alignLabel"), PropertyFactory.getString("in_pc"));
        this.theMode = mode;
    }

    public String getCategory() {
        if (this.theMode.equals((Object)AlignmentFilter.Mode.DEFAULT)) {
            return super.getCategory();
        }
        return super.getCategory() + " (" + this.theMode.toString() + ")";
    }

    public String getName(PlayerCharacter playerCharacter) {
        if (playerCharacter != null) {
            return super.getName(playerCharacter) + " (" + SettingsHandler.getGame().getLongAlignmentAtIndex(playerCharacter.getAlignment()) + ")";
        }
        return super.getName(playerCharacter);
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        int n = playerCharacter.getAlignment();
        if (pObject instanceof Deity) {
            String string = ((Deity)pObject).getAlignment();
            return string.equals(SettingsHandler.getGame().getShortAlignmentAtIndex(n)) || string.equals(SettingsHandler.getGame().getLongAlignmentAtIndex(n));
        }
        if (pObject instanceof PCClass) {
            return this.passesAlignmentPrereqs(pObject, n);
        }
        if (pObject instanceof PCTemplate) {
            return this.passesAlignmentPrereqs(pObject, n);
        }
        if (pObject instanceof Race) {
            return this.passesAlignmentPrereqs(pObject, n);
        }
        return true;
    }
}

