/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.Deity;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class PantheonFilter
extends AbstractPObjectFilter {
    public static final String ALL = PropertyFactory.getString("in_allPanth");
    private String pantheon;
    private Detail detailLevel;

    PantheonFilter(String string, Detail detail) {
        this.detailLevel = detail;
        this.pantheon = this.detailLevel == Detail.LOW ? PantheonFilter.normalizePantheon(string) : string;
        this.pantheon = this.pantheon.equalsIgnoreCase(ALL) ? ALL : string;
        this.setCategory(PropertyFactory.getString("in_pantheon") + (this.detailLevel == Detail.LOW ? String.format("(%1$s)", PropertyFactory.getString("in_general")) : String.format("(%1$s)", PropertyFactory.getString("in_specific"))));
        this.setName(this.pantheon);
        this.setDescription(this.pantheon.equalsIgnoreCase(ALL) ? PropertyFactory.getString("in_acceptPantAll") : PropertyFactory.getFormattedString("Filters.Pantheon.Description", this.pantheon));
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Deity) {
            Deity deity = (Deity)pObject;
            if (this.pantheon.equals(ALL) && deity.getPantheonList().size() == 0) {
                return true;
            }
            Iterator<String> iterator = deity.getPantheonList().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                if (this.detailLevel == Detail.LOW) {
                    string2 = PantheonFilter.normalizePantheon(string);
                }
                if (!this.pantheon.startsWith(string2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String normalizePantheon(String string) {
        String string2 = string;
        if (string2.indexOf("(") > 0) {
            string2 = new StringTokenizer(string2, "()").nextToken().trim();
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Detail {
        HIGH,
        LOW;

    }
}

