/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SizeFilter
extends AbstractPObjectFilter {
    private int size;

    SizeFilter(int n) {
        super(PropertyFactory.getString("in_size"), SettingsHandler.getGame().getSizeAdjustmentAtIndex(n).getDisplayName());
        this.size = n;
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Equipment) {
            String string = ((Equipment)pObject).getSize();
            return string.equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.size).getAbbreviation()) || string.equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.size).getDisplayName());
        }
        if (pObject instanceof Race) {
            String string = ((Race)pObject).getSize();
            return string.equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.size).getAbbreviation()) || string.equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.size).getDisplayName());
        }
        return true;
    }
}

