/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SourceEntry;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SourceFilter
extends AbstractPObjectFilter {
    public static final int HIGH = 0;
    public static final int LOW = 1;
    private String source;
    private int detailLevel;

    SourceFilter(String string, int n) {
        this.detailLevel = n;
        this.source = this.detailLevel == 1 ? SourceFilter.normalizeSource(string) : string;
        int n2 = this.source.indexOf(":");
        int n3 = this.source.indexOf("|");
        if (this.source.startsWith("SOURCE") && n2 > -1 && n3 > n2) {
            this.source = this.source.substring(n2 + 1, n3);
        }
        this.setCategory(PropertyFactory.getString("in_sourceLabel"));
        this.setName(this.source);
        this.setDescription(PropertyFactory.getFormattedString("in_filterAccObj", this.getName()));
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        String string = pObject.getSourceEntry().getFormattedString(SourceEntry.SourceFormat.LONG, true);
        if (this.detailLevel == 1) {
            return SourceFilter.normalizeSource(string).equals(this.source);
        }
        return string.equals(this.source);
    }

    private static String normalizeSource(String string) {
        String string2 = string;
        if (string2.indexOf(",") > -1) {
            string2 = new StringTokenizer(string, ",").nextToken();
        }
        return string2.trim();
    }
}

