/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.PropertyFactory;

final class SplitPane
extends JSplitPane {
    static final long serialVersionUID = 7077400429448626205L;

    public SplitPane() {
        this.setupExtensions();
    }

    public void setContinuousLayout(boolean bl) {
        if (bl == this.isContinuousLayout()) {
            return;
        }
        super.setContinuousLayout(bl);
        SplitPane.maybeSetContinuousLayoutComponent(this.getLeftComponent(), bl);
        SplitPane.maybeSetContinuousLayoutComponent(this.getRightComponent(), bl);
    }

    public void setEnabled(boolean bl) {
        SplitPane.maybeSetEnabledComponent(this.getLeftComponent(), bl);
        SplitPane.maybeSetEnabledComponent(this.getRightComponent(), bl);
        super.setEnabled(bl);
    }

    public void setOneTouchExpandable(boolean bl) {
        if (bl == this.isOneTouchExpandable()) {
            return;
        }
        super.setOneTouchExpandable(bl);
        SplitPane.maybeSetOneTouchExpandableComponent(this.getLeftComponent(), bl);
        SplitPane.maybeSetOneTouchExpandableComponent(this.getRightComponent(), bl);
    }

    public void setOrientation(int n) {
        if (n == this.getOrientation()) {
            return;
        }
        super.setOrientation(n);
        int n2 = SplitPane.invertOrientation(n);
        SplitPane.maybeSetOrientationComponent(this.getLeftComponent(), n2);
        SplitPane.maybeSetOrientationComponent(this.getRightComponent(), n2);
    }

    public void resetToPreferredSizes() {
        SplitPane.maybeResetToPreferredSizesComponent(this.getLeftComponent());
        SplitPane.maybeResetToPreferredSizesComponent(this.getRightComponent());
        this.fixedResetToPreferredSizes();
    }

    private static void maybeCenterDividerLocationsComponent(Component component) {
        if (component instanceof SplitPane) {
            ((SplitPane)component).centerDividerLocations();
        }
    }

    private double getDividerProportion(int n) {
        Component component = this.getLeftComponent();
        Component component2 = this.getRightComponent();
        double d = component instanceof SplitPane ? (double)((SplitPane)component).getPaneCount(n) : 1.0;
        double d2 = component2 instanceof SplitPane ? (double)((SplitPane)component2).getPaneCount(n) : 1.0;
        return d / (d + d2);
    }

    private int getPaneCount(int n) {
        SplitPane splitPane;
        Component component = this.getLeftComponent();
        Component component2 = this.getRightComponent();
        int n2 = component instanceof SplitPane ? ((splitPane = (SplitPane)component).getOrientation() == n ? splitPane.getPaneCount(n) : 1) : 1;
        int n3 = component2 instanceof SplitPane ? ((splitPane = (SplitPane)component2).getOrientation() == n ? splitPane.getPaneCount(n) : 1) : 1;
        return n2 + n3;
    }

    private void centerDividerLocations() {
        this.setDividerLocation(this.getDividerProportion(this.getOrientation()));
        SplitPane.maybeCenterDividerLocationsComponent(this.getLeftComponent());
        SplitPane.maybeCenterDividerLocationsComponent(this.getRightComponent());
    }

    private static void maybeFlipComponent(Component component) {
        if (component instanceof SplitPane) {
            ((SplitPane)component).flipOrientation();
        }
    }

    private static void maybeResetToPreferredSizesComponent(Component component) {
        if (component instanceof SplitPane) {
            ((SplitPane)component).resetToPreferredSizes();
        }
    }

    private void fixedResetToPreferredSizes() {
        this.setDividerLocation((this.getMinimumDividerLocation() + this.getMaximumDividerLocation()) / 2);
    }

    private static int invertOrientation(int n) {
        return n == 1 ? 0 : 1;
    }

    private void flipOrientation() {
        super.setOrientation(SplitPane.invertOrientation(this.getOrientation()));
        SplitPane.maybeFlipComponent(this.getLeftComponent());
        SplitPane.maybeFlipComponent(this.getRightComponent());
        this.resetToPreferredSizes();
    }

    private static void maybeSetContinuousLayoutComponent(Component component, boolean bl) {
        if (component instanceof SplitPane) {
            ((SplitPane)component).setContinuousLayout(bl);
        }
    }

    private static void maybeSetEnabledComponent(Component component, boolean bl) {
        if (component instanceof SplitPane) {
            component.setEnabled(bl);
        }
    }

    private static void maybeSetOneTouchExpandableComponent(Component component, boolean bl) {
        if (component instanceof SplitPane) {
            ((SplitPane)component).setOneTouchExpandable(bl);
        }
    }

    private static void maybeSetOrientationComponent(Component component, int n) {
        if (component instanceof SplitPane) {
            ((SplitPane)component).setOrientation(n);
        }
    }

    private void setupExtensions() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)splitPaneUI).getDivider().addMouseListener(new PopupListener());
        }
        this.setResizeWeight(0.5);
    }

    private class ResetMenuItem
    extends JMenuItem {
        ResetMenuItem() {
            super(PropertyFactory.getString("in_reset"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_reset"));
            this.setIcon(Utilities.RESET_ICON);
            this.addActionListener(new ResetActionListener());
        }
    }

    private class ResetActionListener
    implements ActionListener {
        private ResetActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplitPane.this.resetToPreferredSizes();
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Utilities.isRightMouseButton(mouseEvent)) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (SplitPane.this.isEnabled()) {
                    jPopupMenu.add(new CenterMenuItem());
                    jPopupMenu.add(new FlipMenuItem());
                    jPopupMenu.add(new ResetMenuItem());
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(new LockMenuItem());
                if (SplitPane.this.isEnabled()) {
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new OptionsMenu());
                }
                jPopupMenu.show(mouseEvent.getComponent(), n, n2);
            } else if (Utilities.isShiftLeftMouseButton(mouseEvent) && SplitPane.this.isEnabled()) {
                SplitPane.this.flipOrientation();
            }
        }
    }

    private class OptionsMenu
    extends JMenu {
        OptionsMenu() {
            super(PropertyFactory.getString("in_options"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_options"));
            this.add(new OneTouchExpandableMenuItem());
            this.add(new ContinuousLayoutMenuItem());
        }
    }

    private class OneTouchExpandableMenuItem
    extends JCheckBoxMenuItem {
        OneTouchExpandableMenuItem() {
            super(PropertyFactory.getString("in_oneTouchExp"));
            boolean bl = SplitPane.this.isOneTouchExpandable();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_oneTouchExp"));
            this.setSelected(bl);
            this.addActionListener(new OneTouchExpandableActionListener(!bl));
        }
    }

    private class OneTouchExpandableActionListener
    implements ActionListener {
        private boolean aOneTouchExpandable;

        OneTouchExpandableActionListener(boolean bl) {
            this.aOneTouchExpandable = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplitPane.this.setOneTouchExpandable(this.aOneTouchExpandable);
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem() {
            boolean bl = !SplitPane.this.isEnabled();
            this.setText(bl ? PropertyFactory.getString("in_unlock") : PropertyFactory.getString("in_lock"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(Utilities.LOCK_ICON);
            this.addActionListener(new LockActionListener(bl));
        }
    }

    private class LockActionListener
    implements ActionListener {
        private boolean enabled;

        LockActionListener(boolean bl) {
            this.enabled = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplitPane.this.setEnabled(this.enabled);
        }
    }

    private class FlipMenuItem
    extends JMenuItem {
        FlipMenuItem() {
            super(PropertyFactory.getString("in_flip"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_flip"));
            this.setIcon(Utilities.FLIP_ICON);
            this.addActionListener(new FlipActionListener());
        }
    }

    private class FlipActionListener
    implements ActionListener {
        private FlipActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplitPane.this.flipOrientation();
        }
    }

    private class ContinuousLayoutMenuItem
    extends JCheckBoxMenuItem {
        ContinuousLayoutMenuItem() {
            super(PropertyFactory.getString("in_smothRes"));
            boolean bl = SplitPane.this.isContinuousLayout();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_smothRes"));
            this.setSelected(bl);
            this.addActionListener(new ContinuousLayoutActionListener(!bl));
        }
    }

    private class ContinuousLayoutActionListener
    implements ActionListener {
        private boolean aContinuousLayout;

        ContinuousLayoutActionListener(boolean bl) {
            this.aContinuousLayout = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplitPane.this.setContinuousLayout(this.aContinuousLayout);
        }
    }

    private class CenterMenuItem
    extends JMenuItem {
        CenterMenuItem() {
            super(PropertyFactory.getString("in_center"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_center"));
            this.setIcon(Utilities.CENTER_ICON);
            this.addActionListener(new CenterActionListener());
        }
    }

    private class CenterActionListener
    implements ActionListener {
        private CenterActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplitPane.this.centerDividerLocations();
        }
    }
}

