/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.util.List;
import javax.swing.JComponent;
import pcgen.core.GameMode;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCharacterInfoTab
extends FilterAdapterPanel
implements CharacterInfoTab {
    private PlayerCharacter thePC = null;
    private int serial = 0;
    private boolean needsUpdate = true;

    public BaseCharacterInfoTab(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
        this.setName(this.getTab().toString());
    }

    @Override
    public void forceRefresh() {
        this.needsUpdate = true;
        this.updateCharacterInfo();
    }

    public final void setNeedsUpdate(boolean bl) {
        this.needsUpdate = bl;
    }

    public final boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected abstract void updateCharacterInfo();

    @Override
    public PlayerCharacter getPc() {
        return this.thePC;
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(this.getTab());
    }

    protected abstract Tab getTab();

    @Override
    public abstract int getTabOrder();

    @Override
    public abstract List<String> getToDos();

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(this.getTab());
    }

    @Override
    public void refresh() {
        if (this.thePC.getSerial() > this.serial) {
            this.serial = this.thePC.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.thePC != playerCharacter || this.thePC.getSerial() > this.serial) {
            this.thePC = playerCharacter;
            this.serial = this.thePC.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public abstract void setTabOrder(int var1);
}

