/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.LstEditorMain;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoDomain
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -4223585346813683966L;
    private static final Tab tab = Tab.DOMAINS;
    private static List<Domain> selectedDomainList = new ArrayList<Domain>();
    private static boolean needsUpdate = true;
    private static int splitOrientation = 1;
    private static final int COL_NAME = 0;
    private static final int COL_ALIGNMENT = 1;
    private static final int COL_DOMAINS = 2;
    private static final int COL_SOURCE = 3;
    private DeityModel deityModel = null;
    private DomainModel domainModel = new DomainModel();
    private FlippingSplitPane aSplit;
    private FlippingSplitPane bSplit;
    private FlippingSplitPane splitPane;
    private JButton deitySelect;
    private JButton domainSelect;
    private JLabel deityName;
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JTextField textDeityQFilter = new JTextField();
    private JButton clearDeityQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private static Integer saveDeityViewMode = null;
    private JTextField textDomainQFilter = new JTextField();
    private JButton clearDomainQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private JLabel domChosen = new JLabel();
    private JLabel domSelected;
    private JLabel domTotal = new JLabel();
    private JLabel ofLabel;
    private JLabelPane deityInfo = new JLabelPane();
    private JPanel center = new JPanel();
    private JTreeTable deityTable = null;
    private JTableEx domainTable = null;
    private JLabelPane domainInfo = new JLabelPane();
    private JTreeTableSorter deitySorter = null;
    private TableSorter domainSorter = null;
    private boolean hasBeenSized = false;
    private int numDomains = 0;
    private int viewMode = 0;
    private TreePath selPath;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoDomain(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoDomain.this.initComponents();
                InfoDomain.this.initActionListeners();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Domain.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Domain.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.pc.getCharacterDomainUsed() < this.pc.getMaxCharacterDomains()) {
            arrayList.add(PropertyFactory.getString("in_domTodoDomainsLeft"));
        } else if (this.pc.getCharacterDomainUsed() > this.pc.getMaxCharacterDomains()) {
            arrayList.add(PropertyFactory.getString("in_domTodoTooManyDomains"));
        }
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public final int getSelectionMode() {
        return 2;
    }

    @Override
    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllDeityFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.forceRefresh();
    }

    private void setDeityInfoText(Deity deity) {
        if (deity != null) {
            StringBuffer stringBuffer = new StringBuffer().append("<html><b>").append(deity.piSubString()).append("</b>");
            String string = deity.getTitle();
            if (string.length() != 0) {
                stringBuffer.append("&nbsp;(").append(string).append(")");
            }
            stringBuffer.append(" &nbsp;<b>").append(PropertyFactory.getString("in_descrip")).append("</b>:").append(deity.piDescString(this.pc));
            string = deity.preReqHTMLStrings(this.pc, false);
            if (string.length() != 0) {
                stringBuffer.append(" &nbsp;<b>").append(PropertyFactory.getString("in_requirements")).append("</b>:").append(string);
            }
            if ((string = deity.getFavoredWeapon()).length() != 0) {
                stringBuffer.append(" &nbsp;<b>").append(PropertyFactory.getString("in_deityFavWeap")).append("</b>:").append(string);
            }
            if ((string = deity.getHolyItem()).length() != 0) {
                stringBuffer.append(" &nbsp;<b>").append(PropertyFactory.getString("in_deityHolyIt")).append("</b>:").append(string);
            }
            if ((string = deity.getWorshippers()).length() != 0) {
                stringBuffer.append(" &nbsp;<b>").append(PropertyFactory.getString("in_deityWorshippers")).append("</b>:").append(string);
            }
            stringBuffer.append("</html>");
            this.deityInfo.setText(stringBuffer.toString());
        } else {
            this.deityInfo.setText();
        }
    }

    private void setDomainInfoText(Domain domain, List<Prerequisite> list) {
        StringBuffer stringBuffer = new StringBuffer().append("<html>");
        if (domain != null) {
            stringBuffer.append("<b>").append(domain.piSubString());
            String string = domain.getDescription(this.getPc());
            if (string.length() != 0) {
                stringBuffer.append(" &nbsp;").append(PropertyFactory.getString("in_domainGrant")).append("</b>:").append(string);
            }
            if ((string = domain.preReqHTMLStrings(this.pc, false)).length() != 0) {
                stringBuffer.append(" &nbsp;<b>").append(PropertyFactory.getString("in_requirements")).append("</b>:").append(string);
            }
            if ((string = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, list, false)).length() != 0) {
                stringBuffer.append(" &nbsp;<b>").append(PropertyFactory.getString("in_domainRequirements")).append("</b>:").append(string);
            }
        }
        stringBuffer.append("</html>");
        this.domainInfo.setText(stringBuffer.toString());
    }

    private final void addUnfilteredDomains(List<QualifiedObject<Domain>> list, Deity deity) {
        list.clear();
        if (deity != null) {
            for (QualifiedObject object : deity.getDomainList()) {
                object.setObject(((Domain)object.getObject(null)).clone());
                if (this.isDomainInList(list, (Domain)object.getObject(null))) continue;
                list.add(object);
            }
        }
        for (PCClass pCClass : this.pc.getClassList()) {
            for (int i = 0; i <= pCClass.getLevel(); ++i) {
                QualifiedObject<Domain> qualifiedObject;
                for (Domain domain : pCClass.getAddDomains(pCClass.getLevel())) {
                    if (domain != null) {
                        domain = domain.clone();
                    }
                    if (this.isDomainInList(list, (qualifiedObject = new QualifiedObject<Domain>(domain)).getObject(null))) continue;
                    list.add(qualifiedObject);
                }
                for (Domain domain : pCClass.getDomainList(i)) {
                    if (domain != null) {
                        domain = domain.clone();
                    }
                    if (this.isDomainInList(list, (qualifiedObject = new QualifiedObject<Domain>(domain.clone())).getObject(null))) continue;
                    list.add(qualifiedObject);
                }
            }
        }
    }

    private boolean isDomainInList(List<QualifiedObject<Domain>> list, Domain domain) {
        for (QualifiedObject<Domain> qualifiedObject : list) {
            if (!domain.equals(qualifiedObject.getObject(null))) continue;
            return true;
        }
        return false;
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("in_statusBarDeity"));
        this.refresh();
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bSplit.getDividerLocation();
        int n3 = this.aSplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            double d = this.getSize().getWidth();
            n = SettingsHandler.getPCGenOption("InfoDomain.splitPane", (int)(d * 4.0 / 10.0));
            n2 = SettingsHandler.getPCGenOption("InfoDomain.bSplit", (int)(this.getSize().getHeight() * 75.0 / 100.0));
            n3 = SettingsHandler.getPCGenOption("InfoDomain.aSplit", (int)(d * 5.0 / 10.0));
            for (n5 = 0; n5 < this.deityTable.getColumnCount(); ++n5) {
                tableColumn = this.deityTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth(PropertyFactory.getString("in_deity"), n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.deityTable, PropertyFactory.getString("in_deity"), n5));
            }
            for (n5 = 0; n5 < this.domainTable.getColumnCount(); ++n5) {
                tableColumn = this.domainTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth(PropertyFactory.getString("in_domains"), n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.domainTable, PropertyFactory.getString("in_domains"), n5));
            }
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoDomain.splitPane", n);
        }
        if (n2 > 0) {
            this.bSplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoDomain.bSplit", n2);
        }
        if (n3 > 0) {
            this.aSplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoDomain.aSplit", n3);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new DeityPopupListener(jTreeTable, new DeityPopupMenu()));
    }

    private void hookupPopupMenu(JTableEx jTableEx) {
        jTableEx.addMouseListener(new DomainPopupListener(jTableEx, new DomainPopupMenu(jTableEx)));
    }

    private final void createTreeTables() {
        this.deityTable = new JTreeTable(this.deityModel);
        this.deityTable.setSelectionMode(0);
        final JTree jTree = this.deityTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        this.deityTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoDomain.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = jTree.getPathForRow(n).getLastPathComponent();
                    if (object == null) {
                        return;
                    }
                    PObjectNode pObjectNode = (PObjectNode)object;
                    if (pObjectNode.getItem() instanceof Deity) {
                        Deity deity = (Deity)pObjectNode.getItem();
                        InfoDomain.this.setDeityInfoText(deity);
                    }
                }
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    if (mouseEvent.getClickCount() == 1 && treePath != null) {
                        jTree.setSelectionPath(treePath);
                    } else if (mouseEvent.getClickCount() == 2) {
                        InfoDomain.this.selButton();
                    }
                }
            }
        };
        jTree.addMouseListener(mouseAdapter);
        this.hookupPopupMenu(this.deityTable);
    }

    private static int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private void initComponents() {
        this.readyForRefresh = true;
        int n = SettingsHandler.getDomainTab_ListMode();
        if (n >= 0 && n <= 4) {
            this.viewMode = n;
        }
        SettingsHandler.setDomainTab_ListMode(this.viewMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_alignmentName") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_domainName") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_pantheonName") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_sourceName") + " ");
        this.viewComboBox.setSelectedIndex(this.viewMode);
        this.deityModel = new DeityModel(this.viewMode);
        this.createTreeTables();
        Utility.setDescription(this, PropertyFactory.getString("in_tabToolTip"));
        Utility.setDescription(this.deityTable, PropertyFactory.getString("in_deityTableTip"));
        this.domainSorter = new TableSorter(this.domainModel);
        this.domainTable = new JTableEx(this.domainSorter);
        this.domainSorter.addMouseListenerToHeaderInTable(this.domainTable);
        this.domainTable.setSelectionMode(0);
        Utility.setDescription(this.domainTable, PropertyFactory.getString("in_domainTableTip"));
        DomainMouseAdapter domainMouseAdapter = new DomainMouseAdapter();
        this.domainTable.addMouseListener(domainMouseAdapter);
        this.center.setLayout(new BorderLayout());
        this.buildTopPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_deityInfo"));
        titledBorder.setTitleJustification(2);
        JScrollPane jScrollPane = new JScrollPane(this.deityInfo);
        jScrollPane.setBorder(titledBorder);
        jPanel.add((Component)jScrollPane, "Center");
        this.deityInfo.setBackground(jPanel.getBackground());
        Utility.setDescription(jPanel, PropertyFactory.getString("in_infoScrollTip"));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(PropertyFactory.getString("in_domainInfo"));
        titledBorder2.setTitleJustification(2);
        JScrollPane jScrollPane2 = new JScrollPane(this.domainInfo);
        jScrollPane2.setBorder(titledBorder2);
        jPanel2.add((Component)jScrollPane2, "Center");
        this.domainInfo.setBackground(jPanel2.getBackground());
        Utility.setDescription(jPanel2, PropertyFactory.getString("in_infoScrollTip"));
        this.aSplit = new FlippingSplitPane(1, jPanel, jPanel2);
        this.aSplit.setOneTouchExpandable(true);
        this.aSplit.setDividerSize(10);
        this.aSplit.setDividerLocation(300);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.aSplit, "Center");
        this.bSplit = new FlippingSplitPane(0, this.center, jPanel3);
        this.bSplit.setOneTouchExpandable(true);
        this.bSplit.setDividerSize(10);
        this.bSplit.setDividerLocation(300);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bSplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoDomain.this.refresh();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoDomain.this.formComponentShown();
            }
        });
        this.hookupPopupMenu(this.deityTable);
        this.hookupPopupMenu(this.domainTable);
    }

    private void buildTopPane() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.splitPane = new FlippingSplitPane(splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.splitPane.setDividerLocation(350);
        this.center.add((Component)this.splitPane, "Center");
        jPanel.add((Component)InfoTabUtils.createFilterPane(new JLabel(PropertyFactory.getString("in_irSortDeities")), this.viewComboBox, new JLabel(PropertyFactory.getString("InfoTabs.FilterLabel")), this.textDeityQFilter, this.clearDeityQFilterButton), "North");
        JScrollPane jScrollPane = new JScrollPane(this.deityTable, 22, 30);
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText(PropertyFactory.getString("in_caretSymbol"));
        new TableColumnManager(this.deityTable, jButton, this.deityModel);
        jPanel.add(jScrollPane);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 1));
        jPanel3.add(new JLabel(PropertyFactory.getString("in_deity") + ": "));
        this.deityName = new JLabel(PropertyFactory.getString("in_nameLabel"));
        jPanel3.add(this.deityName);
        this.deitySelect = new JButton(PropertyFactory.getString("in_select"));
        Utility.setDescription(this.deitySelect, PropertyFactory.getString("in_deityButTip"));
        jPanel3.add(this.deitySelect);
        jPanel.add((Component)jPanel3, "South");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)InfoTabUtils.createFilterPane(null, null, new JLabel(PropertyFactory.getString("InfoTabs.FilterLabel")), this.textDomainQFilter, this.clearDomainQFilterButton), "North");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 1));
        this.domSelected = new JLabel(PropertyFactory.getString("in_domainSelected") + ": ");
        this.ofLabel = new JLabel(PropertyFactory.getString("in_ofString"));
        jPanel4.add(this.domSelected);
        jPanel4.add(this.domChosen);
        jPanel4.add(this.ofLabel);
        jPanel4.add(this.domTotal);
        this.domainSelect = new JButton(PropertyFactory.getString("in_select"));
        Utility.setDescription(this.domainSelect, PropertyFactory.getString("in_domainButTip"));
        this.domainSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelectionModel listSelectionModel = InfoDomain.this.domainTable.getSelectionModel();
                int n = InfoDomain.this.domainSorter.getRowTranslated(listSelectionModel.getMinSelectionIndex());
                InfoDomain.this.selectDomainIndex(n);
            }
        });
        jPanel4.add(this.domainSelect);
        jPanel2.add((Component)jPanel4, "South");
        JScrollPane jScrollPane2 = new JScrollPane(this.domainTable, 22, 30);
        JButton jButton2 = new JButton();
        jScrollPane2.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText(PropertyFactory.getString("in_caretSymbol"));
        new TableColumnManager(this.domainTable, jButton2, this.domainModel);
        jPanel2.add(jScrollPane2);
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoDomain.this.formComponentShown();
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.viewComboBoxActionPerformed();
            }
        });
        this.deitySelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.selButton();
            }
        });
        FilterFactory.restoreFilterSettings(this);
        this.textDeityQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoDomain.this.setDeityQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoDomain.this.setDeityQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoDomain.this.setDeityQFilter();
            }
        });
        this.clearDeityQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.clearDeityQFilter();
            }
        });
        this.textDomainQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoDomain.this.setDomainQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoDomain.this.setDomainQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoDomain.this.setDomainQFilter();
            }
        });
        this.clearDomainQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.clearDomainQFilter();
            }
        });
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != this.viewMode) {
            this.viewMode = n;
            SettingsHandler.setDomainTab_ListMode(this.viewMode);
            this.createModel();
            this.deityTable.updateUI();
        }
    }

    private final void createModel() {
        if (this.deityModel == null) {
            this.deityModel = new DeityModel(this.viewMode);
        } else {
            this.deityModel.resetModel(this.viewMode);
        }
        if (this.deitySorter != null) {
            this.deitySorter.setRoot((PObjectNode)this.deityModel.getRoot());
            this.deitySorter.sortNodeOnColumn();
        }
    }

    private void selButton() {
        int n;
        TreePath treePath = this.deityTable.getTree().getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object;
        if (!(pObjectNode.getItem() instanceof Deity)) {
            return;
        }
        Deity deity = (Deity)pObjectNode.getItem();
        if (this.pc.getDeity() != null && deity.equals(this.pc.getDeity())) {
            return;
        }
        if (!this.pc.canSelectDeity(deity)) {
            ListSelectionModel listSelectionModel = this.deityTable.getSelectionModel();
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_reqMess", deity.getDisplayName()), "PCGen", MessageType.INFORMATION);
            listSelectionModel.clearSelection();
            return;
        }
        ArrayList<QualifiedObject<Domain>> arrayList = new ArrayList<QualifiedObject<Domain>>();
        this.addUnfilteredDomains(arrayList, deity);
        boolean bl = true;
        for (Domain domain : selectedDomainList) {
            if (this.isDomainInList(arrayList, domain)) continue;
            bl = false;
            break;
        }
        if (!bl && (n = JOptionPane.showConfirmDialog(null, PropertyFactory.getFormattedString("in_confDomLost1", deity.getDisplayName()) + System.getProperty("line.separator") + PropertyFactory.getString("in_confDomLost2"), "PCGen", 2)) != 0) {
            return;
        }
        this.pc.setDeity(deity);
        this.deityName.setText(deity.piString());
        this.buildDomainLists();
    }

    private final void updateCharacterInfo() {
        if (this.pc != null && this.numDomains != this.pc.getCharacterDomainList().size()) {
            needsUpdate = true;
            this.numDomains = this.pc.getCharacterDomainList().size();
        }
        if (needsUpdate || this.pc == null) {
            if (this.pc == null) {
                return;
            }
            this.createModel();
            this.deityTable.updateUI();
            if (this.pc.getDeity() != null) {
                this.deityName.setText(this.pc.getDeity().piString());
            } else {
                this.deityName.setText(PropertyFactory.getString("in_tempName"));
            }
            this.setDeityInfoText(this.pc.getDeity());
            this.buildDomainLists();
            needsUpdate = false;
        }
    }

    private void buildDomainLists() {
        Domain domain;
        List list = this.domainModel.getAvailDomainList();
        selectedDomainList.clear();
        list.clear();
        this.addUnfilteredDomains(list, this.pc.getDeity());
        for (CharacterDomain object : this.pc.getCharacterDomainList()) {
            QualifiedObject qualifiedObject;
            if (object == null || object.getDomain() == null) continue;
            domain = object.getDomain();
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !(bl = ((Domain)(qualifiedObject = (QualifiedObject)iterator.next()).getObject(null)).getKeyName().equals(domain.getKeyName()))) {
            }
            if (!bl) {
                list.add(new QualifiedObject<Domain>(domain));
            }
            if (selectedDomainList.contains(domain)) continue;
            selectedDomainList.add(domain);
        }
        Iterator<CharacterDomain> iterator = list.iterator();
        while (iterator.hasNext()) {
            QualifiedObject qualifiedObject = (QualifiedObject)((Object)iterator.next());
            domain = (Domain)qualifiedObject.getObject(this.pc);
            if (domain == null || this.accept(this.pc, domain) || selectedDomainList.contains(domain)) continue;
            iterator.remove();
        }
        this.domTotal.setText(Integer.toString(this.pc.getMaxCharacterDomains()));
        this.domChosen.setText(Integer.toString(this.pc.getCharacterDomainUsed()) + "*");
        this.domainModel.resetModel();
        this.domainSorter.tableChanged(null);
        this.domainModel.fireTableDataChanged();
    }

    private final void selectDomainIndex(int n) {
        if (n < 0 || n >= this.domainModel.getRowCount()) {
            return;
        }
        if (this.pc.getMaxCharacterDomains() <= 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_errorNotAllowedToChooseADomain"), "PCGen", MessageType.INFORMATION);
            return;
        }
        QualifiedObject qualifiedObject = (QualifiedObject)this.domainModel.getValueAt(n, -1);
        Domain domain = (Domain)qualifiedObject.getObject(null);
        if (domain == null) {
            return;
        }
        if (!domain.qualifiesForDomain(this.pc) || !qualifiedObject.qualifies(this.pc)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_qualifyMess", domain.getDisplayName()), "PCGen", MessageType.INFORMATION);
            return;
        }
        CharacterDomain characterDomain = this.pc.getCharacterDomainForDomain(domain.getKeyName());
        if (characterDomain == null) {
            characterDomain = this.pc.getNewCharacterDomain();
        }
        if (characterDomain == null) {
            Logging.errorPrintLocalised("in_errorNoMoreAllowedDomains");
            return;
        }
        Domain domain2 = characterDomain.getDomain();
        if (domain2 != null && domain2.equals(domain)) {
            selectedDomainList.remove(domain2);
            this.pc.removeCharacterDomain(characterDomain);
        }
        if (this.pc.getCharacterDomainUsed() >= this.pc.getMaxCharacterDomains()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_errorNoMoreDomains"), "PCGen", MessageType.INFORMATION);
            return;
        }
        if (domain2 == null) {
            domain.setIsLocked(true, this.pc);
            characterDomain.setDomain(domain, this.pc);
            this.pc.addCharacterDomain(characterDomain);
            if (!selectedDomainList.contains(domain)) {
                selectedDomainList.add(domain);
            }
            this.pc.calcActiveBonuses();
        }
        this.domChosen.setText(Integer.toString(this.pc.getCharacterDomainUsed()) + "*");
        this.domainSorter.tableChanged(null);
        this.domainModel.fireTableDataChanged();
        this.forceUpdates();
    }

    private static void createDeityButtonClick() {
        LstEditorMain lstEditorMain = new LstEditorMain();
        lstEditorMain.setVisible(true);
        lstEditorMain.editIt(null, 1);
    }

    private void forceUpdates() {
        this.pc.setDirty(true);
        needsUpdate = true;
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.setPaneForUpdate(characterInfo.infoAbilities());
        characterInfo.refresh();
    }

    private void deleteDeityButtonClick() {
        TreePath treePath = this.deityTable.getTree().getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object;
        if (!(pObjectNode.getItem() instanceof Deity)) {
            return;
        }
        Deity deity = (Deity)pObjectNode.getItem();
        if (deity != null) {
            if (deity.isType("CUSTOM")) {
                int n = JOptionPane.showConfirmDialog(null, PropertyFactory.getFormattedString("in_delDeity2", deity.getDisplayName()), "PCGen", 2);
                if (n != 0) {
                    return;
                }
                Globals.getDeityList().remove(deity);
            } else {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_domIDEr4"), "PCGen", MessageType.ERROR);
            }
        }
    }

    private void editDeityButtonClick() {
        TreePath treePath = this.deityTable.getTree().getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object;
        if (!(pObjectNode.getItem() instanceof Deity)) {
            return;
        }
        Deity deity = (Deity)pObjectNode.getItem();
        LstEditorMain lstEditorMain = new LstEditorMain();
        lstEditorMain.setVisible(true);
        lstEditorMain.editIt(deity, 1);
    }

    private void clearDeityQFilter() {
        this.deityModel.clearQFilter();
        if (saveDeityViewMode != null) {
            this.viewMode = saveDeityViewMode;
            saveDeityViewMode = null;
        }
        this.deityModel.resetModel(this.viewMode);
        this.clearDeityQFilterButton.setEnabled(false);
        this.deityModel.setQFilter(null);
        this.textDeityQFilter.setText(null);
        this.viewComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void setDeityQFilter() {
        String string = this.textDeityQFilter.getText();
        if (string.length() == 0) {
            this.clearDeityQFilter();
            return;
        }
        this.deityModel.setQFilter(string);
        if (saveDeityViewMode == null) {
            saveDeityViewMode = this.viewMode;
        }
        this.viewMode = 0;
        this.clearDeityQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private void clearDomainQFilter() {
        this.domainModel.clearQFilter();
        this.domainModel.resetModel();
        this.clearDomainQFilterButton.setEnabled(false);
        this.domainModel.setQFilter(null);
        this.textDomainQFilter.setText(null);
        this.forceRefresh();
    }

    private void setDomainQFilter() {
        String string = this.textDomainQFilter.getText();
        if (string.length() == 0) {
            this.clearDomainQFilter();
            return;
        }
        this.domainModel.setQFilter(string);
        this.domainModel.resetModel();
        this.clearDomainQFilterButton.setEnabled(true);
        this.forceRefresh();
    }

    private final class DomainMouseAdapter
    extends MouseAdapter {
        private final ListSelectionModel lsm;

        private DomainMouseAdapter() {
            this.lsm = InfoDomain.this.domainTable.getSelectionModel();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = InfoDomain.this.domainSorter.getRowTranslated(this.lsm.getMinSelectionIndex());
            if (n < 0) {
                return;
            }
            int n2 = mouseEvent.getClickCount();
            switch (n2) {
                case 1: {
                    QualifiedObject qualifiedObject = (QualifiedObject)InfoDomain.this.domainModel.getValueAt(n, -1);
                    String string = ((Domain)qualifiedObject.getObject(null)).toString();
                    if (string == null) break;
                    Domain domain = Globals.getDomainKeyed(string);
                    InfoDomain.this.setDomainInfoText(domain, qualifiedObject.getPrereqs());
                    break;
                }
                default: {
                    InfoDomain.this.selectDomainIndex(n);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DomainModel
    extends AbstractTableModel
    implements TableColumnManagerModel {
        private List<QualifiedObject<Domain>> availDomainList = new ArrayList<QualifiedObject<Domain>>();
        private List<QualifiedObject<Domain>> displayDomainList = new ArrayList<QualifiedObject<Domain>>();
        private String qFilter = null;
        private List<Boolean> displayList = null;
        private final String[] domainColList = new String[]{PropertyFactory.getString("in_domains"), PropertyFactory.getString("in_sourceLabel")};
        private final int[] domainWidthList = new int[]{200, 100};

        private DomainModel() {
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            this.displayList.add(this.getColumnViewOption(this.domainColList[1], true));
        }

        private List<QualifiedObject<Domain>> getAvailDomainList() {
            return this.availDomainList;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public int getColumnCount() {
            return this.domainColList.length;
        }

        public void resetModel() {
            this.displayDomainList.clear();
            for (int i = 0; i < this.availDomainList.size(); ++i) {
                QualifiedObject<Domain> qualifiedObject = this.availDomainList.get(i);
                if (this.qFilter != null && qualifiedObject.getObject(null).getDisplayName().toLowerCase().indexOf(this.qFilter) < 0) continue;
                this.displayDomainList.add(qualifiedObject);
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.domainColList[n];
        }

        @Override
        public int getRowCount() {
            return this.displayDomainList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n >= this.displayDomainList.size()) {
                return "";
            }
            QualifiedObject<Domain> qualifiedObject = this.displayDomainList.get(n);
            Domain domain = qualifiedObject.getObject(null);
            if (domain == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(80);
            switch (n2) {
                case -1: {
                    return qualifiedObject;
                }
                case 0: {
                    if (selectedDomainList.contains(this.displayDomainList.get(n).getObject(null))) {
                        stringBuffer.append("<html><b>").append(domain.piSubString()).append("*</b></html>");
                        break;
                    }
                    if (!domain.qualifiesForDomain(InfoDomain.this.pc) || !qualifiedObject.qualifies(InfoDomain.this.pc)) {
                        stringBuffer.append("<html>").append(SettingsHandler.getPrereqFailColorAsHtmlStart()).append(domain.piSubString()).append(SettingsHandler.getPrereqFailColorAsHtmlEnd()).append("</html>");
                        break;
                    }
                    stringBuffer.append(domain.piString());
                    break;
                }
                case 1: {
                    try {
                        stringBuffer.append(domain.getDefaultSourceString());
                    }
                    catch (Exception exception) {
                        Logging.errorPrint(PropertyFactory.getString("in_errorMess"), exception);
                    }
                    break;
                }
                default: {
                    Logging.errorPrint(PropertyFactory.getFormattedString("in_domInTheColumn2", String.valueOf(n2)));
                }
            }
            return stringBuffer.toString();
        }

        public String getQFilter() {
            return this.qFilter;
        }

        public void setQFilter(String string) {
            this.qFilter = string != null ? string.toLowerCase() : null;
        }

        public void clearQFilter() {
            this.qFilter = null;
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.domainColList[1]);
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.domainColList[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption("InfoDomain.domain.sizecol." + this.domainColList[n], this.domainWidthList[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption("InfoDomain.domain.sizecol." + this.domainColList[n], n2);
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoDomain.domain.viewcol." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoDomain.domain.viewcol." + string, bl);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DeityModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        private PObjectNode deityRoot;
        private final String[] deityNameList;
        private final int[] deityColList;
        private List<Boolean> displayList;

        private DeityModel(int n) {
            super(null);
            this.deityNameList = new String[]{PropertyFactory.getString("in_nameLabel"), PropertyFactory.getString("in_alignLabel"), PropertyFactory.getString("in_domains"), PropertyFactory.getString("in_sourceLabel")};
            this.deityColList = new int[]{200, 100, 100, 100};
            this.displayList = null;
            this.resetModel(n);
            this.displayList = new ArrayList<Boolean>();
            int n2 = 1;
            this.displayList.add(Boolean.TRUE);
            this.displayList.add(this.getColumnViewOption(this.deityNameList[n2++], true));
            this.displayList.add(this.getColumnViewOption(this.deityNameList[n2++], true));
            this.displayList.add(this.getColumnViewOption(this.deityNameList[n2++], true));
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.deityNameList.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.deityNameList[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            PObjectNode pObjectNode = (PObjectNode)object;
            if (pObjectNode == null) {
                Logging.errorPrintLocalised("Errors.TreeTableModel.NoActiveNode", this.getClass().toString());
                return null;
            }
            switch (n) {
                case 0: {
                    return this.getColumnName(pObjectNode);
                }
                case 1: {
                    return this.getColumnAlignment(pObjectNode);
                }
                case 2: {
                    return this.getColumnDomainList(pObjectNode);
                }
                case 3: {
                    return this.getColumnSource(pObjectNode);
                }
            }
            Logging.errorPrint(PropertyFactory.getFormattedString("in_domInTheColumn", String.valueOf(n)));
            return null;
        }

        private Object getColumnName(PObjectNode pObjectNode) {
            return pObjectNode.toString();
        }

        private Object getColumnAlignment(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Deity) {
                Deity deity = (Deity)pObjectNode.getItem();
                return deity.getAlignment();
            }
            return null;
        }

        private Object getColumnDomainList(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Deity) {
                Deity deity = (Deity)pObjectNode.getItem();
                return deity.getDomainListPIString();
            }
            return null;
        }

        private Object getColumnSource(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Deity) {
                Deity deity = (Deity)pObjectNode.getItem();
                return deity.getDefaultSourceString();
            }
            return null;
        }

        private void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        private void resetModel(int n) {
            this.deityRoot = new PObjectNode();
            this.setRoot(this.deityRoot);
            switch (n) {
                case 0: {
                    this.buildNameView();
                    break;
                }
                case 1: {
                    this.buildAlignmentView();
                    break;
                }
                case 2: {
                    this.buildDomainView();
                    break;
                }
                case 3: {
                    this.buildPantheonView();
                    break;
                }
                case 4: {
                    this.buildSourceView();
                    break;
                }
                default: {
                    Logging.errorPrint(PropertyFactory.getFormattedString("in_domInTheMode", String.valueOf(n)));
                }
            }
            PObjectNode pObjectNode = (PObjectNode)super.getRoot();
            if (pObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private void buildNameView() {
            ArrayList<Deity> arrayList = new ArrayList<Deity>();
            String string = this.getQFilter();
            for (Deity deity : Globals.getDeityList()) {
                if (!InfoDomain.this.accept(InfoDomain.this.pc, deity) || string != null && deity.getDisplayName().toLowerCase().indexOf(string) < 0) continue;
                arrayList.add(deity);
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                Deity deity = (Deity)arrayList.get(i);
                if (deity == null) continue;
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(deity);
                pObjectNodeArray[i].setParent(this.deityRoot);
            }
            this.deityRoot.setChildren(pObjectNodeArray);
        }

        private void buildAlignmentView() {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Deity deity : Globals.getDeityList()) {
                if (!InfoDomain.this.accept(InfoDomain.this.pc, deity) || (string = deity.getAlignment()) == null || arrayList.contains(string) || string.length() <= 0) continue;
                arrayList.add(string);
            }
            Collections.sort(arrayList);
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                string = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(string);
                for (Deity deity : Globals.getDeityList()) {
                    String string2;
                    if (deity == null || (string2 = deity.getAlignment()) != null && !string2.equals(string)) continue;
                    PObjectNode pObjectNode = new PObjectNode();
                    pObjectNode.setItem(deity);
                    pObjectNode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(pObjectNode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.deityRoot);
            }
            this.deityRoot.setChildren(pObjectNodeArray);
        }

        private void buildDomainView() {
            Object object;
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Deity deity : Globals.getDeityList()) {
                if (!InfoDomain.this.accept(InfoDomain.this.pc, deity) || deity.getKeyName().equalsIgnoreCase("NONE")) continue;
                object2 = deity.getDomainList();
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    QualifiedObject object3 = (QualifiedObject)iterator.next();
                    object = ((Domain)object3.getObject(null)).getKeyName();
                    if (object == null || arrayList.contains(object) || ((String)object).length() <= 0) continue;
                    arrayList.add((String)object);
                }
            }
            Collections.sort(arrayList);
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(object2);
                for (Deity deity : Globals.getDeityList()) {
                    if (deity == null || deity.getKeyName().equalsIgnoreCase("NONE")) continue;
                    object = deity.getDomainList();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        QualifiedObject qualifiedObject = (QualifiedObject)iterator.next();
                        String string = ((Domain)qualifiedObject.getObject(null)).getKeyName();
                        if (string != null && !string.equals(object2)) continue;
                        PObjectNode pObjectNode = new PObjectNode();
                        pObjectNode.setItem(deity);
                        pObjectNode.setParent(pObjectNodeArray[i]);
                        pObjectNodeArray[i].addChild(pObjectNode);
                    }
                    if (pObjectNodeArray[i].isLeaf()) continue;
                    pObjectNodeArray[i].setParent(this.deityRoot);
                }
            }
            this.deityRoot.setChildren(pObjectNodeArray);
        }

        private void buildPantheonView() {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Deity deity : Globals.getDeityList()) {
                if (!InfoDomain.this.accept(InfoDomain.this.pc, deity)) continue;
                object = deity.getPantheonList();
                Iterator<Object> iterator = object.iterator();
                while (iterator.hasNext()) {
                    String object2 = iterator.next();
                    if (object2 == null || arrayList.contains(object2) || object2.length() <= 0) continue;
                    arrayList.add(object2);
                }
            }
            Collections.sort(arrayList);
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(object);
                for (Deity deity : Globals.getDeityList()) {
                    if (deity == null) continue;
                    List<String> list = deity.getPantheonList();
                    for (String string : list) {
                        if (string != null && !string.equals(object)) continue;
                        PObjectNode pObjectNode = new PObjectNode();
                        pObjectNode.setItem(deity);
                        pObjectNode.setParent(pObjectNodeArray[i]);
                        pObjectNodeArray[i].addChild(pObjectNode);
                    }
                    if (pObjectNodeArray[i].isLeaf()) continue;
                    pObjectNodeArray[i].setParent(this.deityRoot);
                }
            }
            this.deityRoot.setChildren(pObjectNodeArray);
        }

        private void buildSourceView() {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Deity deity : Globals.getDeityList()) {
                if (!InfoDomain.this.accept(InfoDomain.this.pc, deity) || (string = deity.getSourceEntry().getSourceBook().getLongName()) == null || arrayList.contains(string) || string.length() <= 0) continue;
                arrayList.add(string);
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                string = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(string);
                for (Deity deity : Globals.getDeityList()) {
                    String string2;
                    if (deity == null || (string2 = deity.getSourceEntry().getSourceBook().getLongName()) != null && !string2.equals(string)) continue;
                    PObjectNode pObjectNode = new PObjectNode();
                    pObjectNode.setItem(deity);
                    pObjectNode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(pObjectNode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.deityRoot);
            }
            this.deityRoot.setChildren(pObjectNodeArray);
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.deityNameList.length; ++i) {
                arrayList.add(this.deityNameList[i]);
            }
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.deityNameList[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption("InfoDomain.deity.sizecol." + this.deityNameList[n], this.deityColList[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption("InfoDomain.deity.sizecol." + this.deityNameList[n], n2);
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoDomain.deity.viewcol." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoDomain.deity.viewcol." + string, bl);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
        }
    }

    private final class DomainPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -4223585346813683966L;

        DomainPopupMenu(JTableEx jTableEx) {
            this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_select"), "shortcut EQUALS"));
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveClassActionListener(), PropertyFactory.getString("in_select"), '\u0000', string2, PropertyFactory.getString("in_selDomain"), "Add16.gif", true);
        }

        private class RemoveClassActionListener
        extends ClassActionListener {
            private RemoveClassActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.domainSelect.doClick();
            }
        }

        private class ClassActionListener
        implements ActionListener {
            private ClassActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }
    }

    private final class DomainPopupListener
    extends MouseAdapter {
        private DomainPopupMenu menu;
        private JTableEx aTable;

        DomainPopupListener(JTableEx jTableEx, DomainPopupMenu domainPopupMenu) {
            this.menu = domainPopupMenu;
            this.aTable = jTableEx;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoDomain.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < DomainPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = DomainPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoDomain.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoDomain.this.dispatchEvent(keyEvent);
                }
            };
            jTableEx.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = this.aTable.getSelectedRow();
                if (n == -1) {
                    return;
                }
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class DeityPopupMenu
    extends JPopupMenu {
        DeityPopupMenu() {
            this.add(this.createAddMenuItem(PropertyFactory.getString("in_select"), "shortcut EQUALS"));
            this.addSeparator();
            this.add(this.createEditMenuItem(PropertyFactory.getString("in_editDeity"), "alt E"));
            this.add(this.createCreateMenuItem(PropertyFactory.getString("in_createDeity"), "alt C"));
            this.add(this.createDeleteMenuItem(PropertyFactory.getString("in_delDeity"), "DELETE"));
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddDeityActionListener(), PropertyFactory.getString("in_select"), '\u0000', string2, PropertyFactory.getString("in_irSelDeityTip"), "Add16.gif", true);
        }

        private JMenuItem createEditMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new EditDeityActionListener(), PropertyFactory.getString("in_editDeity"), '\u0000', string2, null, null, true);
        }

        private JMenuItem createCreateMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new CreateDeityActionListener(), PropertyFactory.getString("in_createDeity"), '\u0000', string2, null, null, true);
        }

        private JMenuItem createDeleteMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new DeleteDeityActionListener(), PropertyFactory.getString("in_delDeity"), '\u0000', string2, null, null, true);
        }

        private class DeityActionListener
        implements ActionListener {
            private DeityActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class DeleteDeityActionListener
        extends DeityActionListener {
            private DeleteDeityActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.deleteDeityButtonClick();
            }
        }

        private class CreateDeityActionListener
        extends DeityActionListener {
            private CreateDeityActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.createDeityButtonClick();
            }
        }

        private class EditDeityActionListener
        extends DeityActionListener {
            private EditDeityActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.editDeityButtonClick();
            }
        }

        private class AddDeityActionListener
        extends DeityActionListener {
            private AddDeityActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoDomain.this.selButton();
            }
        }
    }

    private class DeityPopupListener
    extends MouseAdapter {
        private JTree tree;
        private DeityPopupMenu menu;

        DeityPopupListener(JTreeTable jTreeTable, DeityPopupMenu deityPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = deityPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoDomain.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < DeityPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = DeityPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoDomain.this.selPath = DeityPopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoDomain.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoDomain.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoDomain.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoDomain.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoDomain.this.selPath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

