/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Globals;
import pcgen.core.Movement;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.BaseCharacterInfoTab;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoRaces
extends BaseCharacterInfoTab {
    private static final Tab tab = Tab.RACES;
    private static final int COL_NAME = 0;
    private static final int COL_STAT = 1;
    private static final int COL_PRE = 2;
    private static final int COL_SIZE = 3;
    private static final int COL_MOVE = 4;
    private static final int COL_VISION = 5;
    private static final int COL_CLASS = 6;
    private static final int COL_LEVEL = 7;
    private FlippingSplitPane bsplit;
    private JButton selButton = new JButton(PropertyFactory.getString("in_select"));
    private JButton clearQFilterButton = new JButton("Clear");
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private final JLabel lblQFilter = new JLabel("Filter:");
    private JLabel raceText = new JLabel();
    private JLabel raceTextLabel = new JLabel(PropertyFactory.getString("in_irSelectedRace"));
    private JLabel sortLabel = new JLabel(PropertyFactory.getString("in_irSortRaces"));
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel botPane = new JPanel();
    private JPanel monHdPanel = new JPanel();
    private JLabel lblHDModify = new JLabel(PropertyFactory.getString("in_sumHDToAddRem"));
    private WholeNumberField txtHD = new WholeNumberField(1, 3);
    private JButton btnAddHD = new JButton("+");
    private JButton btnRemoveHD = new JButton("-");
    private JLabel txtMonsterHD = new JLabel("1");
    private JLabel lblMonsterHD = new JLabel(PropertyFactory.getString("in_sumMonsterHitDice"));
    private JPanel topPane = new JPanel();
    private JTextField textQFilter = new JTextField();
    private JTreeTable raceTable;
    private JTreeTableSorter raceSort = null;
    private RaceModel raceModel = null;
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private int viewMode = 0;
    private static Integer saveViewMode = null;

    public InfoRaces(PlayerCharacter playerCharacter) {
        super(playerCharacter);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoRaces.this.initComponents();
                InfoRaces.this.initActionListeners();
            }
        });
    }

    @Override
    public Tab getTab() {
        return tab;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Race.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Race.Order", n);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getPc().getRace() == null || "<none selected>".equals(this.getPc().getRace().getKeyName())) {
            arrayList.add(PropertyFactory.getString("in_irTodoRace"));
        }
        return arrayList;
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public final int getSelectionMode() {
        return 2;
    }

    @Override
    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllRaceFilters(this);
        FilterFactory.registerAllPrereqAlignmentFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.createModel();
        this.raceTable.updateUI();
    }

    private final void createTreeTables() {
        this.raceTable = new JTreeTable(this.raceModel);
        this.raceTable.setSelectionMode(0);
        final JTree jTree = this.raceTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        this.raceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoRaces.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = jTree.getPathForRow(n).getLastPathComponent();
                    if (object == null) {
                        return;
                    }
                    PObjectNode pObjectNode = (PObjectNode)object;
                    if (pObjectNode.getItem() instanceof Race) {
                        Race race = (Race)pObjectNode.getItem();
                        InfoRaces.this.setInfoLabelText(race);
                    } else {
                        InfoRaces.this.setInfoLabelText(null);
                    }
                }
            }
        });
        this.raceTable.addMouseListener(new JTreeTableMouseAdapter(this.raceTable, new AvailableClickHandler(), false));
        this.hookupPopupMenu(this.raceTable);
    }

    private void setInfoLabelText(Race race) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        if (race != null && !race.getKeyName().startsWith("<none")) {
            String string;
            stringBuffer.append("<b>").append(race.piSubString()).append("</b>");
            stringBuffer.append("<br><b>RACE TYPE</b>: ").append(race.getRaceType());
            List<String> list = race.getRacialSubTypes();
            if (list.size() > 0) {
                stringBuffer.append(" &nbsp;<b>SUBTYPES</b>: ");
                boolean bl = true;
                for (String string2 : list) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string2);
                    bl = false;
                }
            }
            if (race.getType().length() > 0) {
                stringBuffer.append(" &nbsp;<b>TYPE</b>:").append(race.getType());
            }
            if ((string = race.getDefaultSourceString()).length() > 0) {
                stringBuffer.append(" &nbsp;<b>SOURCE</b>:").append(string);
            }
        }
        stringBuffer.append("</html>");
        this.infoLabel.setText(stringBuffer.toString());
    }

    private static int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private final void createModel() {
        if (this.raceModel == null) {
            this.raceModel = new RaceModel(this.viewMode);
        } else {
            this.raceModel.resetModel(this.viewMode);
        }
        if (this.raceSort != null) {
            this.raceSort.setRoot((PObjectNode)this.raceModel.getRoot());
            this.raceSort.sortNodeOnColumn();
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("in_irSelectRace"));
        this.refresh();
        int n = this.bsplit.getDividerLocation();
        if (!this.hasBeenSized) {
            n = SettingsHandler.getPCGenOption("InfoRace.bsplit", (int)(this.getSize().getHeight() - 120.0));
            for (int i = 0; i < this.raceTable.getColumnCount(); ++i) {
                TableColumn tableColumn = this.raceTable.getColumnModel().getColumn(i);
                int n2 = Globals.getCustColumnWidth("Race", i);
                if (n2 != 0) {
                    tableColumn.setPreferredWidth(n2);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.raceTable, "Race", i));
            }
        }
        if (n > 0) {
            this.bsplit.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoRace.bsplit", n);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new RacePopupListener(jTreeTable, new RacePopupMenu()));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoRaces.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = InfoRaces.this.bsplit.getDividerLocation();
                if (n > 0) {
                    SettingsHandler.setPCGenOption("InfoRace.bsplit", n);
                }
            }
        });
        this.selButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoRaces.this.selButton();
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoRaces.this.viewComboBoxActionPerformed();
            }
        });
        this.textQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoRaces.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoRaces.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoRaces.this.setQFilter();
            }
        });
        this.clearQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoRaces.this.clearQFilter();
            }
        });
        this.btnAddHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 1;
                try {
                    n = Integer.parseInt(InfoRaces.this.txtHD.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PCGen_Frame1.addMonsterHD(n);
                InfoRaces.this.updateHD();
            }
        });
        this.btnRemoveHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 1;
                try {
                    n = Integer.parseInt(InfoRaces.this.txtHD.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PCGen_Frame1.addMonsterHD(n * -1);
                InfoRaces.this.updateHD();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        int n = SettingsHandler.getRaceTab_ListMode();
        if (n >= 0 && n <= 5) {
            this.viewMode = n;
        }
        SettingsHandler.setRaceTab_ListMode(this.viewMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_racetypeName") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_racetypeSubtypeName") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_typeName") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_allTypes") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_sourceName") + " ");
        this.viewComboBox.setSelectedIndex(this.viewMode);
        this.raceModel = new RaceModel(this.viewMode);
        this.createTreeTables();
        this.buildTopPanel();
        this.buildBottomPanel();
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoRaces.this.refresh();
            }
        });
    }

    private void buildTopPanel() {
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.topPane.add((Component)jPanel, "Center");
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.sortLabel, this.viewComboBox, this.lblQFilter, this.textQFilter, this.clearQFilterButton), "North");
        JScrollPane jScrollPane = new JScrollPane(this.raceTable);
        this.raceTable.setColAlign(3, 0);
        this.raceTable.setColAlign(7, 0);
        this.raceSort = new JTreeTableSorter(this.raceTable, (PObjectNode)this.raceModel.getRoot(), this.raceModel);
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.raceTable, jButton, this.raceModel);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 1));
        this.raceText.setPreferredSize(new Dimension(120, 25));
        this.raceText.setBorder(BorderFactory.createEtchedBorder());
        this.raceText.setHorizontalAlignment(0);
        jPanel2.add(this.raceTextLabel);
        jPanel2.add(this.raceText);
        jPanel2.add(this.selButton);
        this.monHdPanel.setLayout(new FlowLayout(0, 5, 0));
        this.monHdPanel.add(this.lblHDModify);
        this.monHdPanel.add(this.txtHD);
        this.monHdPanel.add(this.btnAddHD);
        this.monHdPanel.add(this.btnRemoveHD);
        this.monHdPanel.add(this.lblMonsterHD);
        this.monHdPanel.add(this.txtMonsterHD);
        jPanel2.add(this.monHdPanel);
        jPanel.add((Component)jPanel2, "South");
    }

    private void buildBottomPanel() {
        this.botPane.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_irRaceInfo"));
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane.setViewportView(this.infoLabel);
        this.botPane.add(jScrollPane);
    }

    private void selButton() {
        TreePath treePath = this.raceTable.getTree().getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object;
        if (!(pObjectNode.getItem() instanceof Race)) {
            return;
        }
        Race race = (Race)pObjectNode.getItem();
        if (race == null) {
            return;
        }
        Race race2 = this.getPc().getRace();
        if (!race.equals(race2)) {
            this.getPc().setRace(race);
            PCGen_Frame1.forceUpdate_PlayerTabs();
            CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
            characterInfo.setPaneForUpdate(characterInfo.infoClasses());
            characterInfo.setPaneForUpdate(characterInfo.infoAbilities());
            characterInfo.setPaneForUpdate(characterInfo.infoSkills());
            characterInfo.setPaneForUpdate(characterInfo.infoSpells());
            characterInfo.setPaneForUpdate(characterInfo.infoSummary());
            characterInfo.refresh();
            if (this.getPc().getRace().hitDice(this.getPc()) != 0) {
                this.getPc().getRace().rollHP(this.getPc());
            }
            this.raceText.setText(this.getPc().getRace().piString());
            this.raceText.setMinimumSize(new Dimension(120, 25));
            this.setInfoLabelText(this.getPc().getRace());
            if (this.monHdPanel.isVisible()) {
                this.updateHD();
            }
        }
    }

    @Override
    protected final void updateCharacterInfo() {
        this.monHdPanel.setVisible(SettingsHandler.hideMonsterClasses());
        if (!this.needsUpdate()) {
            return;
        }
        try {
            this.raceText.setText(this.getPc().getRace().piString());
            this.raceText.setMinimumSize(new Dimension(120, 25));
            this.setInfoLabelText(this.getPc().getRace());
        }
        catch (Exception exception) {
            this.raceText.setText("");
            this.setInfoLabelText(null);
        }
        this.createModel();
        this.raceTable.updateUI();
        if (this.monHdPanel.isVisible()) {
            this.updateHD();
            this.txtHD.setValue(1);
        }
        this.setNeedsUpdate(false);
    }

    private void updateHD() {
        int n = -1;
        int n2 = 0;
        this.btnAddHD.setEnabled(false);
        if (this.getPc() != null) {
            Race race = this.getPc().getRace();
            String string = race.getMonsterClass(this.getPc(), false);
            if (string != null) {
                n = race.hitDice(this.getPc());
                n2 = race.hitDice(this.getPc()) + race.getMonsterClassLevels(this.getPc());
                PCClass pCClass = this.getPc().getClassKeyed(string);
                if (pCClass != null) {
                    n += pCClass.getLevel();
                }
            }
            this.btnAddHD.setEnabled(race.hasAdvancement() && n >= 0);
        }
        this.btnRemoveHD.setEnabled(n > n2);
        if (n < 0) {
            n = 0;
        }
        this.txtMonsterHD.setText(Integer.toString(n));
        this.txtHD.setEnabled(this.btnAddHD.isEnabled() | this.btnRemoveHD.isEnabled());
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != this.viewMode) {
            this.viewMode = n;
            SettingsHandler.setRaceTab_ListMode(this.viewMode);
            this.createModel();
            this.raceTable.updateUI();
        }
    }

    private void clearQFilter() {
        this.raceModel.clearQFilter();
        if (saveViewMode != null) {
            this.viewMode = saveViewMode;
            saveViewMode = null;
        }
        this.textQFilter.setText("");
        this.raceModel.resetModel(this.viewMode);
        this.clearQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void setQFilter() {
        String string = this.textQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.raceModel.setQFilter(string);
        if (saveViewMode == null) {
            saveViewMode = this.viewMode;
        }
        this.viewMode = 0;
        this.raceModel.resetModel(this.viewMode);
        this.clearQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private class RacePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 2565545289875422981L;
        private String lastSearch = "";

        RacePopupMenu() {
            this.add(this.createAddMenuItem(PropertyFactory.getString("in_select"), "shortcut EQUALS"));
            this.addSeparator();
            this.add(Utility.createMenuItem("Find item", new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RacePopupMenu.this.lastSearch = InfoRaces.this.raceTable.searchTree(RacePopupMenu.this.lastSearch);
                }
            }, "searchItem", '\u0000', "shortcut F", "Find item", null, true));
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddRaceActionListener(), PropertyFactory.getString("in_select"), '\u0000', string2, PropertyFactory.getString("in_irSelRaceTip"), "Add16.gif", true);
        }

        private class RaceActionListener
        implements ActionListener {
            private RaceActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class AddRaceActionListener
        extends RaceActionListener {
            private AddRaceActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoRaces.this.selButton();
            }
        }
    }

    private class RacePopupListener
    extends MouseAdapter {
        private JTree tree;
        private RacePopupMenu menu;

        RacePopupListener(JTreeTable jTreeTable, RacePopupMenu racePopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = racePopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoRaces.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < RacePopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = RacePopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoRaces.this.selPath = RacePopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoRaces.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoRaces.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoRaces.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoRaces.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoRaces.this.selPath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RaceModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        private PObjectNode raceRoot;
        private List<Boolean> displayList;
        private final String[] raceNameList;
        private final int[] colDefaultWidth;

        private RaceModel(int n) {
            super(null);
            this.displayList = null;
            this.raceNameList = new String[]{PropertyFactory.getString("in_nameLabel"), PropertyFactory.getString("in_irTableStat"), PropertyFactory.getString("in_preReqs"), PropertyFactory.getString("in_size"), PropertyFactory.getString("in_speed"), PropertyFactory.getString("in_vision"), PropertyFactory.getString("in_favoredClass"), PropertyFactory.getString("in_lvlAdj")};
            this.colDefaultWidth = new int[]{300, 100, 100, 20, 100, 100, 40, 20};
            this.resetModel(n);
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            this.displayList.add(this.getColumnViewOption(this.raceNameList[1], true));
            this.displayList.add(this.getColumnViewOption(this.raceNameList[2], true));
            this.displayList.add(this.getColumnViewOption(this.raceNameList[3], true));
            this.displayList.add(this.getColumnViewOption(this.raceNameList[4], false));
            this.displayList.add(this.getColumnViewOption(this.raceNameList[5], false));
            this.displayList.add(this.getColumnViewOption(this.raceNameList[6], false));
            this.displayList.add(this.getColumnViewOption(this.raceNameList[7], true));
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.raceNameList.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.raceNameList[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            PObjectNode pObjectNode = (PObjectNode)object;
            if (pObjectNode == null) {
                Logging.errorPrint("No active node when doing getValueAt in InfoRace");
                return null;
            }
            switch (n) {
                case 0: {
                    return this.getColumnName(pObjectNode);
                }
                case 1: {
                    return this.getColumnStat(pObjectNode);
                }
                case 2: {
                    return this.getColumnPre(pObjectNode);
                }
                case 3: {
                    return this.getColumnSize(pObjectNode);
                }
                case 4: {
                    return this.getColumnMove(pObjectNode);
                }
                case 5: {
                    return this.getColumnVision(pObjectNode);
                }
                case 6: {
                    return this.getColumnClass(pObjectNode);
                }
                case 7: {
                    return this.getColumnLevel(pObjectNode);
                }
            }
            Logging.errorPrint("In InfoRace.RaceModel.getValueAt the column " + n + " is not supported.");
            return null;
        }

        private Object getColumnName(PObjectNode pObjectNode) {
            return pObjectNode.toString();
        }

        private Object getColumnStat(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Race) {
                Race race = (Race)pObjectNode.getItem();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
                    if (race.isNonAbility(i)) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(SettingsHandler.getGame().s_ATTRIBSHORT[i] + ":Nonability");
                        continue;
                    }
                    if (race.getStatMod(i, InfoRaces.this.getPc()) == 0) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(SettingsHandler.getGame().s_ATTRIBSHORT[i] + ":" + race.getStatMod(i, InfoRaces.this.getPc()));
                }
                return stringBuffer.toString();
            }
            return null;
        }

        private Object getColumnPre(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Race) {
                Race race = (Race)pObjectNode.getItem();
                return race.preReqHTMLStrings(InfoRaces.this.getPc());
            }
            return null;
        }

        private Object getColumnSize(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Race) {
                Race race = (Race)pObjectNode.getItem();
                return race.getSize();
            }
            return null;
        }

        private Object getColumnMove(PObjectNode pObjectNode) {
            Race race;
            List<Movement> list;
            if (pObjectNode.getItem() instanceof Race && (list = (race = (Race)pObjectNode.getItem()).getMovements()) != null && !list.isEmpty()) {
                return list.get(0).toString();
            }
            return null;
        }

        private Object getColumnVision(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Race) {
                Race race = (Race)pObjectNode.getItem();
                return race.getDisplayVision(InfoRaces.this.getPc());
            }
            return null;
        }

        private Object getColumnClass(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Race) {
                Race race = (Race)pObjectNode.getItem();
                return !".".equals(race.getFavoredClass()) ? race.getFavoredClass() : PropertyFactory.getString("in_various");
            }
            return null;
        }

        private Object getColumnLevel(PObjectNode pObjectNode) {
            if (pObjectNode.getItem() instanceof Race) {
                Race race = (Race)pObjectNode.getItem();
                return race.getLevelAdjustment(InfoRaces.this.getPc());
            }
            return null;
        }

        private void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        private void resetModel(int n) {
            this.raceRoot = new PObjectNode();
            this.setRoot(this.raceRoot);
            switch (n) {
                case 0: {
                    this.buildNameView();
                    break;
                }
                case 3: {
                    this.buildTypeView();
                    break;
                }
                case 5: {
                    this.buildSourceView();
                    break;
                }
                case 1: {
                    this.buildRaceTypeView();
                    break;
                }
                case 2: {
                    this.buildRaceTypeSubTypeView();
                    break;
                }
                case 4: {
                    this.buildAllTypesView();
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoRace.RaceModel.resetModel the mode " + n + " is not supported.");
                }
            }
            PObjectNode pObjectNode = (PObjectNode)super.getRoot();
            if (pObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private void buildNameView() {
            ArrayList<Race> arrayList = new ArrayList<Race>();
            String string = this.getQFilter();
            for (Race race : Globals.getAllRaces()) {
                if (!InfoRaces.this.accept(InfoRaces.this.getPc(), race) || string != null && race.getDisplayName().toLowerCase().indexOf(string) < 0 && race.getType().toLowerCase().indexOf(string) < 0) continue;
                arrayList.add(race);
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                Race race = (Race)arrayList.get(i);
                if (race == null) continue;
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(race);
                pObjectNodeArray[i].setParent(this.raceRoot);
            }
            this.raceRoot.setChildren(pObjectNodeArray);
        }

        private void buildTypeView() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Race race : Globals.getAllRaces()) {
                if (!InfoRaces.this.accept(InfoRaces.this.getPc(), race) || arrayList.contains(race.getType())) continue;
                arrayList.add(race.getType());
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(string);
                for (Race race : Globals.getAllRaces()) {
                    if (race == null || !race.getType().equals(string)) continue;
                    PObjectNode pObjectNode = new PObjectNode();
                    pObjectNode.setItem(race);
                    pObjectNode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(pObjectNode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.raceRoot);
            }
            this.raceRoot.setChildren(pObjectNodeArray);
        }

        private void buildSourceView() {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Race race : Globals.getAllRaces()) {
                if (!InfoRaces.this.accept(InfoRaces.this.getPc(), race) || (string = race.getSourceEntry().getSourceBook().getLongName()) == null || arrayList.contains(string) || string.length() <= 0) continue;
                arrayList.add(string);
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                string = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(string);
                for (Race race : Globals.getAllRaces()) {
                    String string2;
                    if (race == null || (string2 = race.getSourceEntry().getSourceBook().getLongName()) != null && !string2.equals(string)) continue;
                    PObjectNode pObjectNode = new PObjectNode();
                    pObjectNode.setItem(race);
                    pObjectNode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(pObjectNode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.raceRoot);
            }
            this.raceRoot.setChildren(pObjectNodeArray);
        }

        private void buildRaceTypeView() {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Race race : Globals.getAllRaces()) {
                if (!InfoRaces.this.accept(InfoRaces.this.getPc(), race) || arrayList.contains(string = race.getRaceType())) continue;
                arrayList.add(string);
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                string = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(string);
                for (Race race : Globals.getAllRaces()) {
                    if (race == null || !race.getRaceType().equals(string)) continue;
                    PObjectNode pObjectNode = new PObjectNode();
                    pObjectNode.setItem(race);
                    pObjectNode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(pObjectNode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.raceRoot);
            }
            this.raceRoot.setChildren(pObjectNodeArray);
        }

        private void buildRaceTypeSubTypeView() {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Race race : Globals.getAllRaces()) {
                if (!InfoRaces.this.accept(InfoRaces.this.getPc(), race) || arrayList.contains(string = race.getRaceType())) continue;
                arrayList.add(string);
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                string = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(string);
                HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
                for (Race race : Globals.getAllRaces()) {
                    if (race == null || !race.getRaceType().equals(string)) continue;
                    List<String> list = race.getRacialSubTypes();
                    if (list.size() > 0) {
                        for (String string2 : list) {
                            PObjectNode pObjectNode = (PObjectNode)hashMap.get(string2);
                            if (pObjectNode == null) {
                                pObjectNode = new PObjectNode();
                                pObjectNode.setItem(string2);
                                pObjectNode.setParent(pObjectNodeArray[i]);
                                pObjectNodeArray[i].addChild(pObjectNode);
                                hashMap.put(string2, pObjectNode);
                            }
                            PObjectNode pObjectNode2 = new PObjectNode();
                            pObjectNode2.setItem(race);
                            pObjectNode2.setParent(pObjectNode);
                            pObjectNode.addChild(pObjectNode2);
                        }
                        continue;
                    }
                    PObjectNode pObjectNode = new PObjectNode();
                    pObjectNode.setItem(race);
                    pObjectNode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(pObjectNode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.raceRoot);
            }
            this.raceRoot.setChildren(pObjectNodeArray);
        }

        private void buildAllTypesView() {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Race race : Globals.getAllRaces()) {
                if (!InfoRaces.this.accept(InfoRaces.this.getPc(), race)) continue;
                string = race.getRaceType();
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                }
                for (String object : race.getTypeList(true)) {
                    if (arrayList.contains(object)) continue;
                    arrayList.add(object);
                }
            }
            PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                string = (String)arrayList.get(i);
                pObjectNodeArray[i] = new PObjectNode();
                pObjectNodeArray[i].setItem(string);
                for (Race race : Globals.getAllRaces()) {
                    if (race == null || !race.getRaceType().equals(string) && !race.isType(string)) continue;
                    PObjectNode pObjectNode = new PObjectNode();
                    pObjectNode.setItem(race);
                    pObjectNode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(pObjectNode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.raceRoot);
            }
            this.raceRoot.setChildren(pObjectNodeArray);
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.raceNameList.length; ++i) {
                arrayList.add(this.raceNameList[i]);
            }
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.raceNameList[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption("InfoRaces.sizecol." + this.raceNameList[n], this.colDefaultWidth[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption("InfoRaces.sizecol." + this.raceNameList[n], n2);
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoRaces.viewcol." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoRaces.viewcol." + string, bl);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoRaces.this.selButton();
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }
}

