/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserRadio;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoTempMod
extends FilterAdapterPanel
implements CharacterInfoTab {
    private static final Tab tab = Tab.TEMPBONUS;
    private static boolean needsUpdate = true;
    private static final int MODEL_BONUS = 0;
    private static final int MODEL_TARGET = 1;
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_SRC = 2;
    private static final int BONUS_COL_NAME = 0;
    private static final int BONUS_COL_TYPE = 1;
    private static final int BONUS_COL_TO = 2;
    private static final int BONUS_COL_VAL = 3;
    private AppliedModel appliedBonusModel;
    private BonusModel bonusModel = null;
    private BonusModel targetModel = null;
    private FlippingSplitPane botHorzSplit;
    private FlippingSplitPane centerHorzSplit;
    private FlippingSplitPane topVertSplit;
    private JButton applyBonusButton;
    private JButton removeBonusButton;
    private JLabel tempModsDisabledWarning;
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private JTreeTable appliedTable;
    private JTreeTable bonusTable;
    private JTreeTable targetTable;
    private JTreeTableSorter bonusSort = null;
    private JTreeTableSorter targetSort = null;
    private List<TempWrap> tbwList;
    private PObject lastAvaObject = null;
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoTempMod(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.label());
        this.initComponents();
        this.initActionListeners();
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.TempMod.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.TempMod.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        return new ArrayList<String>();
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean bl) {
        needsUpdate = bl;
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public final int getSelectionMode() {
        return -2;
    }

    @Override
    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.updateBonusModel();
        this.updateTargetModel();
    }

    public final void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.updateBonusModel();
        this.updateTargetModel();
        this.updateAppliedModel();
        this.updateTempModDisabledWarning();
        needsUpdate = false;
    }

    private void updateTempModDisabledWarning() {
        if (!this.pc.getUseTempMods()) {
            this.tempModsDisabledWarning.setText(PropertyFactory.getString("InfoTempMod.warn.mods.off"));
        } else {
            this.tempModsDisabledWarning.setText("");
        }
        this.tempModsDisabledWarning.updateUI();
    }

    private String getBonusChoice(BonusObj bonusObj, String string, String string2) {
        if (string2.length() > 0) {
            if (bonusObj.getValue().indexOf("%CHOICE") >= 0) {
                String string3 = CoreUtility.replaceAll(bonusObj.getValue(), "%CHOICE", string2);
                bonusObj.setValue(string3);
            }
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string4 = string;
        if (string.startsWith("NUMCHOICES=")) {
            string4 = string.substring(0, string.indexOf(124));
            stringTokenizer.nextToken();
            Logging.errorPrint("NUMCHOICES is not implemented for CHOOSE in Temporary Mods");
            Logging.errorPrint("  CHOOSE was: " + string);
        }
        if (string4.startsWith("NUMBER") && stringTokenizer.countTokens() >= 3) {
            int n;
            int n2;
            stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            String string7 = PropertyFactory.getString("in_itmPickNumber");
            if (stringTokenizer.hasMoreTokens() && (string7 = stringTokenizer.nextToken()).startsWith("TITLE=")) {
                string7 = string7.substring(6);
            }
            if (string5.startsWith("MIN=")) {
                string5 = string5.substring(4);
                n2 = this.pc.getVariableValue(string5, "").intValue();
            } else {
                n2 = this.pc.getVariableValue(string5, "").intValue();
            }
            if (string6.startsWith("MAX=")) {
                string6 = string6.substring(4);
                n = this.pc.getVariableValue(string6, "").intValue();
            } else {
                n = this.pc.getVariableValue(string6, "").intValue();
            }
            if (n > 0 || n2 <= n) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = n2; i <= n; ++i) {
                    arrayList.add(Integer.toString(i));
                }
                ChooserRadio chooserRadio = ChooserFactory.getRadioInstance();
                chooserRadio.setAvailableList(arrayList);
                chooserRadio.setVisible(false);
                chooserRadio.setTitle(PropertyFactory.getString("in_itmPickNumber"));
                chooserRadio.setMessageText(string7);
                chooserRadio.setVisible(true);
                ArrayList<String> arrayList2 = chooserRadio.getSelectedList();
                if (arrayList2.size() > 0) {
                    String string8;
                    string2 = string8 = arrayList2.get(0);
                    if (bonusObj.getValue().indexOf("%CHOICE") >= 0) {
                        String string9;
                        string8 = string9 = CoreUtility.replaceAll(bonusObj.getValue(), "%CHOICE", string8);
                        bonusObj.setValue(string8);
                    }
                    return string2;
                }
                bonusObj.setValue("0");
            }
        }
        return "";
    }

    private void setInfoLabelText(Object object) {
        Equipment equipment = null;
        Spell spell = null;
        Ability ability = null;
        PObject pObject = null;
        PCTemplate pCTemplate = null;
        PObject pObject2 = null;
        if (object instanceof Equipment) {
            equipment = (Equipment)object;
        } else if (object instanceof Spell) {
            spell = (Spell)object;
        } else if (object instanceof Ability) {
            ability = (Ability)object;
        } else if (object instanceof PCClass) {
            pObject = (PCClass)object;
        } else if (object instanceof PCTemplate) {
            pCTemplate = (PCTemplate)object;
        } else if (object instanceof Skill) {
            pObject2 = (Skill)object;
        }
        if (pObject != null) {
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(pObject.getDisplayName());
            String string = pObject.getDefaultSourceString();
            if (string.length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSource", string);
            }
            if ((string = pObject.getTempDescription()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak().appendI18nElement("in_itmInfoLabelTextDesc", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        } else if (ability != null) {
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(ability.piSubString());
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextType", ability.getType());
            String string = ability.getDefaultSourceString();
            if (string.length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSource", string);
            }
            if ((string = ability.getTempDescription()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak().appendI18nElement("in_itmInfoLabelTextDesc", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        } else if (equipment != null) {
            Integer n;
            Integer n2;
            String string;
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(equipment.piSubString());
            if (!equipment.longName().equals(equipment.getName())) {
                infoLabelTextBuilder.append("(").append(equipment.longName()).append(")");
            }
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextType", equipment.getType());
            String string2 = equipment.getInterestingDisplayString(this.pc);
            if (string2.length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextProperties", equipment.getInterestingDisplayString(this.pc));
            }
            if ((string = Globals.getGameModeUnitSet().displayWeightInUnitSet(equipment.getWeight(this.pc).doubleValue())).length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextWT", string);
            }
            if ((n2 = equipment.getACBonus(this.pc)) > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextAC", n2.toString());
            }
            if (equipment.isArmor() || equipment.isShield()) {
                n2 = equipment.getMaxDex(this.pc);
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextMaxDex", n2.toString());
                n2 = equipment.acCheck(this.pc);
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextAcCheck", n2.toString());
            }
            if (Globals.getGameModeShowSpellTab()) {
                n2 = equipment.spellFailure(this.pc);
                if (equipment.isArmor() || equipment.isShield() || n2 != 0) {
                    infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextArcaneFailure", n2.toString());
                }
            }
            if ((string = equipment.moveString()).length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextMove", string);
            }
            if ((string = equipment.getSize()).length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSize", string);
            }
            if (equipment.isWeapon()) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextDamage", equipment.getDamage(this.pc));
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextCritMult", equipment.getCritMult());
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextCritRange", equipment.getCritRange(this.pc));
                string = equipment.getRange(this.pc).toString();
                if (string.length() > 0) {
                    infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextRange", string);
                }
            }
            if ((n = Integer.valueOf(equipment.getRemainingCharges())) >= 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextCharges", n.toString());
            }
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextCost", equipment.getCost(this.pc).toString());
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSource", equipment.getDefaultSourceString());
            string = equipment.getTempDescription();
            if (string.length() > 0) {
                infoLabelTextBuilder.appendLineBreak().appendI18nElement("in_itmInfoLabelTextDesc", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        } else if (pObject2 != null) {
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(pObject2.getDisplayName());
            String string = pObject2.getDefaultSourceString();
            if (string.length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSource", string);
            }
            if ((string = pObject2.getTempDescription()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak().appendI18nElement("in_itmInfoLabelTextDesc", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        } else if (spell != null) {
            String string;
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(spell.piSubString());
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextDuration", spell.getDuration());
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextRange", spell.getRange());
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextTarget", spell.getTarget());
            infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSpellDescription", spell.piDescSubString(this.pc));
            String string3 = spell.getDefaultSourceString();
            if (string3.length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSource", string3);
            }
            if ((string = spell.getTempDescription()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak().appendI18nElement("in_itmInfoLabelTextDesc", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        } else if (pCTemplate != null) {
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(pCTemplate.getDisplayName());
            String string = pCTemplate.getDefaultSourceString();
            if (string.length() > 0) {
                infoLabelTextBuilder.appendI18nElement("in_itmInfoLabelTextSource", string);
            }
            if ((string = pCTemplate.getTempDescription()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak().appendI18nElement("in_itmInfoLabelTextDesc", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        }
    }

    private final void createTreeTables() {
        this.bonusTable = new JTreeTable(this.bonusModel);
        final JTree jTree = this.bonusTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        this.bonusTable.setSelectionMode(0);
        this.bonusTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TreePath treePath = jTree.getSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object object = treePath.getLastPathComponent();
                    if (object == null) {
                        InfoTempMod.this.infoLabel.setText();
                        InfoTempMod.this.lastAvaObject = null;
                        InfoTempMod.this.applyBonusButton.setEnabled(false);
                        return;
                    }
                    PObjectNode pObjectNode = (PObjectNode)object;
                    if (pObjectNode.getItem() != null && !(pObjectNode.getItem() instanceof String)) {
                        Object object2;
                        if (pObjectNode.getItem() instanceof ClassWrap) {
                            object2 = (ClassWrap)pObjectNode.getItem();
                            InfoTempMod.this.lastAvaObject = ((ClassWrap)object2).getMyClass();
                        } else {
                            InfoTempMod.this.lastAvaObject = (PObject)pObjectNode.getItem();
                        }
                        InfoTempMod.this.setInfoLabelText(InfoTempMod.this.lastAvaObject);
                        InfoTempMod.this.updateTargetModel();
                        object2 = InfoTempMod.this.targetTable.getTree().getPathForRow(0);
                        if (object2 != null) {
                            InfoTempMod.this.applyBonusButton.setEnabled(true);
                            InfoTempMod.this.targetTable.getTree().setSelectionPath((TreePath)object2);
                        } else {
                            InfoTempMod.this.applyBonusButton.setEnabled(false);
                        }
                    } else {
                        InfoTempMod.this.applyBonusButton.setEnabled(false);
                    }
                }
            }
        });
        this.targetTable = new JTreeTable(this.targetModel);
        final JTree jTree2 = this.targetTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.targetTable.setSelectionMode(0);
        this.targetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TreePath treePath;
                if (!listSelectionEvent.getValueIsAdjusting() && (treePath = jTree2.getSelectionPath()) == null) {
                    return;
                }
            }
        });
        this.appliedTable = new JTreeTable(this.appliedBonusModel);
        final JTree jTree3 = this.appliedTable.getTree();
        jTree3.setRootVisible(false);
        jTree3.setShowsRootHandles(true);
        jTree3.setCellRenderer(new LabelTreeCellRenderer());
        this.appliedTable.setSelectionMode(0);
        this.appliedTable.setShowHorizontalLines(true);
        this.appliedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TreePath treePath = jTree3.getSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object object = treePath.getLastPathComponent();
                    MyPONode myPONode = (MyPONode)object;
                    if (myPONode.getItem() != null) {
                        InfoTempMod.this.removeBonusButton.setEnabled(true);
                    } else {
                        InfoTempMod.this.removeBonusButton.setEnabled(false);
                    }
                }
            }
        });
        this.bonusTable.addMouseListener(new JTreeTableMouseAdapter(this.bonusTable, new AvailableClickHandler(), true));
        this.appliedTable.addMouseListener(new JTreeTableMouseAdapter(this.appliedTable, new SelectedClickHandler(), true));
        this.hookupPopupMenu(this.bonusTable);
        this.hookupPopupMenu(this.targetTable);
        this.hookupPopupMenu(this.appliedTable);
    }

    private void applyBonusButton() {
        Object object;
        String string;
        Object object2;
        if (this.bonusTable.getTree().isSelectionEmpty()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_itmAppBonButSelectBonusType"), "PCGen", MessageType.ERROR);
            return;
        }
        if (this.targetTable.getTree().isSelectionEmpty()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_itmAppBonButSelectBonusTarget"), "PCGen", MessageType.ERROR);
            return;
        }
        TreePath treePath = this.bonusTable.getTree().getSelectionPath();
        TreePath treePath2 = this.targetTable.getTree().getSelectionPath();
        Object object3 = null;
        Object object4 = null;
        PObject pObject = null;
        int n = 999;
        Object object5 = treePath2.getLastPathComponent();
        PObjectNode pObjectNode = (PObjectNode)object5;
        if (pObjectNode.getItem() != null) {
            object4 = pObjectNode.getItem();
        }
        if (object4 == null || pObjectNode == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_itmAppBonButSelectBonusTarget"), "PCGen", MessageType.ERROR);
            return;
        }
        object5 = treePath.getLastPathComponent();
        pObjectNode = (PObjectNode)object5;
        if (pObjectNode.getItem() != null) {
            object3 = pObjectNode.getItem();
        }
        if (object3 == null || pObjectNode == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_itmAppBonButSelectBonusType"), "PCGen", MessageType.ERROR);
            return;
        }
        if (object3 instanceof PObject) {
            pObject = (PObject)object3;
        } else if (object3 instanceof ClassWrap) {
            object2 = (ClassWrap)object3;
            pObject = ((ClassWrap)object2).getMyClass();
            n = ((ClassWrap)object2).getLevel();
        }
        object2 = null;
        if (object4 instanceof Equipment) {
            object2 = ((Equipment)object4).clone();
            ((Equipment)object2).makeVirtual();
            string = ((Equipment)object2).getAppliedName();
            if (string != null && string.length() > 2) {
                for (BonusObj bonusObj : ((PObject)object2).getTempBonusList()) {
                    object = (PObject)bonusObj.getCreatorObject();
                    if (object == null || !pObject.equals(object) && (pObject.getClass() != object.getClass() || !pObject.getKeyName().equals(((PObject)object).getKeyName()))) continue;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_itmAppBonButAlreadyApplied"), "PCGen", MessageType.ERROR);
                    return;
                }
                ((Equipment)object2).setAppliedName(string.substring(2, string.length() - 1) + ", " + pObject.getKeyName());
            } else {
                ((Equipment)object2).setAppliedName(pObject.getKeyName());
            }
        }
        string = "";
        for (BonusObj bonusObj : pObject.getBonusList()) {
            object = bonusObj.toString();
            if (!bonusObj.isTempBonus()) continue;
            BonusObj bonusObj2 = null;
            if (pObject instanceof PCClass) {
                if (bonusObj.getPCLevel() == n) {
                    int n2 = ((String)object).indexOf(124);
                    bonusObj2 = Bonus.newBonus(((String)object).substring(n2 + 1));
                }
            } else {
                bonusObj2 = Bonus.newBonus((String)object);
            }
            if (bonusObj2 == null) continue;
            bonusObj2.clearPreReq();
            for (Prerequisite prerequisite : bonusObj.getPreReqList()) {
                if (prerequisite.getKind() != null && prerequisite.getKind().equalsIgnoreCase("APPLY")) continue;
                bonusObj2.addPreReq(new Prerequisite(prerequisite));
            }
            bonusObj2.setApplied(false);
            if (object4 instanceof PlayerCharacter) {
                if (bonusObj2.qualifies(this.pc)) {
                    bonusObj2.setApplied(true);
                }
                bonusObj2.setCreatorObject(pObject);
                bonusObj2.setTargetObject(object4);
                this.pc.addTempBonus(bonusObj2);
            } else if (object2 != null) {
                if (bonusObj2.passesPreReqToGain((Equipment)object2, this.pc)) {
                    bonusObj2.setApplied(true);
                }
                bonusObj2.setCreatorObject(pObject);
                bonusObj2.setTargetObject(object2);
                ((PObject)object2).addTempBonus(bonusObj2);
                this.pc.addTempBonus(bonusObj2);
                this.pc.setDirty(true);
            }
            System.err.println(pObject.getKeyName());
            System.err.println(pObject.getChoiceString());
            if (pObject.getChoiceString().length() <= 0) continue;
            string = this.getBonusChoice(bonusObj2, pObject.getChoiceString(), string);
        }
        if (object2 != null) {
            this.pc.addTempBonusItemList((Equipment)object2);
        }
        this.updateAppliedModel();
        this.updateTargetModel();
        this.pc.setDirty(true);
        this.pc.calcActiveBonuses();
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSpecialAbilities());
        characterInfo.setPaneForUpdate(characterInfo.infoClasses());
        characterInfo.setPaneForUpdate(characterInfo.infoAbilities());
        characterInfo.setPaneForUpdate(characterInfo.infoSkills());
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.setPaneForUpdate(characterInfo.infoSummary());
        characterInfo.refresh();
    }

    private final void createBonusModel() {
        if (this.bonusModel == null) {
            this.bonusModel = new BonusModel(0);
        } else {
            this.bonusModel.resetModel(0);
        }
        if (this.bonusSort != null) {
            this.bonusSort.setRoot((PObjectNode)this.bonusModel.getRoot());
            this.bonusSort.sortNodeOnColumn();
        }
    }

    private final void createModels() {
        this.createBonusModel();
        this.createTargetModel();
        this.createAppliedModel();
    }

    private final void createTargetModel() {
        if (this.targetModel == null) {
            this.targetModel = new BonusModel(1);
        } else {
            this.targetModel.resetModel(1);
        }
        if (this.targetSort != null) {
            this.targetSort.setRoot((PObjectNode)this.targetModel.getRoot());
            this.targetSort.sortNodeOnColumn();
        }
    }

    private void createAppliedModel() {
        if (this.appliedBonusModel == null) {
            this.appliedBonusModel = new AppliedModel();
        } else {
            this.appliedBonusModel.resetModel();
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("");
        this.refresh();
        int n = this.topVertSplit.getDividerLocation();
        int n2 = this.centerHorzSplit.getDividerLocation();
        int n3 = this.botHorzSplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            Container container = this.getParent();
            n = SettingsHandler.getPCGenOption("InfoTempMod.topVertSplit", container.getWidth() * 1 / 2);
            n2 = SettingsHandler.getPCGenOption("InfoTempMod.centerHorzSplit", container.getHeight() * 1 / 2);
            n3 = SettingsHandler.getPCGenOption("InfoTempMod.botHorzSplit", this.botPane.getHeight() * 1 / 2);
            for (n5 = 0; n5 < this.targetTable.getColumnCount(); ++n5) {
                tableColumn = this.targetTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("TempModSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.targetTable, "TempModSel", n5));
            }
            for (n5 = 0; n5 < this.bonusTable.getColumnCount(); ++n5) {
                tableColumn = this.bonusTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("TempModAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.bonusTable, "TempModAva", n5));
            }
        }
        if (n > 0) {
            this.topVertSplit.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoTempMod.topVertSplit", n);
        }
        if (n2 > 0) {
            this.centerHorzSplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoTempMod.centerHorzSplit", n2);
        }
        if (n3 > 0) {
            this.botHorzSplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoTempMod.botHorzSplit", n3);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new BonusPopupListener(jTreeTable, new BonusPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoTempMod.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = InfoTempMod.this.topVertSplit.getDividerLocation();
                if (n > 0) {
                    SettingsHandler.setPCGenOption("InfoTempMod.topVertSplit", n);
                }
                if ((n = InfoTempMod.this.botHorzSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoTempMod.botHorzSplit", n);
                }
                if ((n = InfoTempMod.this.centerHorzSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoTempMod.centerHorzSplit", n);
                }
            }
        });
        this.applyBonusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTempMod.this.applyBonusButton();
            }
        });
        this.removeBonusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTempMod.this.removeBonusButton();
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.createModels();
        this.createTreeTables();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.topPane.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel2.setLayout(gridBagLayout);
        this.applyBonusButton = new JButton(PropertyFactory.getString("in_itmInitCompAppBonTitle"));
        Utility.setDescription(this.applyBonusButton, PropertyFactory.getString("in_itmInitCompAppBonDesc"));
        this.applyBonusButton.setEnabled(false);
        this.applyBonusButton.setPreferredSize(new Dimension(60, 20));
        this.applyBonusButton.setSize(new Dimension(60, 20));
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagLayout.setConstraints(this.applyBonusButton, gridBagConstraints);
        this.topPane.add(this.applyBonusButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.topVertSplit = new FlippingSplitPane(1, jPanel, jPanel2);
        this.topVertSplit.setOneTouchExpandable(true);
        this.topVertSplit.setDividerSize(10);
        jPanel3.add((Component)this.topVertSplit, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 10.0, 10.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipadx = 1;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.topPane.add(jPanel3);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 10.0, 10.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipadx = 1;
        JScrollPane jScrollPane = new JScrollPane(this.bonusTable);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 10.0, 10.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipadx = 1;
        jScrollPane = new JScrollPane(this.targetTable);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.targetTable.setShowHorizontalLines(true);
        jPanel2.add(jScrollPane);
        this.botPane.setLayout(new BorderLayout());
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        jPanel5.setLayout(gridBagLayout);
        this.botHorzSplit = new FlippingSplitPane(0, jPanel4, jPanel5);
        this.botHorzSplit.setOneTouchExpandable(true);
        this.botHorzSplit.setDividerSize(10);
        this.botPane.add((Component)this.botHorzSplit, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 2.0, 2.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JScrollPane jScrollPane2 = new JScrollPane();
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_itmInitCompBorderInfo"));
        titledBorder.setTitleJustification(2);
        jScrollPane2.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane2.setViewportView(this.infoLabel);
        jPanel4.add(jScrollPane2);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        JPanel jPanel6 = new JPanel();
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(8, 0));
        this.removeBonusButton = new JButton(PropertyFactory.getString("in_itmInitCompRemoveButTitle"));
        this.removeBonusButton.setEnabled(false);
        this.tempModsDisabledWarning = new JLabel("");
        jPanel7.add((Component)this.removeBonusButton, "Center");
        jPanel7.add((Component)this.tempModsDisabledWarning, "East");
        jPanel6.add(jPanel7);
        Utility.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 10.0, 10.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JScrollPane jScrollPane3 = new JScrollPane(this.appliedTable);
        gridBagLayout.setConstraints(jScrollPane3, gridBagConstraints);
        jPanel5.add(jPanel6);
        jPanel5.add(jScrollPane3);
        this.centerHorzSplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.centerHorzSplit.setOneTouchExpandable(true);
        this.centerHorzSplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.centerHorzSplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoTempMod.this.refresh();
            }
        });
        this.bonusSort = new JTreeTableSorter(this.bonusTable, (PObjectNode)this.bonusModel.getRoot(), this.bonusModel);
        this.targetSort = new JTreeTableSorter(this.targetTable, (PObjectNode)this.targetModel.getRoot(), this.targetModel);
    }

    private void refreshButton() {
        this.forceRefresh();
    }

    /*
     * WARNING - void declaration
     */
    private void removeBonusButton() {
        if (this.appliedTable.getTree().isSelectionEmpty()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_itmRemBonButSelect"), "PCGen", MessageType.ERROR);
            return;
        }
        TreePath treePath = this.appliedTable.getTree().getSelectionPath();
        TempWrap tempWrap = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = treePath.getLastPathComponent();
        MyPONode myPONode = (MyPONode)object4;
        if (myPONode == null || myPONode.getItem() == null) {
            Logging.errorPrintLocalised("in_itmRemBoneButFnodeNull");
            return;
        }
        if (myPONode.getItem() instanceof TempWrap) {
            tempWrap = (TempWrap)myPONode.getItem();
        } else if (myPONode.getItem() instanceof String) {
            for (TempWrap object5 : this.tbwList) {
                if (!object5.getName().equals(myPONode.getItem())) continue;
                tempWrap = object5;
            }
        } else {
            Logging.errorPrintLocalised("in_itmRemBonButUnkownBonusType");
            return;
        }
        if (tempWrap != null) {
            object2 = tempWrap.getCreator();
            object3 = tempWrap.getTarget();
        }
        if (object3 == null || object2 == null) {
            Logging.errorPrintLocalised("in_itmRemBonButTargetNull");
            return;
        }
        Object object6 = null;
        Object var8_9 = null;
        if (object3 instanceof Equipment) {
            object6 = (Equipment)object3;
        } else if (object3 instanceof PlayerCharacter) {
            PlayerCharacter playerCharacter = (PlayerCharacter)object3;
        }
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>(this.pc.getTempBonusList());
        for (BonusObj bonusObj : arrayList) {
            void var8_11;
            Object object = bonusObj.getCreatorObject();
            Object object5 = bonusObj.getTargetObject();
            if (object5 instanceof Equipment && object6 != null) {
                if (!((Equipment)object6).equals(object5) || object2 != object) continue;
                this.pc.removeTempBonus(bonusObj);
                this.pc.removeTempBonusItemList((Equipment)object5);
                ((Equipment)object5).removeTempBonus(bonusObj);
                ((Equipment)object5).setAppliedName("");
                continue;
            }
            if (!(object5 instanceof PlayerCharacter) || var8_11 == null || (PlayerCharacter)object5 != var8_11 || object2 != object) continue;
            this.pc.removeTempBonus(bonusObj);
        }
        this.updateAppliedModel();
        this.updateTargetModel();
        this.pc.setDirty(true);
        this.pc.calcActiveBonuses();
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSpecialAbilities());
        characterInfo.setPaneForUpdate(characterInfo.infoClasses());
        characterInfo.setPaneForUpdate(characterInfo.infoAbilities());
        characterInfo.setPaneForUpdate(characterInfo.infoSkills());
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.setPaneForUpdate(characterInfo.infoSummary());
        characterInfo.refresh();
    }

    private void updateAppliedModel() {
        List<String> list = this.appliedTable.getExpandedPaths();
        this.createAppliedModel();
        this.appliedTable.updateUI();
        this.appliedTable.expandPathList(list);
    }

    private void updateBonusModel() {
        List<String> list = this.bonusTable.getExpandedPaths();
        this.createBonusModel();
        this.bonusTable.updateUI();
        this.bonusTable.expandPathList(list);
    }

    private void updateTargetModel() {
        List<String> list = this.targetTable.getExpandedPaths();
        this.createTargetModel();
        this.targetTable.updateUI();
        this.targetTable.expandPathList(list);
    }

    private static final class MyPONode
    extends PObjectNode {
        private MyPONode() {
        }

        private MyPONode(Object object) {
            super(object);
        }

        public String toString() {
            Object object = super.getItem();
            if (object == null) {
                return "";
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof TempWrap) {
                return "--";
            }
            return super.toString();
        }
    }

    private class BonusPopupMenu
    extends JPopupMenu {
        BonusPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == InfoTempMod.this.bonusTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_itmBonPopUpAppBon"), "shortcut EQUALS"));
                this.addSeparator();
                this.add(this.createRefreshMenuItem(PropertyFactory.getString("in_itmBonusPopUpRedraw")));
            } else if (jTreeTable == InfoTempMod.this.targetTable) {
                this.add(this.createRefreshMenuItem(PropertyFactory.getString("in_itmBonusPopUpRedraw")));
            } else if (jTreeTable == InfoTempMod.this.appliedTable) {
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_itmBonPopUpRemove"), "shortcut MINUS"));
            }
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddBonusActionListener(), PropertyFactory.getString("in_itmBonPopUpAppBon"), '\u0000', string2, PropertyFactory.getString("in_itmBonPopUpAppBonDesc"), "Add16.gif", true);
        }

        private JMenuItem createRefreshMenuItem(String string) {
            return Utility.createMenuItem(string, new RefreshActionListener(), PropertyFactory.getString("in_itmBonusPopUpRedraw"), '\u0000', null, PropertyFactory.getString("in_itmBonPopUpRedrawDesc"), "", true);
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveActionListener(), PropertyFactory.getString("in_itmBonPopUpRemove"), '\u0000', string2, PropertyFactory.getString("in_itmBonPopUpRemove"), "", true);
        }

        private class RemoveActionListener
        extends BonusActionListener {
            private RemoveActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTempMod.this.removeBonusButton();
            }
        }

        private class RefreshActionListener
        extends BonusActionListener {
            private RefreshActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTempMod.this.refreshButton();
            }
        }

        private class BonusActionListener
        implements ActionListener {
            private BonusActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class AddBonusActionListener
        extends BonusActionListener {
            private AddBonusActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTempMod.this.applyBonusButton();
            }
        }
    }

    private class BonusPopupListener
    extends MouseAdapter {
        private BonusPopupMenu menu;
        private JTree tree;

        BonusPopupListener(JTreeTable jTreeTable, BonusPopupMenu bonusPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = bonusPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoTempMod.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < BonusPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = BonusPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoTempMod.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoTempMod.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                this.tree.setSelectionPath(treePath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BonusModel
    extends AbstractTreeTableModel {
        private PObjectNode avaRoot;
        private PObjectNode selRoot;
        private String[] avaNameList;
        private String[] selNameList;
        private int modelType;

        private BonusModel(int n) {
            super(null);
            this.avaNameList = new String[]{""};
            this.selNameList = new String[]{""};
            this.modelType = 0;
            this.avaNameList = new String[]{PropertyFactory.getString("in_itmBonModelAvaNameName"), PropertyFactory.getString("in_itmBonModelAvaNameSource"), PropertyFactory.getString("in_itmBonModelAvaNameFile")};
            this.selNameList = new String[]{PropertyFactory.getString("in_itmBonModelSelNameName"), PropertyFactory.getString("in_itmBonModelSelNameTarget"), PropertyFactory.getString("in_itmBonModelSelNameFile")};
            this.modelType = n;
            this.resetModel(n);
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    Logging.errorPrintLocalised("in_itmBonModelGetColumnClassNotSupported", n);
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.modelType == 0 ? this.avaNameList.length : this.selNameList.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.modelType == 0 ? this.avaNameList[n] : this.selNameList[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            PObjectNode pObjectNode = (PObjectNode)object;
            Ability ability = null;
            Spell spell = null;
            Equipment equipment = null;
            PCClass pCClass = null;
            PCTemplate pCTemplate = null;
            Skill skill = null;
            PlayerCharacter playerCharacter = null;
            if (pObjectNode == null) {
                Logging.errorPrintLocalised("in_itmBonModelNoActiveNode");
                return null;
            }
            String string = null;
            if (pObjectNode.getItem() instanceof Equipment) {
                equipment = (Equipment)pObjectNode.getItem();
                string = new StringBuffer(equipment.longName()).append(equipment.getAppliedName()).toString();
            } else if (pObjectNode.getItem() instanceof Ability) {
                ability = (Ability)pObjectNode.getItem();
            } else if (pObjectNode.getItem() instanceof Spell) {
                spell = (Spell)pObjectNode.getItem();
            } else if (pObjectNode.getItem() instanceof ClassWrap) {
                ClassWrap classWrap = (ClassWrap)pObjectNode.getItem();
                pCClass = classWrap.getMyClass();
            } else if (pObjectNode.getItem() instanceof PCTemplate) {
                pCTemplate = (PCTemplate)pObjectNode.getItem();
            } else if (pObjectNode.getItem() instanceof Skill) {
                skill = (Skill)pObjectNode.getItem();
            } else if (pObjectNode.getItem() instanceof PlayerCharacter) {
                playerCharacter = (PlayerCharacter)pObjectNode.getItem();
            }
            switch (n) {
                case 0: {
                    if (playerCharacter != null) {
                        return playerCharacter.getName();
                    }
                    if (string != null) {
                        return string;
                    }
                    return pObjectNode != null ? pObjectNode.toString() : null;
                }
                case 1: {
                    if (equipment != null) {
                        return equipment.getType();
                    }
                    if (spell != null) {
                        return PropertyFactory.getString("in_itmBonModelTargetTypeSpell");
                    }
                    if (ability != null) {
                        return PropertyFactory.getString("in_itmBonModelTargetTypeSpell");
                    }
                    if (pCClass != null) {
                        return PropertyFactory.getString("in_itmBonModelTargetTypeClass");
                    }
                    if (pCTemplate != null) {
                        return PropertyFactory.getString("in_itmBonModelTargetTypeTemplate");
                    }
                    if (skill != null) {
                        return PropertyFactory.getString("in_itmBonModelTargetTypeSkill");
                    }
                    if (playerCharacter != null) {
                        return PropertyFactory.getString("in_itmBonModelTargetTypeCharacter");
                    }
                    return null;
                }
                case 2: {
                    if (equipment != null) {
                        return equipment.getDefaultSourceString();
                    }
                    if (spell != null) {
                        return spell.getDefaultSourceString();
                    }
                    if (ability != null) {
                        return ability.getDefaultSourceString();
                    }
                    if (pCClass != null) {
                        return pCClass.getDefaultSourceString();
                    }
                    if (pCTemplate != null) {
                        return pCTemplate.getDefaultSourceString();
                    }
                    if (skill != null) {
                        return skill.getDefaultSourceString();
                    }
                    return null;
                }
            }
            if (pObjectNode != null) {
                return pObjectNode.toString();
            }
            Logging.errorPrintLocalised("in_itmBonModelNoActiveNode");
            return null;
        }

        private void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        /*
         * WARNING - void declaration
         */
        private void resetModel(int n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("CUSTOM");
            for (Equipment object3 : InfoTempMod.this.pc.getEquipmentList()) {
                StringTokenizer stringTokenizer = new StringTokenizer(object3.getType(), ".", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            arrayList2.add("Feats");
            arrayList2.add("Items");
            arrayList2.add("Spells");
            arrayList2.add("Classes");
            arrayList2.add("Templates");
            arrayList2.add("Skills");
            if (n == 0) {
                this.avaRoot = new PObjectNode();
                this.setRoot(this.avaRoot);
                PObjectNode[] pObjectNodeArray = new PObjectNode[]{new PObjectNode("Feat"), new PObjectNode("Spell"), new PObjectNode("Item"), new PObjectNode("Class"), new PObjectNode("Templates"), new PObjectNode("Skills")};
                for (Ability ability : InfoTempMod.this.pc.aggregateFeatList()) {
                    for (BonusObj bonusObj : ability.getBonusList()) {
                        if (!bonusObj.isTempBonus()) continue;
                        PObjectNode pObjectNode = new PObjectNode(ability);
                        pObjectNode.setParent(pObjectNodeArray[0]);
                        pObjectNodeArray[0].addChild(pObjectNode, true);
                        pObjectNodeArray[0].setParent(this.avaRoot);
                    }
                }
                Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
                while (iterator.hasNext()) {
                    Ability ability = (Ability)iterator.next();
                    for (BonusObj bonusObj : ability.getBonusList()) {
                        if (!bonusObj.isTempBonus() || !bonusObj.isTempBonusTarget(BonusObj.TempBonusTarget.ANYPC)) continue;
                        PObjectNode pObjectNode = new PObjectNode(ability);
                        pObjectNode.setParent(pObjectNodeArray[0]);
                        pObjectNodeArray[0].addChild(pObjectNode, true);
                        pObjectNodeArray[0].setParent(this.avaRoot);
                    }
                }
                for (Spell spell : InfoTempMod.this.pc.aggregateSpellList("Any", "", "", "", 0, 9)) {
                    if (spell == null) continue;
                    for (BonusObj bonusObj : spell.getBonusList()) {
                        if (!bonusObj.isTempBonus()) continue;
                        PObjectNode pObjectNode = new PObjectNode(spell);
                        pObjectNode.setParent(pObjectNodeArray[1]);
                        pObjectNodeArray[1].addChild(pObjectNode, true);
                        pObjectNodeArray[1].setParent(this.avaRoot);
                    }
                }
                List<CharacterSpell> list = InfoTempMod.this.pc.getRace().getSpellSupport().getCharacterSpell(null, "Innate", -1);
                for (CharacterSpell characterSpell : list) {
                    if (characterSpell == null) continue;
                    for (BonusObj bonusObj : characterSpell.getSpell().getBonusList()) {
                        if (!bonusObj.isTempBonus()) continue;
                        PObjectNode pObjectNode = new PObjectNode(characterSpell.getSpell());
                        pObjectNode.setParent(pObjectNodeArray[1]);
                        pObjectNodeArray[1].addChild(pObjectNode, true);
                        pObjectNodeArray[1].setParent(this.avaRoot);
                    }
                }
                for (Object obj : Globals.getSpellMap().values()) {
                    void var8_66;
                    Object var8_64 = null;
                    if (obj instanceof Spell) {
                        Spell spell = (Spell)obj;
                    } else if (obj instanceof ArrayList) continue;
                    if (var8_66 == null) continue;
                    for (BonusObj bonusObj : var8_66.getBonusList()) {
                        if (!bonusObj.isTempBonus() || bonusObj.isTempBonusTarget(BonusObj.TempBonusTarget.PC)) continue;
                        PObjectNode pObjectNode = new PObjectNode(var8_66);
                        pObjectNode.setParent(pObjectNodeArray[1]);
                        pObjectNodeArray[1].addChild(pObjectNode, true);
                        pObjectNodeArray[1].setParent(this.avaRoot);
                    }
                }
                if (!pObjectNodeArray[1].isLeaf()) {
                    pObjectNodeArray[1].setParent(this.avaRoot);
                }
                for (Equipment equipment : InfoTempMod.this.pc.getEquipmentList()) {
                    for (BonusObj bonusObj : equipment.getBonusList()) {
                        if (!bonusObj.isTempBonus()) continue;
                        PObjectNode pObjectNode = new PObjectNode(equipment);
                        pObjectNode.setParent(pObjectNodeArray[2]);
                        pObjectNodeArray[2].addChild(pObjectNode, true);
                        pObjectNodeArray[2].setParent(this.avaRoot);
                    }
                }
                if (!pObjectNodeArray[2].isLeaf()) {
                    pObjectNodeArray[2].setParent(this.avaRoot);
                }
                for (PCClass pCClass : InfoTempMod.this.pc.getClassList()) {
                    for (BonusObj bonusObj : pCClass.getBonusList()) {
                        int n2 = pCClass.getLevel();
                        int n3 = bonusObj.getPCLevel();
                        if (!bonusObj.isTempBonus() || n2 < n3) continue;
                        PObjectNode pObjectNode = new PObjectNode(new ClassWrap(pCClass, n3));
                        pObjectNode.setParent(pObjectNodeArray[3]);
                        pObjectNodeArray[3].addChild(pObjectNode, true);
                        pObjectNodeArray[3].setParent(this.avaRoot);
                    }
                }
                if (!pObjectNodeArray[3].isLeaf()) {
                    pObjectNodeArray[3].setParent(this.avaRoot);
                }
                for (PCTemplate pCTemplate : InfoTempMod.this.pc.getTemplateList()) {
                    for (BonusObj bonusObj : pCTemplate.getBonusList()) {
                        if (!bonusObj.isTempBonus()) continue;
                        PObjectNode pObjectNode = new PObjectNode(pCTemplate);
                        pObjectNode.setParent(pObjectNodeArray[4]);
                        pObjectNodeArray[4].addChild(pObjectNode, true);
                        pObjectNodeArray[4].setParent(this.avaRoot);
                    }
                }
                for (PCTemplate pCTemplate : Globals.getTemplateList()) {
                    for (BonusObj bonusObj : pCTemplate.getBonusList()) {
                        if (!bonusObj.isTempBonus() || !bonusObj.isTempBonusTarget(BonusObj.TempBonusTarget.ANYPC)) continue;
                        PObjectNode pObjectNode = new PObjectNode(pCTemplate);
                        pObjectNode.setParent(pObjectNodeArray[4]);
                        pObjectNodeArray[4].addChild(pObjectNode, true);
                        pObjectNodeArray[4].setParent(this.avaRoot);
                    }
                }
                if (!pObjectNodeArray[4].isLeaf()) {
                    pObjectNodeArray[4].setParent(this.avaRoot);
                }
                ArrayList<Skill> arrayList3 = new ArrayList<Skill>(InfoTempMod.this.pc.getSkillList());
                for (Skill skill : arrayList3) {
                    for (BonusObj bonusObj : skill.getBonusList()) {
                        if (!bonusObj.isTempBonus()) continue;
                        PObjectNode pObjectNode = new PObjectNode(skill);
                        pObjectNode.setParent(pObjectNodeArray[5]);
                        pObjectNodeArray[5].addChild(pObjectNode, true);
                        pObjectNodeArray[5].setParent(this.avaRoot);
                    }
                }
                if (!pObjectNodeArray[5].isLeaf()) {
                    pObjectNodeArray[5].setParent(this.avaRoot);
                }
                this.avaRoot.setChildren(pObjectNodeArray);
            } else {
                this.selRoot = new PObjectNode();
                this.setRoot(this.selRoot);
                if (InfoTempMod.this.lastAvaObject == null) {
                    return;
                }
                boolean bl = false;
                for (BonusObj bonusObj : InfoTempMod.this.lastAvaObject.getBonusList()) {
                    if (bonusObj == null || !bonusObj.isTempBonus() || !bonusObj.isTempBonusTarget(BonusObj.TempBonusTarget.ANYPC) && !bonusObj.isTempBonusTarget(BonusObj.TempBonusTarget.PC) || bl) continue;
                    PObjectNode pObjectNode = new PObjectNode(InfoTempMod.this.pc);
                    pObjectNode.setParent(this.selRoot);
                    this.selRoot.addChild(pObjectNode, true);
                    bl = true;
                }
                InfoTempMod.this.pc.setCalcEquipmentList(InfoTempMod.this.pc.getUseTempMods());
                for (Equipment equipment : InfoTempMod.this.pc.getEquipmentList()) {
                    bl = false;
                    for (BonusObj bonusObj : InfoTempMod.this.lastAvaObject.getBonusList()) {
                        if (bonusObj == null || !bonusObj.isTempBonus()) continue;
                        boolean bl2 = true;
                        Iterator<Prerequisite> iterator = bonusObj.getPreReqList().iterator();
                        while (iterator.hasNext() && bl2) {
                            Prerequisite prerequisite = iterator.next();
                            if (prerequisite.getKind() == null || !prerequisite.getKind().equalsIgnoreCase("APPLY") || PrereqHandler.passes(prerequisite, equipment, InfoTempMod.this.pc)) continue;
                            bl2 = false;
                        }
                        if (!bl2 || bl) continue;
                        PObjectNode pObjectNode = new PObjectNode(equipment);
                        pObjectNode.setParent(this.selRoot);
                        pObjectNode.setDisplayName(new StringBuffer(equipment.longName()).append(equipment.getAppliedName()).toString());
                        this.selRoot.addChild(pObjectNode);
                        bl = true;
                    }
                }
                this.setRoot(this.selRoot);
            }
            PObjectNode pObjectNode = (PObjectNode)super.getRoot();
            if (pObjectNode != null && pObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AppliedModel
    extends AbstractTreeTableModel {
        private String[] colNameList;
        private MyPONode bonusRoot;

        private AppliedModel() {
            super(null);
            this.colNameList = new String[]{PropertyFactory.getString("in_itmAppModelNameTarget"), PropertyFactory.getString("in_itmAppModelBonusType"), PropertyFactory.getString("in_itmAppModelBonusTo"), PropertyFactory.getString("in_itmAppModelBonusValue")};
            this.resetModel();
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.colNameList.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.colNameList[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            MyPONode myPONode = (MyPONode)object;
            TempWrap tempWrap = null;
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (myPONode == null) {
                Logging.errorPrintLocalised("in_itmAppModelNoActiveNode");
                return null;
            }
            if (myPONode.getItem() instanceof TempWrap) {
                tempWrap = (TempWrap)myPONode.getItem();
                BonusObj bonusObj = tempWrap.getBonus();
                tempWrap.getTarget();
                string2 = bonusObj.getTypeOfBonus();
                string3 = bonusObj.getBonusInfo();
                string4 = InfoTempMod.this.pc.getVariableValue(bonusObj.getValue(), "").toString();
            } else if (myPONode.getItem() instanceof String) {
                string = myPONode.toString();
            }
            switch (n) {
                case 0: {
                    if (tempWrap != null) {
                        return tempWrap;
                    }
                    if (string.length() > 0) {
                        return string;
                    }
                    return null;
                }
                case 1: {
                    return string2;
                }
                case 2: {
                    return string3;
                }
                case 3: {
                    return string4;
                }
            }
            if (myPONode != null) {
                return myPONode.toString();
            }
            Logging.errorPrintLocalised("in_itmAppModelNoActiveNode");
            return null;
        }

        private void setRoot(MyPONode myPONode) {
            super.setRoot(myPONode);
        }

        private void resetModel() {
            String string;
            TempWrap tempWrap;
            Object object;
            this.bonusRoot = new MyPONode();
            ArrayList<String> arrayList = new ArrayList<String>();
            InfoTempMod.this.tbwList = new ArrayList();
            for (BonusObj bonusObj : InfoTempMod.this.pc.getTempBonusList()) {
                object = bonusObj.getCreatorObject();
                Object object2 = bonusObj.getTargetObject();
                tempWrap = new TempWrap(object, object2, bonusObj);
                InfoTempMod.this.tbwList.add(tempWrap);
                string = tempWrap.getName();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            PObjectNode[] pObjectNodeArray = new MyPONode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (String)arrayList.get(i);
                pObjectNodeArray[i] = new MyPONode();
                pObjectNodeArray[i].setItem(object);
                for (int j = 0; j < InfoTempMod.this.tbwList.size(); ++j) {
                    tempWrap = (TempWrap)InfoTempMod.this.tbwList.get(j);
                    string = tempWrap.getName();
                    if (!((String)object).equals(string)) continue;
                    MyPONode myPONode = new MyPONode(tempWrap);
                    myPONode.setParent(pObjectNodeArray[i]);
                    pObjectNodeArray[i].addChild(myPONode);
                }
                if (pObjectNodeArray[i].isLeaf()) continue;
                pObjectNodeArray[i].setParent(this.bonusRoot);
            }
            this.bonusRoot.setChildren(pObjectNodeArray);
            this.setRoot(this.bonusRoot);
            MyPONode myPONode = (MyPONode)super.getRoot();
            if (myPONode != null && myPONode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }

    public static final class TempWrap {
        private BonusObj _bonus = null;
        private Object _creator = null;
        private Object _target = null;

        public TempWrap(Object object, Object object2, BonusObj bonusObj) {
            this._creator = object;
            this._target = object2;
            this._bonus = bonusObj;
        }

        public BonusObj getBonus() {
            return this._bonus;
        }

        public Object getCreator() {
            return this._creator;
        }

        public String getName() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._creator instanceof PlayerCharacter) {
                stringBuffer.append(((PlayerCharacter)this._creator).getName());
            } else if (this._creator instanceof PObject) {
                stringBuffer.append(this._creator.toString());
            }
            stringBuffer.append(" [");
            if (this._target instanceof PlayerCharacter) {
                stringBuffer.append(PropertyFactory.getString("in_itmTmpWrapGetNamePC"));
            } else if (this._target instanceof Equipment) {
                stringBuffer.append(((Equipment)this._target).getName());
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public Object getTarget() {
            return this._target;
        }
    }

    public static final class ClassWrap {
        private PCClass _class = null;
        private int _level = 0;

        public ClassWrap(PCClass pCClass, int n) {
            this._class = pCClass;
            this._level = n;
        }

        public int getLevel() {
            return this._level;
        }

        public PCClass getMyClass() {
            return this._class;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._class.getDisplayName());
            stringBuffer.append(" (").append(this._level).append(")");
            return stringBuffer.toString();
        }
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoTempMod.this.removeBonusButton();
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoTempMod.this.applyBonusButton();
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }
}

