/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import pcgen.core.GameMode;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.tabs.BaseCharacterInfoTab;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabContainer
extends JTabbedPane
implements Filterable,
CharacterInfoTab {
    private PlayerCharacter thePC = null;
    private int theSerial = 0;
    private boolean theReadyForRefreshFlag = false;
    private List<BaseCharacterInfoTab> theSubTabs = new ArrayList<BaseCharacterInfoTab>();

    public TabContainer(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
        this.setName(this.getTab().toString());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TabContainer.this.refresh();
            }
        });
    }

    public void addSubTab(BaseCharacterInfoTab baseCharacterInfoTab) {
        this.theReadyForRefreshFlag = true;
        this.theSubTabs.add(baseCharacterInfoTab);
        this.add(baseCharacterInfoTab);
        this.setTitleAt(this.getTabCount() - 1, baseCharacterInfoTab.getTabName());
    }

    @Override
    public List<PObjectFilter> getAvailableFilters() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return null;
        }
        return this.theSubTabs.get(n).getAvailableFilters();
    }

    @Override
    public int getFilterMode() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return 0;
        }
        return this.theSubTabs.get(n).getFilterMode();
    }

    @Override
    public List<PObjectFilter> getRemovedFilters() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return null;
        }
        return this.theSubTabs.get(n).getRemovedFilters();
    }

    @Override
    public List<PObjectFilter> getSelectedFilters() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return null;
        }
        return this.theSubTabs.get(n).getSelectedFilters();
    }

    @Override
    public int getSelectionMode() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return -2;
        }
        return this.theSubTabs.get(n).getSelectionMode();
    }

    @Override
    public void initializeFilters() {
        int n = this.getSelectedIndex();
        if (n >= 0 && n < this.theSubTabs.size()) {
            this.theSubTabs.get(n).initializeFilters();
        }
    }

    @Override
    public boolean isMatchAnyEnabled() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return true;
        }
        return this.theSubTabs.get(n).isMatchAnyEnabled();
    }

    @Override
    public boolean isNegateEnabled() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return true;
        }
        return this.theSubTabs.get(n).isNegateEnabled();
    }

    @Override
    public void refreshFiltering() {
        int n = this.getSelectedIndex();
        if (n >= 0 && n < this.theSubTabs.size()) {
            this.theSubTabs.get(n).refreshFiltering();
        }
    }

    @Override
    public void setFilterMode(int n) {
        int n2 = this.getSelectedIndex();
        if (n2 >= 0 && n2 < this.theSubTabs.size()) {
            this.theSubTabs.get(n2).setFilterMode(n);
        }
    }

    @Override
    public void forceRefresh() {
        if (this.theReadyForRefreshFlag) {
            this.setNeedsUpdate(true);
            for (BaseCharacterInfoTab baseCharacterInfoTab : this.theSubTabs) {
                baseCharacterInfoTab.setPc(this.thePC);
            }
        } else {
            this.theSerial = 0;
        }
    }

    public void setNeedsUpdate(boolean bl) {
        for (BaseCharacterInfoTab baseCharacterInfoTab : this.theSubTabs) {
            baseCharacterInfoTab.setNeedsUpdate(bl);
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.thePC;
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BaseCharacterInfoTab baseCharacterInfoTab : this.theSubTabs) {
            arrayList.addAll(baseCharacterInfoTab.getToDos());
        }
        return arrayList;
    }

    @Override
    public JComponent getView() {
        return this;
    }

    protected abstract Tab getTab();

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(this.getTab());
    }

    @Override
    public void refresh() {
        if (this.thePC.getSerial() > this.theSerial) {
            this.theSerial = this.thePC.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.thePC != playerCharacter || playerCharacter.getSerial() > this.theSerial) {
            this.thePC = playerCharacter;
            this.theSerial = this.thePC.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(this.getTab());
    }

    @Override
    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.theSubTabs.size()) {
            return true;
        }
        return this.theSubTabs.get(n).accept(playerCharacter, pObject);
    }
}

