/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.TableColumnManager;
import pcgen.gui.filter.Filterable;
import pcgen.gui.tabs.IFilterableView;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.tabs.ability.AbilityModel;
import pcgen.gui.tabs.ability.IAbilityListFilter;
import pcgen.gui.tabs.ability.IAbilitySelectionListener;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbilitySelectionPanel
extends JPanel
implements IFilterableView,
IAbilityListFilter {
    private PlayerCharacter thePC;
    private AbilityCategory theCategory;
    protected AbilityModel theModel;
    protected JTreeTable theTable;
    protected JTreeTableSorter theSorter;
    private List<IAbilitySelectionListener> theListeners = new ArrayList<IAbilitySelectionListener>(2);
    private String theOptionsRoot = "InfoAbility.";
    private ViewMode theViewMode = ViewMode.PREREQTREE;
    private transient ViewMode theSavedViewMode = null;
    private Filterable theFilter = null;

    public AbilitySelectionPanel(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        this.thePC = playerCharacter;
        this.theCategory = abilityCategory;
        this.theOptionsRoot = this.theOptionsRoot + abilityCategory.getKeyName();
        int n = SettingsHandler.getPCGenOption(this.getFullOptionKey() + ".viewmode", this.getDefaultViewMode().ordinal());
        this.theViewMode = ViewMode.values()[n];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbilitySelectionPanel.this.initComponents();
            }
        });
    }

    public PlayerCharacter getPC() {
        return this.thePC;
    }

    public void setPC(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    public AbilityCategory getCategory() {
        return this.theCategory;
    }

    protected abstract List<Ability> getAbilityList();

    protected abstract String getOptionKey();

    protected void initComponents() {
        Object object;
        Serializable serializable;
        this.theModel = new AbilityModel(this.thePC, this.getAbilityList(), this.theCategory, this.theViewMode, this.getFullOptionKey());
        this.theModel.setAbilityFilter(this);
        this.theTable = new JTreeTable(this.theModel);
        TableColumnModel tableColumnModel = this.theTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            serializable = tableColumnModel.getColumn(i);
            object = AbilityModel.Column.get(i);
            int n = SettingsHandler.getPCGenOption(this.getFullOptionKey() + ".sizecol." + ((Enum)object).toString(), ((AbilityModel.Column)((Object)object)).getWidth());
            ((TableColumn)serializable).setPreferredWidth(n);
            ((TableColumn)serializable).addPropertyChangeListener(new PropertyChangeListener((TableColumn)serializable){
                final /* synthetic */ TableColumn val$col;
                {
                    this.val$col = tableColumn;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("width")) {
                        SettingsHandler.setPCGenOption(AbilitySelectionPanel.this.getFullOptionKey() + ".sizecol." + (Object)((Object)AbilityModel.Column.get(this.val$col.getModelIndex())), Integer.parseInt(propertyChangeEvent.getNewValue().toString()));
                    }
                }
            });
        }
        this.theSorter = new JTreeTableSorter(this.theTable, (PObjectNode)this.theModel.getRoot(), this.theModel);
        this.addListSelectionListener();
        JTree jTree = this.theTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        serializable = new JScrollPane(this.theTable, 22, 30);
        this.add((Component)serializable, "Center");
        object = new JButton();
        ((JScrollPane)serializable).setCorner("UPPER_RIGHT_CORNER", (Component)object);
        ((AbstractButton)object).setText("^");
        new TableColumnManager(this.theTable, (JComponent)object, this.theModel);
    }

    public void addAbilitySelectionListener(IAbilitySelectionListener iAbilitySelectionListener) {
        if (!this.theListeners.contains(iAbilitySelectionListener)) {
            this.theListeners.add(iAbilitySelectionListener);
        }
    }

    public List<IAbilitySelectionListener> getListeners() {
        return Collections.unmodifiableList(this.theListeners);
    }

    private void addListSelectionListener() {
        this.theTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoTabUtils.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = AbilitySelectionPanel.this.theTable.getTree().getPathForRow(n).getLastPathComponent();
                    final Ability ability = AbilitySelectionPanel.this.getAbilityFromObject(object);
                    for (final IAbilitySelectionListener iAbilitySelectionListener : AbilitySelectionPanel.this.theListeners) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                AbilitySelectionPanel.this.abilitySelected(ability);
                                iAbilitySelectionListener.abilitySelected(ability);
                            }
                        });
                    }
                }
            }
        });
    }

    protected void abilitySelected(Ability ability) {
    }

    protected Ability getAbilityFromObject(Object object) {
        Object object2;
        if (object == null) {
            Logging.debugPrint("No ability selected while processing event");
            return null;
        }
        if (object instanceof PObjectNode && (object2 = ((PObjectNode)object).getItem()) instanceof Ability) {
            return (Ability)object2;
        }
        return null;
    }

    public abstract ViewMode getDefaultViewMode();

    public void setViewMode(int n) {
        this.theViewMode = ViewMode.values()[n];
        if (this.theModel != null) {
            this.theModel.setViewMode(this.theViewMode);
        }
        SettingsHandler.setPCGenOption(this.getFullOptionKey() + ".viewmode", n);
    }

    @Override
    public void clearQFilter() {
        this.theModel.clearQFilter();
        if (this.theSavedViewMode != null) {
            this.theViewMode = this.theSavedViewMode;
            this.theSavedViewMode = null;
        }
        this.theModel.resetModel(this.thePC, this.theViewMode, false);
        this.theTable.updateUI();
    }

    @Override
    public int getInitialChoice() {
        return this.theViewMode.ordinal();
    }

    @Override
    public List<String> getViewChoices() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add(PropertyFactory.getString("in_typeName"));
        arrayList.add(PropertyFactory.getString("in_nameLabel"));
        arrayList.add(PropertyFactory.getString("in_preReqTree"));
        arrayList.add(PropertyFactory.getString("in_sourceName"));
        return arrayList;
    }

    @Override
    public void setQFilter(String string) {
        this.theModel.setQFilter(string);
        if (this.theSavedViewMode == null) {
            this.theSavedViewMode = this.theViewMode;
        }
        this.theViewMode = ViewMode.NAMEONLY;
        this.theModel.resetModel(this.thePC, this.theViewMode, false);
        this.theTable.updateUI();
    }

    @Override
    public void viewChanged(int n) {
        this.setViewMode(n);
        this.rebuildView();
    }

    public void rebuildView() {
        if (this.theTable != null) {
            List<String> list = this.theTable.getExpandedPaths();
            this.theModel.resetModel(this.thePC, this.theViewMode, false);
            if (this.theSorter != null) {
                this.theSorter.sortNodeOnColumn();
            }
            this.theTable.updateUI();
            this.theTable.expandPathList(list);
        }
    }

    public void update() {
        if (this.theTable != null) {
            this.theModel.setAbilityList(this.getAbilityList());
            if (this.theSorter != null) {
                this.theSorter.sortNodeOnColumn();
            }
            this.theTable.updateUI();
        }
    }

    public void addFilterer(Filterable filterable) {
        this.theFilter = filterable;
    }

    @Override
    public boolean accept(ViewMode viewMode, Ability ability) {
        if (ability.getVisibility() != Visibility.DEFAULT && ability.getVisibility() != Visibility.DISPLAY_ONLY) {
            return false;
        }
        return this.theFilter == null || this.theFilter.accept(this.getPC(), ability);
    }

    private String getFullOptionKey() {
        return this.theOptionsRoot + "." + this.getOptionKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewMode {
        TYPENAME,
        NAMEONLY,
        PREREQTREE,
        SOURCENAME;

    }
}

