/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.NumberFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    public static DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    JFormattedTextField m_component = null;
    ActionListener m_listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            FormattedCellEditor.this.stopCellEditing();
        }
    };

    public FormattedCellEditor(JFormattedTextField jFormattedTextField) {
        this.setup(jFormattedTextField);
    }

    public FormattedCellEditor(Object object) {
        this.setup(object.getClass());
    }

    public FormattedCellEditor(Class<?> clazz) {
        this.setup(clazz);
    }

    private void setup(Class<?> clazz) {
        DefaultFormatter defaultFormatter = null;
        defaultFormatter = clazz == Float.class ? new NumberFormatter(NumberFormat.getInstance()) : (clazz == Integer.class ? new NumberFormatter(NumberFormat.getIntegerInstance()) : (clazz == Date.class ? new DateFormatter(DEFAULT_DATE_FORMAT) : new DefaultFormatter()));
        defaultFormatter.setValueClass(clazz);
        JFormattedTextField jFormattedTextField = new JFormattedTextField(defaultFormatter);
        if (jFormattedTextField.getFormatter() instanceof NumberFormatter) {
            jFormattedTextField.setHorizontalAlignment(4);
        }
        this.setup(jFormattedTextField);
    }

    private void setup(JFormattedTextField jFormattedTextField) {
        this.m_component = jFormattedTextField;
        JFormattedTextField.AbstractFormatter abstractFormatter = this.m_component.getFormatter();
        if (abstractFormatter instanceof DefaultFormatter) {
            ((DefaultFormatter)abstractFormatter).setAllowsInvalid(true);
            ((DefaultFormatter)abstractFormatter).setCommitsOnValidEdit(true);
            ((DefaultFormatter)abstractFormatter).setOverwriteMode(false);
        }
        this.m_component.setBorder(BorderFactory.createLineBorder(Color.black));
        this.m_component.addActionListener(this.m_listener);
        this.m_component.setFocusLostBehavior(1);
        this.m_component.addPropertyChangeListener(new PropertyChangeListener(){
            Border m_originalBorder;
            {
                this.m_originalBorder = FormattedCellEditor.this.m_component.getBorder();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("editValid") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        FormattedCellEditor.this.m_component.setBorder(this.m_originalBorder);
                    } else {
                        FormattedCellEditor.this.m_component.setBorder(BorderFactory.createLineBorder(Color.red));
                    }
                }
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_component.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.m_component.setValue(object);
        this.m_component.requestFocus();
        this.m_component.selectAll();
        return this.m_component;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return true;
    }
}

