/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class JOpenRecentMenu
extends JMenu {
    static final long serialVersionUID = -1385714650728604115L;
    private FixedArrayList<OpenRecentEntry> entries = null;
    private OpenRecentCallback cb = null;

    public JOpenRecentMenu(OpenRecentCallback openRecentCallback) {
        this.standardMenuFeatures();
        this.setEnabled(false);
        this.cb = openRecentCallback;
        this.entries = new FixedArrayList();
    }

    public final void setEntriesAsStrings(String[] stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            try {
                this.add(stringArray[i], new File(stringArray[i + 1]));
                continue;
            }
            catch (Exception exception) {
                Logging.errorPrint("Error setting old character " + stringArray[i] + ".", exception);
            }
        }
    }

    public final String[] getEntriesAsStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.entries != null) {
            for (int i = this.entries.size() - 1; i >= 0; --i) {
                OpenRecentEntry openRecentEntry = (OpenRecentEntry)this.entries.get(i);
                arrayList.add(openRecentEntry.displayAs);
                arrayList.add(openRecentEntry.file.getAbsolutePath());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public final void add(String string, File file) {
        this.doAddUpdateEntry(new OpenRecentEntry(string, file));
    }

    private void doAddEntry(OpenRecentEntry openRecentEntry) {
        this.doRemoveEntry(openRecentEntry);
        this.entries.add(openRecentEntry);
    }

    private void doAddUpdateEntry(OpenRecentEntry openRecentEntry) {
        this.doAddEntry(openRecentEntry);
        this.updateMenu();
    }

    private void doRemoveEntry(OpenRecentEntry openRecentEntry) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!((OpenRecentEntry)this.entries.get(i)).equals(openRecentEntry)) continue;
            this.entries.remove(i);
            break;
        }
    }

    private void doRemoveUpdateEntry(OpenRecentEntry openRecentEntry) {
        this.doRemoveEntry(openRecentEntry);
        this.updateMenu();
    }

    private void standardMenuFeatures() {
        this.setText(PropertyFactory.getString("in_mnuOpenRecent"));
        this.setMnemonic(PropertyFactory.getMnemonic("in_mn_mnuOpenRecent"));
        Utility.setDescription(this, PropertyFactory.getString("in_mnuOpenRecentTip"));
    }

    private final void updateMenu() {
        this.setEnabled(false);
        this.removeAll();
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            this.add(this.createMenuItem((OpenRecentEntry)this.entries.get(i)));
        }
        if (n != 0) {
            this.setEnabled(true);
        }
    }

    private JMenuItem createMenuItem(OpenRecentEntry openRecentEntry) {
        return Utility.createMenuItem(openRecentEntry.displayAs, new OpenRecentActionListener(this, openRecentEntry, this.cb), null, '\u0000', null, openRecentEntry.file.getAbsolutePath(), null, true);
    }

    private static final class OpenRecentEntry {
        private File file;
        private String displayAs;

        OpenRecentEntry(String string, File file) {
            this.displayAs = string;
            this.file = file;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof OpenRecentEntry)) {
                return false;
            }
            OpenRecentEntry openRecentEntry = (OpenRecentEntry)object;
            return this.file.equals(openRecentEntry.file);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static final class OpenRecentActionListener
    implements ActionListener {
        private JOpenRecentMenu menu = null;
        private OpenRecentCallback cb = null;
        private OpenRecentEntry entry = null;

        OpenRecentActionListener(JOpenRecentMenu jOpenRecentMenu, OpenRecentEntry openRecentEntry, OpenRecentCallback openRecentCallback) {
            this.menu = jOpenRecentMenu;
            this.entry = openRecentEntry;
            this.cb = openRecentCallback;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.entry.file.exists()) {
                this.menu.doAddUpdateEntry(this.entry);
                this.cb.openRecentPerformed(actionEvent, this.entry.file);
            } else {
                this.menu.doRemoveUpdateEntry(this.entry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixedArrayList<T>
    extends ArrayList<T> {
        private int max = 0;

        FixedArrayList() {
            this(5);
        }

        FixedArrayList(int n) {
            super(n);
            this.max = n;
        }

        @Override
        public boolean add(T t) {
            super.add(0, t);
            int n = this.size();
            while (n > this.max) {
                this.remove(--n);
            }
            return true;
        }
    }

    public static interface OpenRecentCallback {
        public void openRecentPerformed(ActionEvent var1, File var2);
    }
}

