/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import pcgen.core.Globals;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.chooser.ChooserTableModel;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwingChooserUserInput
extends JDialog
implements ChooserInterface {
    static final long serialVersionUID = -2148735105737308335L;
    private static final String in_uichooser_value = PropertyFactory.getString("in_uichooser_value");
    private static final String in_selected = PropertyFactory.getString("in_selected");
    private static final String in_completeMess = PropertyFactory.getString("in_completeMess");
    private static final String in_chooser = PropertyFactory.getString("in_chooser");
    private static final String in_selRemain = PropertyFactory.getString("in_selRemain");
    private static final String in_validItem = PropertyFactory.getString("in_validItem");
    private static final String in_deselectOne = PropertyFactory.getString("in_deselectOne");
    private static final String in_noRemain = PropertyFactory.getString("in_noRemain");
    private static final String in_selectPartA = PropertyFactory.getString("in_selectPartA");
    private static final String in_selectPartB = PropertyFactory.getString("in_selectPartB");
    private static final String in_alreadySelected = PropertyFactory.getString("in_alreadySelected");
    private static final String in_closeChooserTip = PropertyFactory.getString("in_closeChooserTip");
    private static final String in_pressToAdd = PropertyFactory.getString("in_pressToAdd");
    private static final String in_pressToRemove = PropertyFactory.getString("in_pressToRemove");
    private static final String in_removeOne = PropertyFactory.getString("in_removeOne");
    private static final List<String> SELECTED_COLUMN_NAMES = Arrays.asList(in_selected);
    private ChooserTableModel mSelectedModel = new ChooserTableModel();
    private JButton mAddButton;
    private JButton mCloseButton;
    private JButton mRemoveButton;
    private JLabel mPoolText;
    private JLabelPane mMessageText;
    private JLabel mAvailLabel;
    private JTextField mAvailableText;
    private JTableEx mSelectedTable;
    private List<String> mSelectedColumnNames;
    private List mSelectedList = new ArrayList();
    private List mUniqueList = new ArrayList();
    private String mSelectedTerminator = "";
    private boolean canGoNegative = false;
    private boolean mAllowDuplicates = false;
    private boolean mPoolFlag = true;
    private int mPool;

    public SwingChooserUserInput() {
        super(Globals.getCurrentFrame());
        this.initComponents();
    }

    @Override
    public void setAllowsDups(boolean bl) {
        this.mAllowDuplicates = bl;
    }

    @Override
    public void setCostColumnNumber(int n) {
    }

    @Override
    public void setMessageText(String string) {
        String string2 = string == null || string.trim().length() == 0 ? "<html>&nbsp;</html>" : string;
        this.mMessageText.setText(string2);
    }

    @Override
    public void setNegativeAllowed(boolean bl) {
        this.canGoNegative = bl;
    }

    @Override
    public void setPool(int n) {
        this.mPool = n;
        this.mPoolText.setText(Integer.toString(this.mPool));
    }

    @Override
    public int getPool() {
        return this.mPool;
    }

    @Override
    public void setPoolFlag(boolean bl) {
        this.mPoolFlag = bl;
    }

    @Override
    public List getSelectedList() {
        return new ArrayList(this.mSelectedList);
    }

    @Override
    public void setSelectedListTerminator(String string) {
        this.mSelectedTerminator = string;
    }

    @Override
    public void setUniqueList(List list) {
        this.mUniqueList = list;
    }

    @Override
    public void setVisible(boolean bl) {
        this.updateSelectedTable();
        this.updateButtonStates();
        Window window = this.getOwner();
        Rectangle rectangle = window.getBounds();
        Rectangle rectangle2 = this.getBounds();
        int n = (int)rectangle2.getWidth();
        int n2 = (int)rectangle2.getHeight();
        this.setBounds((int)((double)window.getX() + (rectangle.getWidth() - (double)n) / 2.0), (int)((double)window.getY() + (rectangle.getHeight() - (double)n2) / 2.0), n, n2);
        super.setVisible(bl);
    }

    private int getAdjustment(String string) {
        int n = 1;
        return n;
    }

    @Override
    public void setAvailableColumnNames(List<String> list) {
    }

    @Override
    public void setAvailableList(List list) {
    }

    public void setSelectedColumnNames(List<String> list) {
        this.mSelectedColumnNames = list;
        this.mSelectedModel.setColumnsNames(list == null ? Globals.EMPTY_STRING_ARRAY : list.toArray(new String[list.size()]));
    }

    @Override
    public void setSelectedList(List list) {
        this.mSelectedList = list;
    }

    private void windowCloseEvent() {
        if (!this.mCloseButton.isEnabled() && JOptionPane.showConfirmDialog(this, "You still have choices remaining. Are you sure you want to close the dialog?", "PCGen", 0, 3) == 1) {
            return;
        }
        this.setVisible(false);
    }

    private boolean close() {
        if (this.mPool <= 0 || !this.mPoolFlag) {
            this.setVisible(false);
            return true;
        }
        this.setMessageText(in_completeMess);
        return false;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SwingChooserUserInput.this.windowCloseEvent();
            }
        });
        this.setModal(true);
        this.setSize(new Dimension(640, 300));
        this.setTitle(in_chooser);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.mSelectedModel = new ChooserTableModel();
        TableSorter tableSorter = new TableSorter(this.mSelectedModel);
        this.mSelectedTable = new JTableEx(tableSorter);
        JScrollPane jScrollPane = new JScrollPane(this.mSelectedTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        tableSorter.addMouseListenerToHeaderInTable(this.mSelectedTable);
        JPanel jPanel = new JPanel();
        this.mAvailLabel = new JLabel(in_uichooser_value);
        jPanel.add((Component)this.mAvailLabel, "West");
        this.mAvailableText = new JTextField(20);
        jPanel.add((Component)this.mAvailableText, "East");
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                SwingChooserUserInput.this.updateButtonStates();
            }
        };
        this.mAvailableText.addCaretListener(caretListener);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingChooserUserInput.this.selectAvailable();
            }
        };
        this.mAvailableText.addActionListener(actionListener);
        ListSelectionModel listSelectionModel = this.mSelectedTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SwingChooserUserInput.this.updateButtonStates();
                }
            }
        };
        listSelectionModel.addListSelectionListener(listSelectionListener);
        this.mSelectedTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SwingChooserUserInput.this.removeSelected();
                }
            }
        });
        JLabel jLabel = new JLabel(in_selRemain + ": ");
        this.mMessageText = new JLabelPane();
        this.mMessageText.setBackground(container.getBackground());
        this.setMessageText(null);
        this.mPoolText = new JLabel(" ");
        this.mAddButton = new JButton(PropertyFactory.getString("in_add"));
        this.mAddButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_add"));
        this.mCloseButton = new JButton(PropertyFactory.getString("in_close"));
        this.mCloseButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
        this.mRemoveButton = new JButton(PropertyFactory.getString("in_remove"));
        this.mRemoveButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_remove"));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == SwingChooserUserInput.this.mAddButton) {
                    SwingChooserUserInput.this.selectAvailable();
                } else if (actionEvent.getSource() == SwingChooserUserInput.this.mRemoveButton) {
                    SwingChooserUserInput.this.removeSelected();
                } else if (actionEvent.getSource() == SwingChooserUserInput.this.mCloseButton) {
                    SwingChooserUserInput.this.close();
                }
            }
        };
        this.mAddButton.addActionListener(actionListener2);
        this.mRemoveButton.addActionListener(actionListener2);
        this.mCloseButton.addActionListener(actionListener2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        container.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mAddButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mRemoveButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mMessageText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        container.add((Component)this.mPoolText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mCloseButton, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.mCloseButton);
    }

    private void removeSelected() {
        this.setMessageText(null);
        if (this.mSelectedTable.getSelectedRowCount() == 0) {
            this.setMessageText(in_validItem);
            return;
        }
        if (this.mSelectedTable.getSelectedRowCount() > 1) {
            this.setMessageText(in_deselectOne);
            return;
        }
        int n = this.mSelectedTable.getSelectedRow();
        String string = this.mSelectedModel.getValueAt(n, 0).toString();
        this.setPool(this.getPool() + this.getAdjustment(string));
        this.mSelectedList.remove(n);
        this.updateSelectedTable();
        this.updateButtonStates();
    }

    private void selectAvailable() {
        int n;
        this.setMessageText(null);
        if (this.getPool() <= 0) {
            this.setMessageText(in_noRemain);
            return;
        }
        String string = this.mAvailableText.getText();
        if (this.mUniqueList.contains(string)) {
            this.setMessageText(in_selectPartA + " " + string.toString() + " " + in_selectPartB);
            return;
        }
        TableModel tableModel = this.mSelectedTable.getModel();
        int n2 = tableModel.getRowCount();
        for (n = 0; n < n2; ++n) {
            Object object = tableModel.getValueAt(n, 0);
            if (!string.equals(object) || this.mAllowDuplicates) continue;
            this.setMessageText(string + " " + in_alreadySelected);
            return;
        }
        n = this.getAdjustment(string);
        if (this.getPool() - n < 0 && !this.canGoNegative) {
            this.setMessageText(in_noRemain);
            return;
        }
        this.mSelectedList.add(string);
        this.updateSelectedTable();
        this.mAvailableText.setText("");
        this.setPool(this.getPool() - n);
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        String string;
        int n;
        String string2;
        String string3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.mPool > 0) {
            if (!this.mPoolFlag) {
                bl3 = true;
                string3 = in_closeChooserTip;
            } else {
                string3 = in_completeMess;
            }
            if (this.mAvailableText.getText().length() > 0) {
                String string4 = this.mAvailableText.getText();
                if (!this.mUniqueList.contains(string4)) {
                    bl = true;
                    string2 = in_pressToAdd + " " + string4;
                    int n2 = this.mSelectedTable.getRowCount();
                    for (n = 0; n < n2; ++n) {
                        Object object = this.mSelectedModel.getValueAt(n, 0);
                        if (!string4.equals(object) || this.mAllowDuplicates) continue;
                        bl = false;
                        string2 = string4 + " " + in_alreadySelected;
                    }
                } else {
                    string2 = in_selectPartA + " " + string4 + " " + in_selectPartB;
                }
            } else {
                string2 = in_noRemain;
                string3 = in_closeChooserTip;
                bl3 = true;
            }
        } else {
            string2 = in_noRemain;
            string3 = in_closeChooserTip;
            bl3 = true;
        }
        int n3 = this.mSelectedTable.getSelectedRowCount();
        if (n3 == 1) {
            n = this.mSelectedTable.getSelectedRow();
            if (n >= 0 && n < this.mSelectedTable.getRowCount()) {
                bl2 = true;
                string = in_pressToRemove + " " + this.mSelectedTable.getModel().getValueAt(n, 0) + ".";
            } else {
                string = in_validItem;
            }
        } else {
            string = n3 == 0 ? in_validItem : in_removeOne;
        }
        this.mAddButton.setEnabled(bl);
        this.mCloseButton.setEnabled(bl3);
        this.mRemoveButton.setEnabled(bl2);
        Utility.setDescription(this.mAddButton, string2);
        Utility.setDescription(this.mCloseButton, string3);
        Utility.setDescription(this.mRemoveButton, string);
    }

    private void updateSelectedTable() {
        if (this.mSelectedColumnNames == null) {
            this.setSelectedColumnNames(SELECTED_COLUMN_NAMES);
        }
        SwingChooserUserInput.updateTable(this.mSelectedTable, this.mSelectedModel, this.mSelectedList, this.mSelectedTerminator);
    }

    private static void updateTable(JTableEx jTableEx, ChooserTableModel chooserTableModel, List list, String string) {
        Object object;
        if (list.size() <= 0) {
            chooserTableModel.setData(null, string);
            return;
        }
        Object object2 = null;
        int n = jTableEx.getSelectedRow();
        if (n >= 0 && n < list.size()) {
            object2 = list.get(n);
        }
        ListSelectionModel listSelectionModel = jTableEx.getSelectionModel();
        listSelectionModel.clearSelection();
        Object[][] objectArray = new Object[list.size()][];
        int n2 = 0;
        for (Object e : list) {
            if (e instanceof String) {
                objectArray[n2++] = SwingChooserUserInput.parseString(e.toString());
                continue;
            }
            if (e instanceof Collection) {
                object = (Collection)e;
                int n3 = object.size();
                objectArray[n2] = new Object[n3];
                int n4 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    objectArray[n2][n4++] = iterator.next();
                }
                ++n2;
                continue;
            }
            objectArray[n2] = new Object[1];
            objectArray[n2++][0] = e;
        }
        chooserTableModel.setData(objectArray, string);
        if (object2 != null) {
            int n5 = chooserTableModel.getRowCount();
            for (int i = 0; i < n5; ++i) {
                object = chooserTableModel.getValueAt(i, 0);
                if (!object2.equals(object)) continue;
                listSelectionModel.setSelectionInterval(i, i);
                break;
            }
        }
    }

    private static String[] parseString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }
}

