/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pcgen.gui.utils.TableMap;
import pcgen.util.Logging;

public final class TableSorter
extends TableMap {
    static final long serialVersionUID = 3442230718911502935L;
    private int[] indexes = null;
    private boolean ascending = true;
    private boolean hasBeenWarned = false;
    private int sortingColumn = -1;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
    }

    public int getRowTranslated(int n) {
        if (n >= 0 && n < this.indexes.length) {
            return this.indexes[n];
        }
        return -1;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2);
    }

    public Object getValueAt(int n, int n2) {
        this.checkModel();
        if (n < 0 || n >= this.indexes.length) {
            Logging.errorPrint("Row " + n + " illegal.");
            return null;
        }
        return this.model.getValueAt(this.indexes[n], n2);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final TableSorter tableSorter = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    if (n3 == 0) {
                        if (n2 == TableSorter.this.sortingColumn) {
                            tableSorter.sortByColumn(n2, !TableSorter.this.ascending);
                        } else {
                            tableSorter.sortByColumn(n2, true);
                        }
                    } else {
                        tableSorter.sortByColumn(n2, false);
                    }
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        if (this.sortingColumn >= 0) {
            this.sortByColumn(this.sortingColumn, this.ascending);
        }
        super.tableChanged(tableModelEvent);
    }

    public int translateRow(int n) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void checkModel() {
        if (this.indexes.length != this.model.getRowCount() && !this.hasBeenWarned) {
            Logging.errorPrint("Sorter not informed of a change in model named: " + this.model.getClass().getName());
            Logging.errorPrint("Indexes Length = " + this.indexes.length + " Model Row Count = " + this.model.getRowCount());
            Logging.errorPrint("Fixing by reallocating the indexes.  Please report this as a bug.", new Throwable());
            this.reallocateIndexes();
            this.hasBeenWarned = true;
        }
    }

    private int compare(int n, int n2) {
        Object object;
        Class<?> clazz = this.model.getColumnClass(this.sortingColumn);
        int n3 = this.ascending ? -1 : 1;
        int n4 = this.ascending ? 1 : -1;
        Object object2 = this.getValueAt(n, this.sortingColumn);
        if (object2 == (object = this.getValueAt(n2, this.sortingColumn))) {
            return 0;
        }
        if (object2 == null) {
            return n3;
        }
        if (object == null) {
            return n4;
        }
        if (clazz == Integer.class) {
            int n5;
            int n6 = (Integer)object2;
            if (n6 < (n5 = ((Integer)object).intValue())) {
                return n3;
            }
            if (n6 > n5) {
                return n4;
            }
            return 0;
        }
        if (clazz.getSuperclass() == Number.class) {
            double d;
            double d2 = ((Number)object2).doubleValue();
            if (d2 < (d = ((Number)object).doubleValue())) {
                return n3;
            }
            if (d2 > d) {
                return n4;
            }
            return 0;
        }
        if (clazz == Date.class) {
            long l;
            long l2 = ((Date)object2).getTime();
            if (l2 < (l = ((Date)object).getTime())) {
                return n3;
            }
            if (l2 > l) {
                return n4;
            }
            return 0;
        }
        if (clazz == String.class) {
            String string = (String)object2;
            String string2 = (String)object;
            if (this.ascending) {
                return string.compareToIgnoreCase(string2);
            }
            return string2.compareToIgnoreCase(string);
        }
        if (clazz == Boolean.class) {
            boolean bl;
            boolean bl2 = (Boolean)object2;
            if (bl2 == (bl = ((Boolean)object).booleanValue())) {
                return 0;
            }
            if (bl2) {
                return n4;
            }
            return n3;
        }
        String string = object2.toString();
        String string3 = object.toString();
        if (this.ascending) {
            return string.compareToIgnoreCase(string3);
        }
        return string3.compareToIgnoreCase(string);
    }

    private void mergeSort(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 1) {
            int n4 = (n + n2) / 2;
            this.mergeSort(nArray, nArray2, n, n4);
            this.mergeSort(nArray, nArray2, n4, n2);
            int n5 = n;
            int n6 = n;
            int n7 = n4;
            while (n6 < n4 && n7 < n2) {
                if (this.compare(n6, n7) <= 0) {
                    nArray2[n5++] = nArray[n6++];
                    continue;
                }
                nArray2[n5++] = nArray[n7++];
            }
            if (n6 < n4) {
                int n8 = n4 - n6;
                System.arraycopy(nArray, n6, nArray, n2 - n8, n8);
                System.arraycopy(nArray2, n, nArray, n, n3 - n8);
            } else {
                int n9 = n2 - n7;
                System.arraycopy(nArray2, n, nArray, n, n3 - n9);
            }
        }
    }

    private void reallocateIndexes() {
        int n = this.model.getRowCount();
        if (this.indexes == null || n != this.indexes.length) {
            this.indexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.indexes[i] = i;
            }
        }
    }

    private void sort() {
        this.checkModel();
        int[] nArray = new int[this.indexes.length];
        this.mergeSort(this.indexes, nArray, 0, this.indexes.length);
    }

    private void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumn = n;
        this.sort();
        super.tableChanged(new TableModelEvent(this));
    }
}

