/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Constants;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.IOHandler;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.PCGVer0Parser;
import pcgen.io.PCGVer2Creator;
import pcgen.io.PCGVer2Parser;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.util.InputFactory;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCGIOHandler
extends IOHandler {
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private PlayerCharacter aPC;

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getMessages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.errors);
        arrayList.addAll(this.warnings);
        return arrayList;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    /*
     * WARNING - void declaration
     */
    public static void buildSALIST(String string, List<String> list, List<String> list2, PlayerCharacter playerCharacter) {
        String string2;
        String string3 = "";
        int n = string.indexOf(124, 7);
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(7, n);
            string3 = string.substring(n + 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        List<SpecialAbility> list3 = playerCharacter.getSpecialAbilityList();
        for (PCTemplate object : playerCharacter.getTemplateList()) {
            List<SpecialAbility> list4 = object.getSpecialAbilityList(playerCharacter.getTotalLevels(), playerCharacter.totalHitDice());
            if (list4 == null || list4.isEmpty()) continue;
            for (SpecialAbility specialAbility : list4) {
                if (list3.contains(specialAbility)) continue;
                list3.add(specialAbility);
            }
        }
        for (String string4 : arrayList) {
            for (SpecialAbility specialAbility : list3) {
                void var14_22;
                String string5 = specialAbility.getKeyName();
                if (!string5.startsWith(string2)) continue;
                String string6 = "";
                n = string5.indexOf(124);
                if (n >= 0) {
                    string6 = string5.substring(n + 1);
                    n = string5.indexOf(37);
                    if (n >= 0) {
                        String string7 = string5.substring(0, n).trim();
                    }
                }
                if (list.contains(var14_22)) continue;
                list.add((String)var14_22);
                n = string3.indexOf(37);
                if (n >= 0) {
                    string6 = string3.substring(0, n) + string6 + string3.substring(n + 1);
                }
                list2.add((String)var14_22 + "|" + string6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(PlayerCharacter playerCharacter, InputStream inputStream, boolean bl) {
        this.aPC = playerCharacter;
        this.warnings.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
                bl2 |= string.startsWith("PCGVERSION");
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Exception in PCGIOHandler::read", iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.read", iOException);
            }
        }
        playerCharacter.setImporting(true);
        boolean bl3 = SettingsHandler.isLoadCampaignsWithPC();
        if (!bl) {
            SettingsHandler.setLoadCampaignsWithPC(false);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        PCGParser pCGParser = bl2 ? new PCGVer2Parser(playerCharacter) : new PCGVer0Parser(playerCharacter);
        try {
            pCGParser.parsePCG(stringArray);
        }
        catch (PCGParseException pCGParseException) {
            this.errors.add(pCGParseException.getMessage() + Constants.s_LINE_SEP + "Method: " + pCGParseException.getMethod() + '\n' + "Line: " + pCGParseException.getLine());
        }
        this.warnings.addAll(pCGParser.getWarnings());
        playerCharacter.setImporting(false);
        SettingsHandler.setLoadCampaignsWithPC(bl3);
        try {
            this.sanityChecks(playerCharacter, pCGParser);
        }
        catch (NumberFormatException numberFormatException) {
            this.errors.add(numberFormatException.getMessage() + Constants.s_LINE_SEP + "Method: sanityChecks");
        }
        playerCharacter.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(PlayerCharacter playerCharacter, OutputStream outputStream) {
        this.aPC = playerCharacter;
        String string = new PCGVer2Creator(playerCharacter).createPCGString();
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            playerCharacter.setDirty(false);
        }
        catch (IOException iOException) {
            Logging.errorPrint("Exception in PCGIOHandler::write", iOException);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.write", iOException);
            }
        }
    }

    private void sanityChecks(PlayerCharacter playerCharacter, PCGParser pCGParser) {
        int n;
        int n2;
        boolean bl = false;
        this.aPC.setCalcEquipmentList();
        this.aPC.setCalcFollowerBonus(playerCharacter);
        this.aPC.calcActiveBonuses();
        int n3 = this.aPC.hitPoints();
        Race race = this.aPC.getRace();
        if (race.hitDice(this.aPC) != 0) {
            int n4;
            n2 = race.getHitDiceSize(this.aPC);
            if (race.getHitPointMapSize() < 1) {
                for (n4 = 0; n4 <= race.hitDice(this.aPC); ++n4) {
                    int n5 = RollingMethods.roll(n2);
                    race.setHitPoint(n4, n5);
                }
                this.warnings.add("Character was saved with \"Use Default Monsters\" off. Random hit points added for race hit dice.");
                bl = true;
            }
            for (n4 = 0; n4 <= race.hitDice(this.aPC); ++n4) {
                n = race.getHitPoint(n4);
                if (n <= n2) continue;
                race.setHitPoint(n4, n2);
                bl = true;
            }
        }
        if (pCGParser.isCalcFeatPoolAfterLoad()) {
            double d = pCGParser.getBaseFeatPool();
            double d2 = this.aPC.getRawFeats(true);
            this.aPC.setFeats(d -= d2);
        }
        for (Ability ability : this.aPC.getRealAbilitiesList(AbilityCategory.FEAT)) {
            Object object;
            if (ability.getChoiceString().startsWith("SALIST|")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                object = new ArrayList<String>();
                PCGIOHandler.buildSALIST(ability.getChoiceString(), arrayList, object, playerCharacter);
                block5: for (int i = 0; i < ability.getAssociatedCount(); ++i) {
                    String string = ability.getAssociated(i);
                    String string2 = string + "|";
                    boolean bl2 = true;
                    while (true) {
                        Object object2;
                        String string3;
                        int n6;
                        for (n6 = 0; n6 < object.size(); ++n6) {
                            string3 = (String)object.get(n6);
                            if (!string3.startsWith(string2)) continue;
                            object2 = string3.substring(string3.indexOf(124) + 1);
                            ability.addBonusList((String)object2);
                            break;
                        }
                        if (n6 < object.size() || !bl2) continue block5;
                        bl2 = false;
                        if (object.size() == 1) {
                            string = (String)object.get(0);
                            string = string.substring(0, string.indexOf(124));
                        } else {
                            while (true) {
                                string3 = ability.getDisplayName() + " has been modified and PCGen is unable to " + "determine your previous selection(s)." + Constants.s_LINE_SEP + Constants.s_LINE_SEP + "This box will pop up once for each time you " + "have taken the feat.";
                                object2 = InputFactory.getInputInstance();
                                Object object3 = object2.showInputDialog(null, string3, "PCGen", MessageType.INFORMATION, arrayList.toArray(), arrayList.get(0));
                                if (object3 != null) {
                                    string = (String)object3;
                                    break;
                                }
                                ShowMessageDelegate.showMessageDialog("You MUST make a selection", "PCGen", MessageType.INFORMATION);
                            }
                        }
                        ability.setAssociated(i, string);
                    }
                }
            } else if (ability.getChoiceString().startsWith("NONCLASSSKILLLIST|")) {
                for (int i = 0; i < ability.getAssociatedCount(); ++i) {
                    object = ability.getAssociated(i);
                    try {
                        PObjectLoader.parseTag(ability, "CSKILL:" + (String)object);
                        continue;
                    }
                    catch (PersistenceLayerException persistenceLayerException) {
                        persistenceLayerException.printStackTrace();
                    }
                }
            }
            if (!ability.isMultiples() || ability.getAssociatedCount() != 0) continue;
            ability.addAssociated("PLEASE MAKE APPROPRIATE SELECTION");
            this.warnings.add("Multiple selection feat found with no selections (" + ability.getDisplayName() + "). Correct on Feat tab.");
        }
        if (this.aPC.getClassList() != null) {
            for (PCClass pCClass : this.aPC.getClassList()) {
                if (pCClass.getLevel() < 1) continue;
                for (int i = 0; i <= pCClass.getLevel(); ++i) {
                    int n7 = pCClass.getLevelHitDie(playerCharacter, i + 1);
                    n = pCClass.getHitPoint(i);
                    if (n <= (n2 = n7 + (int)pCClass.getBonusTo("HD", "MAX", i + 1, this.aPC))) continue;
                    pCClass.setHitPoint(i, n2);
                    bl = true;
                }
            }
        }
        if (bl) {
            String string = "Fixed illegal value in hit points. Current character hit points: " + this.aPC.hitPoints() + " not " + n3;
            this.warnings.add(string);
        }
        for (PCClass pCClass : this.aPC.getClassList()) {
            pCClass.setLevel(pCClass.getLevel(), playerCharacter);
        }
        this.aPC.adjustMoveRates();
        this.aPC.calcActiveBonuses();
        this.aPC.setDirty(false);
    }
}

