/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;
import pcgen.util.enumeration.Load;

public class TotalToken
extends Token {
    public static final String TOKENNAME = "TOTAL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        if ("TOTAL.WEIGHT".equals(string)) {
            string2 = TotalToken.getWeightToken(playerCharacter);
        } else if ("TOTAL.VALUE".equals(string)) {
            string2 = TotalToken.getValueToken(playerCharacter);
        } else if ("TOTAL.CAPACITY".equals(string)) {
            string2 = TotalToken.getCapacityToken(playerCharacter);
        } else if ("TOTAL.LOAD".equals(string)) {
            string2 = TotalToken.getLoadToken(playerCharacter);
        }
        return string2;
    }

    public static String getCapacityToken(PlayerCharacter playerCharacter) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(Globals.maxLoadForLoadScore(playerCharacter.getVariableValue("LOADSCORE", "").intValue(), playerCharacter).doubleValue());
    }

    public static String getLoadToken(PlayerCharacter playerCharacter) {
        Load load = Globals.loadTypeForLoadScore(playerCharacter.getVariableValue("LOADSCORE", "").intValue(), playerCharacter.totalWeight(), playerCharacter);
        switch (load) {
            case LIGHT: {
                return CoreUtility.capitalizeFirstLetter(Load.LIGHT.toString());
            }
            case MEDIUM: {
                return CoreUtility.capitalizeFirstLetter(Load.MEDIUM.toString());
            }
            case HEAVY: {
                return CoreUtility.capitalizeFirstLetter(Load.HEAVY.toString());
            }
            case OVERLOAD: {
                return CoreUtility.capitalizeFirstLetter(Load.OVERLOAD.toString());
            }
        }
        Logging.errorPrint("Unknown load constant detected in TokenTotal.getLoadToken, the constant was " + (Object)((Object)load) + ".");
        return "Unknown";
    }

    public static String getValueToken(PlayerCharacter playerCharacter) {
        return BigDecimalHelper.trimZeros(playerCharacter.totalValue()) + " " + Globals.getCurrencyDisplay();
    }

    public static String getWeightToken(PlayerCharacter playerCharacter) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(playerCharacter.totalWeight().doubleValue()) + Globals.getGameModeUnitSet().getWeightUnit();
    }
}

