/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.AttackType;

public class WeaponToken
extends Token {
    public static final String TOKENNAME = "WEAPON";
    public static final int WPTYPEBONUS_PC = 0;
    public static final int WPTYPEBONUS_EQ = 1;
    public static final int WPTYPEBONUS_FEAT = 2;
    public static final int WPTYPEBONUS_TEMPLATE = 3;
    public static final int DAMAGEMODE_NORMAL = 0;
    public static final int DAMAGEMODE_BASIC = 1;
    public static final int DAMAGEMODE_OFFHAND = 2;
    public static final int DAMAGEMODE_TWOHANDS = 3;
    public static final int DAMAGEMODE_DOUBLE = 4;
    public static final int HITMODE_TOTALHIT = 0;
    public static final int HITMODE_BASEHIT = 1;
    public static final int HITMODE_TWPHITH = 2;
    public static final int HITMODE_TWPHITL = 3;
    public static final int HITMODE_TWOHIT = 4;
    public static final int HITMODE_TWFOHH = 4;
    public static final int HITMODE_TWFOHL = 5;
    public static final int HITMODE_OHHIT = 6;
    public static final int HITMODE_THHIT = 7;

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("MERGENONE")) {
            n = 1;
            string2 = stringTokenizer.nextToken();
        } else if (string2.equals("MERGELOC")) {
            n = 2;
            string2 = stringTokenizer.nextToken();
        } else if (string2.equals("MERGEALL")) {
            n = 0;
            string2 = stringTokenizer.nextToken();
        }
        List<Equipment> list = playerCharacter.getExpandedWeapons(n);
        if (string2.equals("ALL")) {
            string2 = stringTokenizer.nextToken();
        } else if (string2.equals("EQUIPPED")) {
            Iterator<Equipment> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isEquipped()) continue;
                iterator.remove();
            }
            string2 = stringTokenizer.nextToken();
        } else if (string2.equals("NOT_EQUIPPED")) {
            Iterator<Equipment> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isEquipped()) continue;
                iterator.remove();
            }
            string2 = stringTokenizer.nextToken();
        } else if (string2.equals("CARRIED")) {
            Iterator<Equipment> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().numberCarried().intValue() != 0) continue;
                iterator.remove();
            }
            string2 = stringTokenizer.nextToken();
        } else if (string2.equals("NOT_CARRIED")) {
            Iterator<Equipment> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().numberCarried().intValue() <= 0) continue;
                iterator.remove();
            }
            string2 = stringTokenizer.nextToken();
        }
        n2 = WeaponToken.getIntToken(string2, 0);
        if (n2 < list.size()) {
            Equipment equipment = list.get(n2);
            if (n2 == list.size() - 1 && exportHandler != null && exportHandler.getExistsOnly()) {
                exportHandler.setNoMoreItems(true);
            }
            return this.getWeaponToken(playerCharacter, equipment, stringTokenizer);
        }
        if (exportHandler != null && exportHandler.getExistsOnly()) {
            exportHandler.setNoMoreItems(true);
            if (exportHandler.getCheckBefore()) {
                exportHandler.setCanWrite(false);
            }
        }
        return "";
    }

    public String getWeaponToken(PlayerCharacter playerCharacter, Equipment equipment, StringTokenizer stringTokenizer) {
        String string = "";
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (string.equals("RANGELIST")) {
            n = WeaponToken.getIntToken(stringTokenizer, -1);
            string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "RANGELIST";
        }
        if (string.equals("CONTENTS")) {
            if (stringTokenizer.hasMoreTokens()) {
                n2 = WeaponToken.getIntToken(stringTokenizer, -1);
                string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "CONTENTS";
            } else {
                string = "CONTENTSCOUNT";
            }
        }
        if (string.equals("AMMUNITION")) {
            if (stringTokenizer.hasMoreTokens()) {
                n3 = WeaponToken.getIntToken(stringTokenizer, -1);
                string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "AMMUNITION";
            } else {
                string = "AMMUNITIONCOUNT";
            }
        }
        if (string.equals("NAME")) {
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens() && "NOSTAR".equals(stringTokenizer.nextToken())) {
                bl = false;
            }
            return WeaponToken.getNameToken(equipment, playerCharacter, bl);
        }
        if (string.equals("OUTPUTNAME")) {
            return WeaponToken.getOutputNameToken(equipment, playerCharacter);
        }
        if (string.equals("LONGNAME")) {
            return WeaponToken.getLongNameToken(equipment);
        }
        if (string.equals("ATTACKS")) {
            return WeaponToken.getAttacksToken(playerCharacter, equipment) + "";
        }
        if (string.equals("AMMUNITIONCOUNT")) {
            return WeaponToken.getAmmunitionCountToken(playerCharacter, equipment) + "";
        }
        if (string.equals("AMMUNITION")) {
            return WeaponToken.getAmmunitionToken(playerCharacter, equipment, n3);
        }
        if (string.equals("CONTENTSCOUNT")) {
            return WeaponToken.getContentsCountToken(equipment) + "";
        }
        if (string.equals("CONTENTS")) {
            return WeaponToken.getContentsToken(equipment, n2);
        }
        if (string.equals("NUMATTACKS")) {
            return WeaponToken.getNumAttacksToken(playerCharacter, equipment) + "";
        }
        if (string.equals("HEFT")) {
            return WeaponToken.getHeft(playerCharacter, equipment);
        }
        if (string.equals("ISTYPE")) {
            if (stringTokenizer.hasMoreTokens()) {
                return WeaponToken.getIsTypeToken(equipment, stringTokenizer.nextToken());
            }
            return "";
        }
        if (string.equals("CRIT")) {
            return WeaponToken.getCritToken(playerCharacter, equipment);
        }
        if (string.equals("MULT")) {
            return WeaponToken.getMultToken(playerCharacter, equipment);
        }
        if (string.equals("RANGELIST")) {
            return WeaponToken.getRangeListToken(equipment, n, playerCharacter);
        }
        if (string.equals("RANGE")) {
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens() && "NOUNITS".equals(stringTokenizer.nextToken())) {
                bl = false;
            }
            return WeaponToken.getRangeToken(equipment, playerCharacter, bl);
        }
        if (string.equals("SIZEMOD")) {
            return Delta.toString(WeaponToken.getSizeModToken(playerCharacter));
        }
        if (string.equals("TYPE")) {
            return WeaponToken.getTypeToken(equipment);
        }
        if (string.equals("HIT") || string.equals("TOTALHIT")) {
            int n4 = WeaponToken.getIntToken(stringTokenizer, -1);
            return WeaponToken.getTotalHitToken(playerCharacter, equipment, n, n2, n3, n4);
        }
        if (string.equals("BASEHIT")) {
            int n5 = WeaponToken.getIntToken(stringTokenizer, -1);
            return WeaponToken.getBaseHitToken(playerCharacter, equipment, n, n2, n3, n5);
        }
        if (string.equals("TWPHITH")) {
            int n6 = WeaponToken.getIntToken(stringTokenizer, -1);
            return WeaponToken.getTwpHitHToken(playerCharacter, equipment, n, n2, n3, n6);
        }
        if (string.equals("TWPHITL")) {
            int n7 = WeaponToken.getIntToken(stringTokenizer, -1);
            return WeaponToken.getTwpHitLToken(playerCharacter, equipment, n, n2, n3, n7);
        }
        if (string.equals("TWOHIT")) {
            int n8 = WeaponToken.getIntToken(stringTokenizer, -1);
            return WeaponToken.getTwoHitToken(playerCharacter, equipment, n, n2, n3, n8);
        }
        if (string.equals("OHHIT")) {
            int n9 = WeaponToken.getIntToken(stringTokenizer, -1);
            return WeaponToken.getOHHitToken(playerCharacter, equipment, n, n2, n3, n9);
        }
        if (string.equals("THHIT")) {
            int n10 = WeaponToken.getIntToken(stringTokenizer, -1);
            return WeaponToken.getTHHitToken(playerCharacter, equipment, n, n2, n3, n10);
        }
        if (string.equals("CATEGORY")) {
            return WeaponToken.getCategoryToken(equipment);
        }
        if (string.equals("HAND")) {
            return WeaponToken.getHandToken(equipment);
        }
        if (string.equals("MAGICDAMAGE")) {
            return Delta.toString(WeaponToken.getMagicDamageToken(playerCharacter, equipment));
        }
        if (string.equals("MAGICHIT")) {
            return Delta.toString(WeaponToken.getMagicHitToken(playerCharacter, equipment));
        }
        if (string.equals("MISC")) {
            return Delta.toString(WeaponToken.getMiscToken(playerCharacter, equipment));
        }
        if (string.equals("FEATDAMAGE")) {
            Delta.toString(WeaponToken.getFeatDamageToken(playerCharacter, equipment));
        } else if (string.equals("FEATHIT")) {
            Delta.toString(WeaponToken.getFeatHitToken(playerCharacter, equipment));
        } else if (string.equals("TEMPLATEDAMAGE")) {
            Delta.toString(WeaponToken.getTemplateDamageToken(playerCharacter, equipment));
        } else if (string.equals("TEMPLATEHIT")) {
            Delta.toString(WeaponToken.getTemplateHitToken(playerCharacter, equipment));
        } else {
            if (string.equals("DAMAGE")) {
                return WeaponToken.getDamageToken(playerCharacter, equipment, n, n2, n3, false, false);
            }
            if (string.equals("BASEDAMAGE")) {
                return WeaponToken.getDamageToken(playerCharacter, equipment, n, n2, n3, false, true);
            }
            if (string.equals("BASICDAMAGE")) {
                return WeaponToken.getBasicDamageToken(playerCharacter, equipment, n, n2, n3, false);
            }
            if (string.equals("THDAMAGE")) {
                return WeaponToken.getTHDamageToken(playerCharacter, equipment, n, n2, n3, false);
            }
            if (string.equals("OHDAMAGE")) {
                return WeaponToken.getOHDamageToken(playerCharacter, equipment, n, n2, n3, false);
            }
            if (string.equals("DAMAGEBONUS") || string.equals("BONUSDAMAGE")) {
                return WeaponToken.getDamageToken(playerCharacter, equipment, n, n2, n3, true, false);
            }
            if (string.equals("BASEDAMAGEBONUS")) {
                return WeaponToken.getDamageToken(playerCharacter, equipment, n, n2, n3, true, true);
            }
            if (string.equals("THDAMAGEBONUS")) {
                return WeaponToken.getTHDamageToken(playerCharacter, equipment, n, n2, n3, true);
            }
            if (string.equals("OHDAMAGEBONUS")) {
                return WeaponToken.getOHDamageToken(playerCharacter, equipment, n, n2, n3, true);
            }
            if (string.equals("SIZE")) {
                return WeaponToken.getSizeToken(equipment);
            }
            if (string.equals("SPROP")) {
                return WeaponToken.getSpropToken(playerCharacter, equipment, n2, n3);
            }
            if (string.equals("REACH")) {
                return WeaponToken.getReachToken(playerCharacter, equipment) + "";
            }
            if (string.equals("WT")) {
                return WeaponToken.getWTToken(playerCharacter, equipment);
            }
            if (string.equals("RATEOFFIRE")) {
                return WeaponToken.getRateOfFireToken(equipment);
            }
            if (string.equals("ISLIGHT")) {
                return WeaponToken.getIsLightToken(playerCharacter, equipment);
            }
        }
        return "";
    }

    public static String getIsLightToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.isWeaponLightForPC(playerCharacter) ? "TRUE" : "FALSE";
    }

    public static String getNameToken(Equipment equipment, PlayerCharacter playerCharacter, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (equipment.isEquipped() && bl) {
            stringBuffer.append("*");
        }
        stringBuffer.append(equipment.parseOutputName(equipment.getOutputName(), playerCharacter));
        stringBuffer.append(equipment.getAppliedName());
        return stringBuffer.toString();
    }

    public static String getOutputNameToken(Equipment equipment, PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (equipment.isEquipped()) {
            stringBuffer.append("*");
        }
        stringBuffer.append(equipment.parseOutputName(equipment.getOutputName(), playerCharacter));
        stringBuffer.append(equipment.getAppliedName());
        return stringBuffer.toString();
    }

    public static String getLongNameToken(Equipment equipment) {
        StringBuffer stringBuffer = new StringBuffer();
        if (equipment.isEquipped()) {
            stringBuffer.append("*");
        }
        stringBuffer.append(equipment.longName());
        stringBuffer.append(equipment.getAppliedName());
        return stringBuffer.toString();
    }

    public static int getAttacksToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return (int)equipment.bonusTo(playerCharacter, TOKENNAME, "ATTACKS", true);
    }

    public static int getAmmunitionCountToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = 0;
        String string = equipment.getContainerCapacityString();
        block0: for (Equipment equipment2 : playerCharacter.getEquipmentListInOutputOrder()) {
            for (String string2 : equipment2.typeList()) {
                if (string.indexOf(string2) < 0) continue;
                ++n;
                continue block0;
            }
        }
        return n;
    }

    public static String getAmmunitionToken(PlayerCharacter playerCharacter, Equipment equipment, int n) {
        Equipment equipment2 = WeaponToken.getAmmoUser(playerCharacter, equipment, n);
        if (equipment2 != null) {
            return equipment2.getName();
        }
        return "";
    }

    public static int getContentsCountToken(Equipment equipment) {
        return equipment.getContainedEquipmentCount();
    }

    public static String getContentsToken(Equipment equipment, int n) {
        if (n > -1 && n < equipment.getContainedEquipmentCount()) {
            return equipment.getContainedEquipment(n).getName();
        }
        return "";
    }

    public static String getHeft(PlayerCharacter playerCharacter, Equipment equipment) {
        String string = "";
        string = playerCharacter.sizeInt() > Globals.sizeInt(equipment.getSize()) ? "LIGHT" : (playerCharacter.sizeInt() == Globals.sizeInt(equipment.getSize()) ? "MEDIUM" : "HEAVY");
        return string;
    }

    public static String getIsTypeToken(Equipment equipment, String string) {
        return WeaponToken.isTypeToken(equipment, string) ? "TRUE" : "FALSE";
    }

    public static boolean isTypeToken(Equipment equipment, String string) {
        return equipment.isType(string);
    }

    public static String getMultToken(PlayerCharacter playerCharacter, Equipment equipment) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = equipment.isDouble() && equipment.getLocation() == 4;
        int n = (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "CRITMULTADD") + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "CRITMULTADD", 0);
        int n2 = equipment.getCritMultiplier();
        stringBuffer.append(n2 + n + "");
        int n3 = equipment.getAltCritMultiplier();
        if (bl && n3 > 0) {
            stringBuffer.append("/" + (n3 + n));
        }
        return stringBuffer.toString();
    }

    public static String getRangeListToken(Equipment equipment, int n, PlayerCharacter playerCharacter) {
        List<String> list = equipment.getRangeList(true, playerCharacter);
        if (n < list.size()) {
            return Globals.getGameModeUnitSet().displayDistanceInUnitSet(Integer.parseInt(list.get(n))) + Globals.getGameModeUnitSet().getDistanceUnit();
        }
        return "";
    }

    public static String getRangeToken(Equipment equipment, PlayerCharacter playerCharacter, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Globals.getGameModeUnitSet().displayDistanceInUnitSet(equipment.getRange(playerCharacter).intValue()));
        if (bl) {
            stringBuffer.append(Globals.getGameModeUnitSet().getDistanceUnit());
        }
        return stringBuffer.toString();
    }

    public static int getSizeModToken(PlayerCharacter playerCharacter) {
        return (int)playerCharacter.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
    }

    public static String getCategoryToken(Equipment equipment) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WeaponToken.weaponCategories(equipment));
        stringBuffer.append("-");
        if (equipment.isNatural()) {
            stringBuffer.append("Natural");
        }
        if (WeaponToken.appendSeperator(equipment)) {
            stringBuffer.append(",");
        }
        if (equipment.isType("Both")) {
            if (equipment.isMelee()) {
                stringBuffer.append("Both (Melee)");
            } else if (equipment.isRanged()) {
                stringBuffer.append("Both (Ranged)");
            }
        } else if (equipment.isMelee()) {
            stringBuffer.append("Melee");
        } else if (equipment.isRanged()) {
            stringBuffer.append("Ranged");
        }
        if (WeaponToken.isNonStandard(equipment)) {
            stringBuffer.append("Non-Standard");
        }
        return stringBuffer.toString();
    }

    public static String getTypeToken(Equipment equipment) {
        String string = WeaponToken.weaponTypes(equipment, true);
        if (equipment.isDouble()) {
            string = string + '/' + WeaponToken.weaponTypes(equipment, false);
        }
        return string;
    }

    public static String getHandToken(Equipment equipment) {
        String string = Equipment.getLocationName(equipment.getLocation());
        return string.replaceAll(".*\\(", "").replaceAll("\\(.*", "").replaceAll("\\).*", "");
    }

    public static int getMagicDamageToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = equipment.getBonusToDamage(playerCharacter, true) + (int)equipment.bonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "DAMAGE", playerCharacter, playerCharacter) + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "DAMAGE", 1);
        return n;
    }

    public static int getMagicHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = equipment.getBonusToHit(playerCharacter, true) + (int)equipment.bonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "TOHIT", playerCharacter, playerCharacter) + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "TOHIT", 1);
        return n;
    }

    public static int getMiscToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "TOHIT") + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "TOHIT", 0) - (int)playerCharacter.getStatBonusTo("TOHIT", "TYPE.MELEE") - (int)playerCharacter.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        return n;
    }

    public static int getFeatDamageToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = (int)playerCharacter.getFeatBonusTo(TOKENNAME, "DAMAGE", true) - (int)playerCharacter.getFeatBonusTo(TOKENNAME, "DAMAGE-SHORTRANGE", true) + (int)playerCharacter.getFeatBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "DAMAGE", true) + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "DAMAGE", 2);
        return n;
    }

    public static int getFeatHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = (int)playerCharacter.getFeatBonusTo(TOKENNAME, "TOHIT", true) + (int)playerCharacter.getFeatBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "TOHIT", true) + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "TOHIT", 2);
        return n;
    }

    public static int getTemplateDamageToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = (int)playerCharacter.getTemplateBonusTo(TOKENNAME, "DAMAGE", true) + (int)playerCharacter.getTemplateBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "DAMAGE", true) + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "DAMAGE", 3);
        return n;
    }

    public static int getTemplateHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = (int)playerCharacter.getTemplateBonusTo(TOKENNAME, "TOHIT", true) + (int)playerCharacter.getTemplateBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "TOHIT", true) + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "TOHIT", 3);
        return n;
    }

    public static String getSizeToken(Equipment equipment) {
        return equipment.getSize();
    }

    public static String getSpropToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getSpropToken(playerCharacter, equipment, -1, -1);
    }

    public static String getSpropToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2) {
        String string = equipment.getSpecialProperties(playerCharacter);
        if (n > -1) {
            string = "";
            if (n < equipment.getContainedEquipmentCount() && !"".equals(equipment.getContainedEquipment(n).getSpecialProperties(playerCharacter))) {
                string = equipment.getContainedEquipment(n).getSpecialProperties(playerCharacter);
            }
        }
        int n3 = 0;
        Equipment equipment2 = null;
        if (n2 > -1) {
            String string2 = equipment.getContainerCapacityString();
            for (Equipment equipment3 : playerCharacter.getEquipmentListInOutputOrder()) {
                string = "";
                for (String string3 : equipment3.typeList()) {
                    if (string2.indexOf(string3) < 0) continue;
                    ++n3;
                    equipment2 = equipment3;
                    break;
                }
                if (n3 != n2 + 1) continue;
                break;
            }
        }
        if (equipment2 != null && n3 > 0 && !"".equals(equipment2.getSpecialProperties(playerCharacter))) {
            string = equipment2.getSpecialProperties(playerCharacter);
        }
        if (string.startsWith(", ")) {
            string = string.substring(2);
        }
        return string;
    }

    public static int getReachToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getVariableValue(SettingsHandler.getGame().getWeaponReachFormula(), "", playerCharacter).intValue();
    }

    public static String getWTToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(equipment.getWeight(playerCharacter).doubleValue());
    }

    public static String getRateOfFireToken(Equipment equipment) {
        return equipment.getRateOfFire();
    }

    public static int getNumAttacksToken(PlayerCharacter playerCharacter, Equipment equipment) {
        StringTokenizer stringTokenizer;
        String string = WeaponToken.getMeleeAttackString(playerCharacter);
        String string2 = WeaponToken.getUnarmedAttackString(playerCharacter);
        String string3 = WeaponToken.getRangedAttackString(playerCharacter);
        String string4 = string;
        if (equipment.isRanged()) {
            string4 = string3;
        }
        if (equipment.isMonk()) {
            if (string2.length() > string.length()) {
                string4 = string2;
            } else if (string2.length() == string.length() && !string.equals(string2)) {
                stringTokenizer = new StringTokenizer(string, "+/", false);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "+/", false);
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer2.nextToken();
                if (Integer.parseInt(string6) >= Integer.parseInt(string5)) {
                    string4 = string2;
                }
            }
        }
        stringTokenizer = new StringTokenizer(string4, "/");
        int n = (int)equipment.bonusTo(playerCharacter, TOKENNAME, "ATTACKS", true);
        return stringTokenizer.countTokens() + n;
    }

    public static String getCritToken(PlayerCharacter playerCharacter, Equipment equipment) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = equipment.isDouble() && equipment.getLocation() == 4;
        int n = equipment.getRawCritRange();
        if (n == 0) {
            return "none";
        }
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        arrayList.addAll(BonusUtilities.getBonusFromList(playerCharacter.getActiveBonusList(), "WEAPONPROF=" + equipment.profKey(playerCharacter), "CRITRANGEDOUBLE"));
        int n2 = (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "CRITRANGEDOUBLE") + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "CRITRANGEDOUBLE", 0);
        int n3 = (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + equipment.profKey(playerCharacter), "CRITRANGEADD") + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "CRITRANGEADD", 0);
        int n4 = equipment.getCritRangeDouble(playerCharacter, true) + n2;
        int n5 = equipment.getRawCritRange() * (n4 + 1);
        n5 = 21 - (n5 + n3 + equipment.getCritRangeAdd(playerCharacter, true));
        stringBuffer.append(n5 + "");
        if (n5 < 20) {
            stringBuffer.append("-20");
        }
        if (bl && equipment.getAltCritRange(playerCharacter).length() > 0) {
            n4 = equipment.getCritRangeDouble(playerCharacter, false) + n2;
            int n6 = equipment.getRawCritRange(false) * (n4 + 1);
            if ((n6 = 21 - (n6 + n3 + equipment.getCritRangeAdd(playerCharacter, false))) != n5) {
                stringBuffer.append("/" + n6);
                if (n6 < 20) {
                    stringBuffer.append("-20");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getDamageToken(PlayerCharacter playerCharacter, Equipment equipment, boolean bl, boolean bl2) {
        return WeaponToken.getDamageToken(playerCharacter, equipment, -1, -1, -1, bl, bl2);
    }

    public static String getDamageToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, boolean bl, boolean bl2) {
        boolean bl3 = equipment.isDouble() && equipment.getLocation() == 4;
        boolean bl4 = equipment.isType("Head1") || equipment.isType("Head2");
        int n4 = 0;
        int n5 = 1;
        if (equipment.isNatural() && equipment.getLocation() == 2) {
            n4 = 2;
            n5 = 0;
        } else if (equipment.isUnarmed()) {
            n4 = 1;
        } else if (bl3 && !bl4) {
            n4 = 4;
            n5 = 1;
        } else if (bl4 && equipment.isWeaponTwoHanded(playerCharacter)) {
            n4 = 3;
            n5 = 2;
        } else if (playerCharacter.isSecondaryWeapon(equipment)) {
            n4 = 2;
            n5 = 0;
        } else if (playerCharacter.isPrimaryWeapon(equipment)) {
            if (equipment.getLocation() == 3) {
                n4 = 3;
                n5 = 2;
            } else {
                n4 = 1;
            }
        } else if (equipment.isWeaponTwoHanded(playerCharacter)) {
            n4 = 3;
            n5 = 2;
        } else {
            n4 = 1;
        }
        String string = equipment.profKey(playerCharacter);
        return WeaponToken.getDamage(playerCharacter, equipment, string, n, n2, n3, bl, n5, n4, bl2);
    }

    public static String getBasicDamageToken(PlayerCharacter playerCharacter, Equipment equipment, boolean bl) {
        return WeaponToken.getBasicDamageToken(playerCharacter, equipment, -1, -1, -1, bl);
    }

    public static String getBasicDamageToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, boolean bl) {
        int n4 = 1;
        int n5 = 1;
        return WeaponToken.getDamage(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, bl, n5, n4, false);
    }

    public static String getTHDamageToken(PlayerCharacter playerCharacter, Equipment equipment, boolean bl) {
        return WeaponToken.getTHDamageToken(playerCharacter, equipment, -1, -1, -1, bl);
    }

    public static String getTHDamageToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, boolean bl) {
        int n4 = 3;
        int n5 = 2;
        return WeaponToken.getDamage(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, bl, n5, n4, false);
    }

    public static String getOHDamageToken(PlayerCharacter playerCharacter, Equipment equipment, boolean bl) {
        return WeaponToken.getOHDamageToken(playerCharacter, equipment, -1, -1, -1, bl);
    }

    public static String getOHDamageToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, boolean bl) {
        int n4 = 2;
        int n5 = 0;
        return WeaponToken.getDamage(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, bl, n5, n4, false);
    }

    public static String getTotalHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getTotalHitToken(playerCharacter, equipment, -1, -1, -1, -1);
    }

    public static String getTotalHitToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, int n4) {
        boolean bl = equipment.isDouble() && equipment.getLocation() == 4;
        boolean bl2 = equipment.isType("Head1") || equipment.isType("Head2");
        int n5 = 1;
        int n6 = 0;
        if (equipment.isUnarmed()) {
            n6 = 1;
        } else if (bl && !bl2) {
            n6 = 4;
        } else if (!bl && bl2) {
            n6 = 7;
            n5 = 2;
        } else if (!playerCharacter.getPrimaryWeapons().isEmpty() && !playerCharacter.getSecondaryWeapons().isEmpty()) {
            if (playerCharacter.isPrimaryWeapon(equipment)) {
                Equipment equipment2 = playerCharacter.getSecondaryWeapons().get(0);
                n6 = equipment2 == null ? 3 : (equipment2.isWeaponLightForPC(playerCharacter) ? 3 : 2);
            } else if (playerCharacter.isSecondaryWeapon(equipment)) {
                n6 = equipment.isWeaponLightForPC(playerCharacter) ? 5 : 4;
            }
        } else if (playerCharacter.isSecondaryWeapon(equipment) && playerCharacter.getPrimaryWeapons().isEmpty()) {
            n6 = 6;
        } else if (playerCharacter.isPrimaryWeapon(equipment) && playerCharacter.getSecondaryWeapons().isEmpty()) {
            if (equipment.getLocation() == 3) {
                n6 = 7;
                n5 = 2;
            } else {
                n6 = 1;
            }
        } else if (equipment.isWeaponTwoHanded(playerCharacter)) {
            n6 = 7;
            n5 = 2;
        } else {
            n6 = 1;
        }
        return WeaponToken.getToHit(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, n5, n6, n4, true);
    }

    public static String getBaseHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getBaseHitToken(playerCharacter, equipment, -1, -1, -1, -1);
    }

    public static String getBaseHitToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = 1;
        return WeaponToken.getToHit(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, n5, n6, n4, false);
    }

    public static String getTwpHitHToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getTwpHitHToken(playerCharacter, equipment, -1, -1, -1, -1);
    }

    public static String getTwpHitHToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = 2;
        return WeaponToken.getToHit(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, n5, n6, n4, false);
    }

    public static String getTwpHitLToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getTwpHitLToken(playerCharacter, equipment, -1, -1, -1, -1);
    }

    public static String getTwpHitLToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = 3;
        return WeaponToken.getToHit(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, n5, n6, n4, false);
    }

    public static String getTwoHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getTwoHitToken(playerCharacter, equipment, -1, -1, -1, -1);
    }

    public static String getTwoHitToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = 4;
        return WeaponToken.getToHit(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, n5, n6, n4, false);
    }

    public static String getOHHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getOHHitToken(playerCharacter, equipment, -1, -1, -1, -1);
    }

    public static String getOHHitToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = 6;
        return WeaponToken.getToHit(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, n5, n6, n4, false);
    }

    public static String getTHHitToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return WeaponToken.getTHHitToken(playerCharacter, equipment, -1, -1, -1, -1);
    }

    public static String getTHHitToken(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, int n3, int n4) {
        int n5 = 2;
        int n6 = 7;
        return WeaponToken.getToHit(playerCharacter, equipment, equipment.profKey(playerCharacter), n, n2, n3, n5, n6, n4, false);
    }

    private static String getToHit(PlayerCharacter playerCharacter, Equipment equipment, String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Equipment equipment2;
        int n7;
        boolean bl2 = equipment.isDouble() && equipment.getLocation() == 4;
        boolean bl3 = equipment.isType("Head1") || equipment.isType("Head2");
        WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
        if (equipment.isMelee() && equipment.isWeaponTwoHanded(playerCharacter) && (!bl2 && !bl3 && n5 != 7 || bl3 && (n5 == 1 || n5 == 6 || n5 == 2))) {
            return SettingsHandler.getInvalidToHitText();
        }
        if (equipment.isMelee() && equipment.isWeaponOutsizedForPC(playerCharacter) && !equipment.isNatural()) {
            return SettingsHandler.getInvalidToHitText();
        }
        int n8 = (int)equipment.bonusTo(playerCharacter, TOKENNAME, "WEAPONBAB", true);
        n8 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "WEAPONBAB");
        String string2 = WeaponToken.getMeleeAttackString(playerCharacter, 0, n8 += WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "WEAPONBAB", 0));
        String string3 = WeaponToken.getRangedAttackString(playerCharacter, 0, n8);
        String string4 = WeaponToken.getUnarmedAttackString(playerCharacter, 0, n8);
        if (equipment.isMonk()) {
            if (string4.length() > string2.length()) {
                string2 = string4;
            } else if (string4.length() == string2.length() && !string2.equals(string4)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "+/", false);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "+/", false);
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer2.nextToken();
                if (Integer.parseInt(string6) >= Integer.parseInt(string5)) {
                    string2 = string4;
                }
            }
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (equipment.isNatural()) {
            if (equipment.getLocation() == 1) {
                n9 = 0;
            } else if (equipment.getLocation() == 2) {
                n9 = -5;
                n9 = (int)((double)n9 + playerCharacter.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY"));
            }
        } else {
            n9 = n5 == 0 && equipment.isRanged() || n5 == 1 || n5 == 7 ? 0 : (n5 == 2 || n5 == 3 ? -6 : (n5 == 6 ? -4 : -10));
            if (n5 == 3 || n5 == 5) {
                n9 += playerCharacter.getOffHandLightBonus();
            }
            if (n5 == 4 && (bl2 || bl3 || equipment.isWeaponLightForPC(playerCharacter))) {
                n9 += playerCharacter.getOffHandLightBonus();
            }
            if (n5 == 4 || n5 == 6 || n5 == 5 || n5 == 4) {
                n10 = (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY");
                if (equipment.isRanged()) {
                    n10 -= (int)playerCharacter.getBonusDueToType("COMBAT", "TOHIT-SECONDARY", "NOTRANGED");
                }
                if (n5 == 6) {
                    n10 -= (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY");
                }
            }
            if (n5 == 2 || n5 == 3) {
                n11 = (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY");
                if (equipment.isRanged()) {
                    n11 -= (int)playerCharacter.getBonusDueToType("COMBAT", "TOHIT-PRIMARY", "NOTRANGED");
                }
            }
        }
        if (equipment.getLocation() == 1 || equipment.getLocation() == 2 || equipment.getLocation() == 4) {
            // empty if block
        }
        if (n5 == 2 || n5 == 3) {
            n9 += n11;
        }
        if (n5 == 4 || n5 == 6 || n5 == 5 || n5 == 4) {
            n9 += n10;
        }
        for (String string7 : equipment.typeList()) {
            if (string7.equalsIgnoreCase("Finesseable") || n > -1 && string7.equals("MELEE") || n == -1 && equipment.isMelee() && (string7.equals("THROWN") || string7.equals("RANGED"))) continue;
            n9 += (int)playerCharacter.getTotalBonusTo("TOHIT", "TYPE." + string7);
            n9 += (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT." + string7);
        }
        if (n == -1 && equipment.isMelee() && equipment.isFinessable(playerCharacter)) {
            n9 += (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT.Finesseable");
        }
        if (weaponProf != null && equipment.isRanged()) {
            n9 -= (int)playerCharacter.getBonusDueToType("WEAPONPROF=" + string, "TOHIT", "NOTRANGED");
            n9 -= WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "TOHIT.NOTRANGED", 0);
        }
        if (!(equipment.isNatural() || weaponProf != null && playerCharacter.hasWeaponProfKeyed(string))) {
            n9 += playerCharacter.getNonProficiencyPenalty();
        }
        n9 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "TOHIT");
        n9 += WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "TOHIT", 0);
        if (n > -1) {
            int n12 = equipment.getRangeList(true, playerCharacter).size();
            int n13 = Integer.parseInt(equipment.getRangeList(true, playerCharacter).get(n));
            n7 = SettingsHandler.getGame().getShortRangeDistance();
            if (n < n12) {
                if (n13 <= n7) {
                    n9 += (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT-SHORTRANGE");
                    n9 += (int)playerCharacter.getTotalBonusTo("TOHIT", "SHORTRANGE");
                    n9 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "TOHIT-SHORTRANGE");
                    n9 += WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "TOHIT-SHORTRANGE", 0);
                    n9 += (int)equipment.bonusTo(playerCharacter, TOKENNAME, "TOHIT-SHORTRANGE", true);
                }
                int n14 = Integer.parseInt(equipment.getRange(playerCharacter).toString());
                int n15 = SettingsHandler.getGame().getRangePenalty();
                n9 += n15 * (int)Math.max(Math.ceil((float)n13 / (float)n14) - 1.0, 0.0);
            }
        }
        Equipment equipment3 = null;
        if (n2 > -1 && n2 < equipment.getContainedEquipmentCount()) {
            equipment3 = equipment.getContainedEquipment(n2);
            n9 += equipment3.getBonusToHit(playerCharacter, true);
        }
        if ((equipment2 = WeaponToken.getAmmoUser(playerCharacter, equipment, n3)) != null) {
            n9 += equipment2.getBonusToHit(playerCharacter, true);
        }
        n9 += (int)playerCharacter.getTotalBonusTo("TOHIT", "TOHIT");
        n9 += (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT");
        n9 += playerCharacter.modFromArmorOnWeaponRolls();
        n9 += equipment.getBonusToHit(playerCharacter, true);
        if (!Globals.checkRule("AMMOSTACKSWITHWEAPON")) {
            n9 += WeaponToken.calcAmmoEqCorrection("WEAPON.TOHIT.ENHANCEMENT", equipment, equipment3, equipment2);
        }
        n7 = (int)equipment.bonusTo(playerCharacter, TOKENNAME, "ATTACKS", true);
        n7 += (int)playerCharacter.getTotalBonusTo("COMBAT", "ATTACKS");
        String string8 = null;
        if (equipment.isMelee() && n == -1) {
            string8 = string2;
        } else if (equipment.isRanged()) {
            string8 = string3;
        } else {
            return "???";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string8, "/+");
        String string9 = Delta.toString(Integer.parseInt(stringTokenizer.nextToken()));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n7; i > 0; --i) {
            stringBuffer.append(string9).append("/");
        }
        if (equipment.isAttacksProgress() || equipment.bonusTo(playerCharacter, TOKENNAME, "ATTACKSPROGRESS", true) > 0.0) {
            stringBuffer.append(string8);
        } else {
            stringBuffer.append(string9);
        }
        StringTokenizer stringTokenizer3 = new StringTokenizer(stringBuffer.toString(), "/+");
        String string10 = "";
        boolean bl4 = false;
        for (int i = n6; stringTokenizer3.hasMoreTokens() && i >= 0; --i) {
            string10 = stringTokenizer3.nextToken();
            bl4 = true;
        }
        if (bl4) {
            stringTokenizer3 = new StringTokenizer(string10, "/+");
        }
        int n16 = 1 + (int)playerCharacter.getTotalBonusTo("COMBAT", "ATTACKS-SECONDARY");
        n16 += (int)playerCharacter.getTotalBonusTo("COMBAT", "SECONDARYATTACKS");
        if (playerCharacter.getPrimaryWeapons().isEmpty() && n5 == 0) {
            n16 = 100;
        }
        boolean bl5 = bl2 && equipment.getLocation() == 4 && n6 < 0;
        boolean bl6 = !bl2 && (n5 == 4 || playerCharacter.isSecondaryWeapon(equipment));
        int n17 = 0;
        int n18 = 0;
        StringBuffer stringBuffer2 = new StringBuffer(20);
        StringBuffer stringBuffer3 = new StringBuffer(20);
        StringBuffer stringBuffer4 = new StringBuffer();
        while (stringTokenizer3.hasMoreTokens()) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append('/');
            }
            n17 = Integer.parseInt(stringTokenizer3.nextToken()) + n9;
            stringBuffer2.append(Delta.toString(n17));
            if (bl5 && n18 < n16) {
                if (stringBuffer3.length() > 0) {
                    stringBuffer3.append('/');
                }
                stringBuffer3.append(Delta.toString(n17));
            }
            if (++n18 <= 100 && (!bl6 || n18 < n16)) continue;
        }
        stringBuffer4.append(stringBuffer2.toString());
        if (stringBuffer3.length() != 0 && (n5 == 0 || n5 == 4)) {
            stringBuffer4.append(";" + stringBuffer3);
        }
        return stringBuffer4.toString();
    }

    private static int calcAmmoEqCorrection(String string, Equipment equipment, Equipment equipment2, Equipment equipment3) {
        float f;
        float f2 = 0.0f;
        if (equipment == null) {
            return 0;
        }
        String string2 = equipment.getBonusMap().get(string);
        if (string2 != null) {
            f2 = Float.parseFloat(string2);
        }
        float f3 = f2;
        if (equipment2 != null && (string2 = equipment2.getBonusMap().get(string)) != null) {
            f = Float.parseFloat(string2);
            f3 += f;
            if (f > f2) {
                f2 = f;
            }
        }
        if (equipment3 != null && (string2 = equipment3.getBonusMap().get(string)) != null) {
            f = Float.parseFloat(string2);
            f3 += f;
            if (f > f2) {
                f2 = f;
            }
        }
        return (int)(f2 - f3);
    }

    private static String getDamage(PlayerCharacter playerCharacter, Equipment equipment, String string, int n, int n2, int n3, boolean bl, int n4, int n5, boolean bl2) {
        boolean bl3;
        boolean bl4 = equipment.isDouble() && equipment.getLocation() == 4;
        boolean bl5 = bl3 = equipment.isType("Head1") || equipment.isType("Head2");
        if (equipment.isMelee() && equipment.isWeaponTwoHanded(playerCharacter) && !bl4 && !bl3 && n5 != 0 && n5 != 3 && n5 != 4) {
            return SettingsHandler.getInvalidDmgText();
        }
        if (equipment.isMelee() && equipment.isWeaponOutsizedForPC(playerCharacter) && !equipment.isNatural()) {
            return SettingsHandler.getInvalidDmgText();
        }
        if (equipment.isWeaponLightForPC(playerCharacter) && n4 == 2) {
            n4 = 1;
        }
        String string2 = WeaponToken.getEqDamage(playerCharacter, equipment);
        int n6 = (int)playerCharacter.getStatBonusTo("COMBAT", "DAMAGE.MELEE");
        n6 += (int)playerCharacter.getStatBonusTo("DAMAGE", "TYPE.MELEE");
        double d = playerCharacter.getTotalBonusTo("COMBAT", "DAMAGEMULT:" + n4);
        d += playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "DAMAGEMULT:" + n4);
        d += equipment.bonusTo(TOKENNAME, "DAMAGEMULT:" + n4, playerCharacter, playerCharacter);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        string2 = WeaponToken.getMonkUnarmed(playerCharacter, equipment, string2);
        if (!bl2) {
            int n11;
            for (n11 = 0; n11 < string2.length(); ++n11) {
                if (string2.charAt(n11) != '+' && string2.charAt(n11) != '-') continue;
                n10 = Delta.decode(string2.substring(n11));
                break;
            }
            n9 = WeaponToken.getEqBonus(playerCharacter, equipment, n2, n3);
            n7 = WeaponToken.getGeneralBonus(playerCharacter, equipment, n, n6, d);
            n8 = WeaponToken.getWeaponProfBonus(playerCharacter, equipment, n);
            n10 += n7 + n8 + n9;
            string2 = string2.substring(0, n11);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!"0d0".equalsIgnoreCase(string2)) {
            if (!bl) {
                stringBuffer.append(string2);
            }
            if (n10 != 0 || bl) {
                stringBuffer.append(Delta.toString(n10));
            }
        } else {
            stringBuffer.append("0");
        }
        if (n5 == 4 && equipment.getLocation() == 4) {
            n4 = 0;
            d = playerCharacter.getTotalBonusTo("COMBAT", "DAMAGEMULT:" + n4);
            d += playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "DAMAGEMULT:" + n4);
            d += equipment.bonusTo(TOKENNAME, "DAMAGEMULT:" + n4, playerCharacter, playerCharacter);
            n10 -= n9;
            n9 = equipment.getBonusToDamage(playerCharacter, false);
            if (equipment.getAltDamage(playerCharacter).length() > 0) {
                n10 = 0;
                string2 = equipment.getAltDamage(playerCharacter);
                if (string2.lastIndexOf(45) >= 0) {
                    n10 = Integer.parseInt(string2.substring(string2.lastIndexOf(45)));
                    string2 = string2.substring(0, string2.lastIndexOf(45));
                } else if (string2.lastIndexOf(43) >= 0) {
                    n10 = Integer.parseInt(string2.substring(string2.lastIndexOf(43) + 1));
                    string2 = string2.substring(0, string2.lastIndexOf(43));
                }
            } else {
                n8 = 0;
                n7 = 0;
            }
            if (n6 > 0) {
                n7 -= n6;
                n7 = (int)((double)n7 + d * (double)n6);
            }
            n10 += n7 + n8 + n9;
            stringBuffer.append("/");
            if (!"0d0".equalsIgnoreCase(string2)) {
                if (bl) {
                    stringBuffer.append(string2);
                }
                if (n10 != 0 || bl) {
                    stringBuffer.append(Delta.toString(n10));
                }
            } else {
                stringBuffer.append("0");
            }
        }
        return stringBuffer.toString();
    }

    private static int getGeneralBonus(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2, double d) {
        int n3;
        int n4 = 0;
        for (String string : equipment.typeList()) {
            if (n > -1 && string.equals("MELEE") || n == -1 && (string.equals("THROWN") || string.equals("RANGED"))) continue;
            n4 += (int)playerCharacter.getTotalBonusTo("COMBAT", "DAMAGE." + string);
            n4 += (int)playerCharacter.getTotalBonusTo("DAMAGE", "TYPE." + string);
        }
        if (equipment.isFinessable(playerCharacter) && !equipment.isType("Finesseable")) {
            n4 += (int)playerCharacter.getTotalBonusTo("COMBAT", "DAMAGE.Finesseable");
        }
        if (equipment.isMelee() && n2 > 0) {
            n4 -= n2;
            n4 = (int)((double)n4 + d * (double)n2);
        } else if (equipment.isThrown()) {
            // empty if block
        }
        if (n > -1 && n < (n3 = equipment.getRangeList(true, playerCharacter).size()) && Integer.parseInt(equipment.getRangeList(true, playerCharacter).get(n)) <= SettingsHandler.getGame().getShortRangeDistance()) {
            n4 += (int)equipment.bonusTo(playerCharacter, TOKENNAME, "DAMAGE-SHORTRANGE", true);
            n4 += (int)playerCharacter.getTotalBonusTo("DAMAGE", "SHORTRANGE");
            n4 += (int)playerCharacter.getTotalBonusTo("COMBAT", "DAMAGE-SHORTRANGE");
        }
        return n4;
    }

    private static int getWeaponProfBonus(PlayerCharacter playerCharacter, Equipment equipment, int n) {
        int n2;
        String string = equipment.profKey(playerCharacter);
        int n3 = (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "DAMAGE") + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "DAMAGE", 0);
        if (equipment.isRanged()) {
            n3 -= (int)playerCharacter.getBonusDueToType("WEAPONPROF=" + string.toUpperCase(), "DAMAGE", "NOTRANGED") + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "DAMAGE.NOTRANGED", 0);
        }
        if (n > -1 && n < (n2 = equipment.getRangeList(true, playerCharacter).size()) && Integer.parseInt(equipment.getRangeList(true, playerCharacter).get(n)) <= SettingsHandler.getGame().getShortRangeDistance()) {
            n3 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "DAMAGE-SHORTRANGE") + WeaponToken.getWeaponProfTypeBonuses(playerCharacter, equipment, "DAMAGE-SHORTRANGE", 0);
        }
        return n3;
    }

    private static int getEqBonus(PlayerCharacter playerCharacter, Equipment equipment, int n, int n2) {
        Equipment equipment2;
        int n3 = equipment.getBonusToDamage(playerCharacter, true);
        Equipment equipment3 = null;
        if (n > -1 && n < equipment.getContainedEquipmentCount()) {
            equipment3 = equipment.getContainedEquipment(n);
            n3 += equipment3.getBonusToDamage(playerCharacter, true);
        }
        if ((equipment2 = WeaponToken.getAmmoUser(playerCharacter, equipment, n2)) != null) {
            n3 += equipment2.getBonusToDamage(playerCharacter, true);
        }
        if (!Globals.checkRule("AMMOSTACKSWITHWEAPON")) {
            n3 += WeaponToken.calcAmmoEqCorrection("WEAPON.DAMAGE.ENHANCEMENT", equipment, equipment3, equipment2);
        }
        return n3;
    }

    private static String getMonkUnarmed(PlayerCharacter playerCharacter, Equipment equipment, String string) {
        if (equipment.isMonk() && equipment.isUnarmed()) {
            SizeAdjustment sizeAdjustment;
            int n;
            int n2 = Globals.sizeInt(playerCharacter.getRace().getSize());
            boolean bl = n2 == (n = playerCharacter.sizeInt());
            String string2 = playerCharacter.getUnarmedDamageString(false, false, bl);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " d+-", false);
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " d+-", false);
            stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            if (Integer.parseInt(string3) < Integer.parseInt(string4)) {
                string = string2;
            }
            n += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=Unarmed Strike", "DAMAGESIZE");
            n += (int)playerCharacter.getTotalBonusTo("COMBAT", "DAMAGESIZE");
            if (!bl && (sizeAdjustment = SettingsHandler.getGame().getDefaultSizeAdjustment()) != null) {
                n2 = Globals.sizeInt(sizeAdjustment.getAbbreviation());
            }
            string = Globals.adjustDamage(string, n2, n);
        }
        return string;
    }

    private static String getEqDamage(PlayerCharacter playerCharacter, Equipment equipment) {
        String string = equipment.getDamage(playerCharacter);
        if (playerCharacter == null) {
            return string;
        }
        String string2 = equipment.profKey(playerCharacter);
        if (equipment.isNatural()) {
            int n = playerCharacter.racialSizeInt();
            int n2 = playerCharacter.sizeInt();
            n2 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string2, "DAMAGESIZE");
            string = Globals.adjustDamage(string, n, n2 += (int)playerCharacter.getTotalBonusTo("COMBAT", "DAMAGESIZE"));
        } else {
            int n;
            int n3 = n = equipment.sizeInt();
            n3 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string2, "DAMAGESIZE");
            string = Globals.adjustDamage(string, n, n3 += (int)playerCharacter.getTotalBonusTo("COMBAT", "DAMAGESIZE"));
        }
        return string;
    }

    private static Equipment getAmmoUser(PlayerCharacter playerCharacter, Equipment equipment, int n) {
        int n2 = 0;
        if (n < 0) {
            return null;
        }
        String string = equipment.getContainerCapacityString();
        for (Equipment equipment2 : playerCharacter.getEquipmentListInOutputOrder()) {
            for (String string2 : equipment2.typeList()) {
                if (string.indexOf(string2) < 0) continue;
                ++n2;
                break;
            }
            if (n2 != n + 1) continue;
            return equipment2;
        }
        return null;
    }

    private static int getWeaponProfTypeBonuses(PlayerCharacter playerCharacter, Equipment equipment, String string, int n) {
        int n2 = 0;
        boolean bl = equipment.isRanged() && equipment.isMelee();
        String string2 = equipment.profKey(playerCharacter);
        WeaponProf weaponProf = Globals.getWeaponProfKeyed(string2);
        if (weaponProf == null) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(weaponProf.getType(), ".");
        block6: while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (bl && "RANGED".equalsIgnoreCase(string3)) continue;
            switch (n) {
                case 0: {
                    n2 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=TYPE." + string3, string);
                    continue block6;
                }
                case 1: {
                    n2 += (int)equipment.bonusTo("WEAPONPROF=TYPE." + string3, string, playerCharacter, playerCharacter);
                    continue block6;
                }
                case 2: {
                    n2 += (int)playerCharacter.getFeatBonusTo("WEAPONPROF=TYPE." + string3, string, true);
                    continue block6;
                }
                case 3: {
                    n2 += (int)playerCharacter.getTemplateBonusTo("WEAPONPROF=TYPE." + string3, string, true);
                    continue block6;
                }
            }
            Logging.errorPrint("In getWeaponProfTypeBonuses there is an unhandled case in a switch (the value is " + n + ".");
        }
        return n2;
    }

    private static String weaponCategories(Equipment equipment) {
        StringBuffer stringBuffer = new StringBuffer(10);
        StringTokenizer stringTokenizer = new StringTokenizer(SettingsHandler.getGame().getWeaponCategories(), "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!equipment.isType(string, true)) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("Non-Standard");
        }
        return stringBuffer.toString();
    }

    private static String weaponTypes(Equipment equipment, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        StringTokenizer stringTokenizer = new StringTokenizer(SettingsHandler.getGame().getWeaponTypes(), "|", false);
        while (stringTokenizer.countTokens() >= 2) {
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            if (!equipment.isType(string, bl)) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String getRangedAttackString(PlayerCharacter playerCharacter) {
        return playerCharacter.getAttackString(AttackType.RANGED, 0, 0);
    }

    private static String getRangedAttackString(PlayerCharacter playerCharacter, int n, int n2) {
        return playerCharacter.getAttackString(AttackType.RANGED, n, n2);
    }

    private static String getMeleeAttackString(PlayerCharacter playerCharacter) {
        return playerCharacter.getAttackString(AttackType.MELEE, 0, 0);
    }

    private static String getMeleeAttackString(PlayerCharacter playerCharacter, int n, int n2) {
        return playerCharacter.getAttackString(AttackType.MELEE, n, n2);
    }

    private static String getUnarmedAttackString(PlayerCharacter playerCharacter) {
        return playerCharacter.getAttackString(AttackType.UNARMED, 0, 0);
    }

    private static String getUnarmedAttackString(PlayerCharacter playerCharacter, int n, int n2) {
        return playerCharacter.getAttackString(AttackType.UNARMED, n, n2);
    }

    private static boolean appendSeperator(Equipment equipment) {
        return equipment.isType("Natural") && (equipment.isType("Both") || equipment.isType("Melee") || equipment.isType("Ranged"));
    }

    private static boolean isNonStandard(Equipment equipment) {
        return !equipment.isType("Natural") && !equipment.isType("Both") && !equipment.isType("Melee") && !equipment.isType("Ranged");
    }
}

