/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.WeaponToken;
import pcgen.util.PropertyFactory;

public class WeaponhToken
extends WeaponToken {
    public static final String TOKEN_NAME = "WEAPONH";

    public String getTokenName() {
        return TOKEN_NAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        stringTokenizer.nextToken();
        Equipment equipment = WeaponhToken.getWeaponEquipment(playerCharacter);
        if (equipment != null) {
            return this.getWeaponToken(playerCharacter, equipment, stringTokenizer);
        }
        if (exportHandler != null && exportHandler.getExistsOnly()) {
            exportHandler.setNoMoreItems(true);
            if (exportHandler.getCheckBefore()) {
                exportHandler.setCanWrite(false);
            }
        }
        return "";
    }

    public static Equipment getWeaponEquipment(PlayerCharacter playerCharacter) {
        WeaponProf weaponProf = Globals.getWeaponProfKeyed("Unarmed Strike");
        if (weaponProf == null) {
            weaponProf = new WeaponProf();
            weaponProf.setName(PropertyFactory.getString("Equipment.UnarmedStrike"));
            weaponProf.setKeyName("Unarmed Strike");
            weaponProf.setTypeInfo("Simple");
            Globals.addWeaponProf(weaponProf);
        }
        Equipment equipment = new Equipment();
        equipment.setName(PropertyFactory.getString("Equipment.UnarmedStrike"));
        equipment.setKeyName("KEY_Unarmed Strike");
        equipment.setProfName("Unarmed Strike");
        equipment.setOutputName(PropertyFactory.getString("Equipment.UnarmedStrike"));
        equipment.setTypeInfo("Weapon.Melee.Simple.Unarmed.Subdual.Standard.Monk.Bludgeoning");
        equipment.setWield("Light");
        equipment.setCost("0", true);
        equipment.setWeight("0");
        equipment.setDamage("1d1");
        equipment.setCritMult(2);
        equipment.setCritRange("1");
        equipment.setModifiersAllowed(false);
        equipment.setModifiersRequired(false);
        equipment.setSize(playerCharacter.getSize(), true);
        return equipment;
    }
}

