/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.AbilityLstToken;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityLoader
extends LstObjectFileLoader<Ability> {
    @Override
    public Ability parseLine(Ability ability, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Ability ability2 = ability;
        if (ability2 == null) {
            ability2 = new Ability();
        } else if (ability2.getCategory() == null || ability2.getCategory().length() == 0) {
            ability2.setCategory("BROKENABILTYNOCATEGORYSET");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(AbilityLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            AbilityLstToken abilityLstToken = (AbilityLstToken)map.get(string3);
            if (n == 0) {
                ability2.setName(string2);
                ability2.setSourceCampaign(campaignSourceEntry.getCampaign());
                ability2.setSourceURI(campaignSourceEntry.getURI());
            } else if (abilityLstToken != null) {
                String string4 = string2.substring(n2 + 1);
                LstUtils.deprecationCheck(abilityLstToken, ability2, string4);
                if (!abilityLstToken.parse(ability2, string4)) {
                    Logging.errorPrintLocalised("Errors.AbilityLoader.ParsingError", ability2.getDisplayName(), campaignSourceEntry.getURI(), string2);
                }
            } else {
                if (PObjectLoader.parseTag(ability2, string2)) continue;
                if (string2.startsWith("ADD:")) {
                    ability2.setAddString(string2.substring(4));
                } else {
                    Logging.errorPrintLocalised("Errors.AbilityLoader.UnknownTag", string2, campaignSourceEntry.getURI());
                }
            }
            ++n;
        }
        this.completeObject(campaignSourceEntry, ability2);
        return null;
    }

    @Override
    protected Ability getObjectKeyed(String string) {
        String string2;
        String string3;
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\|");
        if (stringArray.length == 2 && stringArray[0].startsWith("CATEGORY=")) {
            string3 = stringArray[0].substring(9);
            string2 = stringArray[1];
        } else {
            string3 = "ALL";
            string2 = string;
        }
        return Globals.getAbilityKeyed(string3, string2);
    }

    @Override
    protected void performForget(Ability ability) {
        String string = ability.getCategory();
        String string2 = ability.getKeyName();
        Globals.removeAbilityKeyed(string, string2);
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.addAbility((Ability)pObject);
    }
}

