/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.SourceEntry;
import pcgen.io.PCGFile;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignLstToken;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public class CampaignLoader
extends LstLineFileLoader {
    private Campaign campaign = null;

    public void initRecursivePccFiles() throws PersistenceLayerException {
        ArrayList<Campaign> arrayList = new ArrayList<Campaign>(Globals.getCampaignList());
        for (Campaign campaign : arrayList) {
            this.initRecursivePccFiles(campaign);
        }
    }

    public void loadLstFile(URI uRI) throws PersistenceLayerException {
        this.campaign = new Campaign();
        super.loadLstFile(uRI);
        this.finishCampaign();
    }

    public void parseLine(String string, URI uRI) throws PersistenceLayerException {
        int n = string.indexOf(58);
        if (n < 0) {
            Logging.errorPrint("Unparsed line: " + string + " in " + uRI.toString());
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(CampaignLstToken.class);
        CampaignLstToken campaignLstToken = (CampaignLstToken)map.get(string2);
        if (campaignLstToken != null) {
            LstUtils.deprecationCheck(campaignLstToken, this.campaign, string3);
            if (!campaignLstToken.parse(this.campaign, string3, uRI)) {
                Logging.errorPrint("Error parsing campaign " + this.campaign.getDisplayName() + ':' + string);
            }
        } else {
            if (PObjectLoader.parseTag(this.campaign, string)) {
                return;
            }
            Logging.errorPrint("Unparsed line: " + string + " in " + uRI.toString());
        }
    }

    protected void finishCampaign() {
        if (Globals.getCampaignByURI(this.campaign.getSourceURI(), false) == null) {
            String string = this.campaign.getSection15String();
            if (string != null && string.trim().length() > 0) {
                Globals.getSection15().append("<br><b>Source Material:</b>");
                Globals.getSection15().append(this.campaign.getSourceEntry().getFormattedString(SourceEntry.SourceFormat.LONG, true));
                Globals.getSection15().append("<br>");
                Globals.getSection15().append("<b>Section 15 Entry in Source Material:</b><br>");
                Globals.getSection15().append(string);
            }
            Globals.addCampaign(this.campaign);
        }
    }

    private void initRecursivePccFiles(Campaign campaign, Campaign campaign2) {
        if (campaign2 == null) {
            return;
        }
        campaign.addAllLstExcludeFiles(campaign2.getLstExcludeFiles());
        campaign.addAllRaceFiles(campaign2.getRaceFiles());
        campaign.addAllClassFiles(campaign2.getClassFiles());
        campaign.addAllCompanionModFiles(campaign2.getCompanionModFiles());
        campaign.addAllCoverFiles(campaign2.getCoverFiles());
        campaign.addAllSkillFiles(campaign2.getSkillFiles());
        campaign.addAllAbilityFiles(campaign2.getAbilityFiles());
        campaign.addAllFeatFiles(campaign2.getFeatFiles());
        campaign.addAllDeityFiles(campaign2.getDeityFiles());
        campaign.addAllDomainFiles(campaign2.getDomainFiles());
        campaign.addAllWeaponProfFiles(campaign2.getWeaponProfFiles());
        campaign.addAllEquipFiles(campaign2.getEquipFiles());
        campaign.addAllClassSkillFiles(campaign2.getClassSkillFiles());
        campaign.addAllClassSpellFiles(campaign2.getClassSpellFiles());
        campaign.addAllSpellFiles(campaign2.getSpellFiles());
        campaign.addAllLanguageFiles(campaign2.getLanguageFiles());
        campaign.addAllReqSkillFiles(campaign2.getReqSkillFiles());
        campaign.addAllTemplateFiles(campaign2.getTemplateFiles());
        campaign.addAllEquipModFiles(campaign2.getEquipModFiles());
        campaign.addAllKitFiles(campaign2.getKitFiles());
        campaign.addAllBioSetFiles(campaign2.getBioSetFiles());
    }

    private void initRecursivePccFiles(Campaign campaign) throws PersistenceLayerException {
        if (campaign == null) {
            return;
        }
        for (URI uRI : campaign.getPccFiles()) {
            if (!PCGFile.isPCGenCampaignFile(new File(uRI))) continue;
            Campaign campaign2 = Globals.getCampaignByURI(uRI, false);
            if (campaign2 == null) {
                try {
                    this.loadLstFile(uRI);
                    campaign2 = Globals.getCampaignByURI(uRI, false);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Recursive init failed on file " + uRI, persistenceLayerException);
                }
            }
            this.initRecursivePccFiles(campaign2);
            this.initRecursivePccFiles(campaign, campaign2);
        }
    }
}

