/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import pcgen.core.Campaign;
import pcgen.core.SettingsHandler;
import pcgen.core.Source;
import pcgen.io.FileAccess;
import pcgen.util.Logging;

public final class CampaignOutput {
    private CampaignOutput() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void output(Campaign campaign) {
        File file = new File(SettingsHandler.getPccFilesLocation().getAbsolutePath() + File.separator + campaign.getDestination());
        BufferedWriter bufferedWriter = null;
        try {
            Iterator<String> iterator;
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            FileAccess.write(bufferedWriter, "CAMPAIGN:" + campaign.getKeyName());
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "RANK:" + campaign.getRank());
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "GAMEMODE:");
            Object object = campaign.getGameModes().iterator();
            while (object.hasNext()) {
                iterator = object.next();
                FileAccess.write(bufferedWriter, (String)((Object)iterator));
                if (!object.hasNext()) continue;
                FileAccess.write(bufferedWriter, "|");
            }
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "INFOTEXT:" + campaign.getInfoText());
            FileAccess.newLine(bufferedWriter);
            object = campaign.getSourceEntry().getSourceBook();
            FileAccess.write(bufferedWriter, "SOURCELONG:" + ((Source)object).getLongName());
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "SOURCESHORT:" + ((Source)object).getShortName());
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "SOURCEWEB:" + ((Source)object).getWebsite());
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "ISD20:" + (campaign.isD20() ? "YES" : "NO"));
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "ISOGL:" + (campaign.isOGL() ? "YES" : "NO"));
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "SHOWINMENU:" + (campaign.canShowInMenu() ? "YES" : "NO"));
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "ISLICENSED:" + (campaign.isLicensed() ? "YES" : "NO"));
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "BOOKTYPE:" + campaign.getBookType());
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "SETTING:" + campaign.getSetting());
            FileAccess.newLine(bufferedWriter);
            FileAccess.write(bufferedWriter, "GENRE:" + campaign.getGenre());
            FileAccess.newLine(bufferedWriter);
            iterator = campaign.getOptionsList().iterator();
            while (iterator.hasNext()) {
                FileAccess.write(bufferedWriter, "OPTION:" + campaign.getOptions().getProperty(iterator.next()));
                FileAccess.newLine(bufferedWriter);
            }
            iterator = campaign.getSection15s().iterator();
            while (iterator.hasNext()) {
                FileAccess.write(bufferedWriter, "COPYRIGHT:" + iterator.next());
                FileAccess.newLine(bufferedWriter);
            }
            iterator = campaign.getLicenses().iterator();
            while (iterator.hasNext()) {
                FileAccess.write(bufferedWriter, "LICENSE:" + iterator.next());
                FileAccess.newLine(bufferedWriter);
            }
            iterator = campaign.getLines().iterator();
            while (iterator.hasNext()) {
                FileAccess.write(bufferedWriter, iterator.next());
                FileAccess.newLine(bufferedWriter);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logging.errorPrint("Error while writing to " + file.toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logging.errorPrint("Error while writing to " + file.toString(), unsupportedEncodingException);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                Logging.errorPrint("Can't close " + file.toString(), iOException);
            }
        }
    }
}

