/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import pcgen.core.Campaign;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Logging;
import pcgen.util.UnreachableError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignSourceEntry {
    private static final URI FAILED_URI;
    private Campaign campaign = null;
    private List<String> excludeItems = new ArrayList<String>();
    private List<String> includeItems = new ArrayList<String>();
    private URI uri = null;
    private URIFactory uriFac = null;
    private String stringForm = null;

    public CampaignSourceEntry(Campaign campaign, URI uRI) {
        if (campaign == null) {
            throw new IllegalArgumentException("campaign can't be null");
        }
        if (uRI == null) {
            throw new IllegalArgumentException("lstLoc can't be null");
        }
        this.campaign = campaign;
        this.uri = uRI;
    }

    public CampaignSourceEntry(Campaign campaign, URIFactory uRIFactory) {
        if (campaign == null) {
            throw new IllegalArgumentException("campaign can't be null");
        }
        if (uRIFactory == null) {
            throw new IllegalArgumentException("URI Factory can't be null");
        }
        this.campaign = campaign;
        this.uriFac = uRIFactory;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public List<String> getExcludeItems() {
        return this.excludeItems;
    }

    public URI getURI() {
        if (this.uri == null) {
            this.uri = this.uriFac.getURI();
            this.uriFac = null;
        }
        return this.uri;
    }

    public List<String> getIncludeItems() {
        return this.includeItems;
    }

    public int compareTo(CampaignSourceEntry campaignSourceEntry) {
        if (campaignSourceEntry == null) {
            return -1;
        }
        return this.getURI().compareTo(campaignSourceEntry.getURI());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CampaignSourceEntry)) {
            return false;
        }
        return this.getURI().equals(((CampaignSourceEntry)object).getURI());
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Campaign: ");
            stringBuffer.append(this.campaign.getDisplayName());
            stringBuffer.append("; SourceFile: ");
            stringBuffer.append(this.getURI());
            this.stringForm = stringBuffer.toString();
        }
        return this.stringForm;
    }

    public static URI getPathURI(URI uRI, String string) {
        if (string.length() <= 0) {
            Logging.errorPrint("Empty Path to LST file in " + uRI);
            return FAILED_URI;
        }
        if (string.charAt(0) == '@') {
            String string2 = CampaignSourceEntry.trimLeadingFileSeparator(string.substring(1));
            String string3 = CoreUtility.fixFilenamePath(string2);
            return new File(SettingsHandler.getPccFilesLocation(), string3).toURI();
        }
        if (string.charAt(0) == '&') {
            String string4 = CampaignSourceEntry.trimLeadingFileSeparator(string.substring(1));
            String string5 = CoreUtility.fixFilenamePath(string4);
            return new File(SettingsHandler.getPcgenVendorDataDir(), string5).toURI();
        }
        String string6 = CampaignSourceEntry.trimLeadingFileSeparator(string);
        if (string6.startsWith("data")) {
            String string7 = CoreUtility.fixFilenamePath(string6.substring(5));
            return new File(SettingsHandler.getPccFilesLocation(), string7).toURI();
        }
        if (string.indexOf(58) > 0) {
            try {
                URL uRL = new URL(string);
                return new URI(uRL.getProtocol(), uRL.getHost(), uRL.getPath(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String string8 = uRI.getPath();
        try {
            return new URI(uRI.getScheme(), null, string8.substring(0, string8.lastIndexOf(47) + 1) + string.replace('\\', '/'), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.errorPrint("GPURI failed to convert " + string8.substring(0, string8.lastIndexOf(47) + 1) + string + " to a URI: " + uRISyntaxException.getLocalizedMessage());
            return FAILED_URI;
        }
    }

    private static String trimLeadingFileSeparator(String string) {
        String string2 = string;
        if (string2.startsWith("/") || string2.startsWith(File.separator)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static CampaignSourceEntry getNewCSE(Campaign campaign, URI uRI, String string) {
        CampaignSourceEntry campaignSourceEntry;
        int n = string.indexOf("|");
        if (n == -1) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, new URIFactory(uRI, string));
        } else {
            campaignSourceEntry = new CampaignSourceEntry(campaign, new URIFactory(uRI, string.substring(0, n)));
            String string2 = string.substring(n + 1);
            while (string2.startsWith("(")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.startsWith("INCLUDE:")) {
                campaignSourceEntry.includeItems = CoreUtility.split(string2.substring(8), '|');
            } else if (string2.startsWith("EXCLUDE:")) {
                campaignSourceEntry.excludeItems = CoreUtility.split(string2.substring(8), '|');
            }
        }
        return campaignSourceEntry;
    }

    static {
        try {
            FAILED_URI = new URI("file:/FAIL");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UnreachableError(uRISyntaxException);
        }
    }

    public static class URIFactory {
        private final URI u;
        private final String s;

        public URIFactory(URI uRI, String string) {
            this.u = uRI;
            this.s = string;
        }

        public URI getURI() {
            return CampaignSourceEntry.getPathURI(this.u, this.s);
        }
    }
}

