/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Deity;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.DeityLstToken;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeityLoader
extends LstObjectFileLoader<Deity> {
    @Override
    public Deity parseLine(Deity deity, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Deity deity2 = deity;
        if (deity2 == null) {
            deity2 = new Deity();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        boolean bl = true;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(DeityLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DeityLstToken deityLstToken = (DeityLstToken)map.get(string3);
            if (deityLstToken != null) {
                String string4 = string2.substring(n + 1);
                LstUtils.deprecationCheck(deityLstToken, deity2, string4);
                if (deityLstToken.parse(deity2, string4)) continue;
                Logging.errorPrint("Error parsing deity " + deity2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(deity2, string2)) continue;
            if (bl) {
                if (!string2.equals(deity2.getKeyName()) && string2.indexOf(".MOD") < 0) {
                    this.completeObject(campaignSourceEntry, deity2);
                    deity2 = new Deity();
                    deity2.setName(string2);
                    deity2.setSourceCampaign(campaignSourceEntry.getCampaign());
                    deity2.setSourceURI(campaignSourceEntry.getURI());
                }
                bl = false;
                continue;
            }
            Logging.errorPrint("Illegal deity info '" + string2 + "' for " + deity2.getDisplayName() + " in " + campaignSourceEntry.getURI() + " of " + campaignSourceEntry.getCampaign() + ".");
        }
        this.completeObject(campaignSourceEntry, deity2);
        return null;
    }

    @Override
    protected Deity getObjectKeyed(String string) {
        return Globals.getDeityKeyed(string);
    }

    @Override
    protected void performForget(Deity deity) {
        Globals.getDeityList().remove(deity);
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.getDeityList().add((Deity)pObject);
    }
}

