/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.KitLstToken;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitLoader
extends LstObjectFileLoader<Kit> {
    static List<String> globalTokens = null;
    static Prerequisite kitPrereq = null;

    @Override
    protected void addGlobalObject(PObject pObject) {
        Kit kit = (Kit)pObject;
        Globals.getKitInfo().put(kit.getKeyName(), kit);
    }

    @Override
    protected Kit getObjectKeyed(String string) {
        return Globals.getKitKeyed(string);
    }

    @Override
    public Kit parseLine(Kit kit, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(KitLstToken.class);
        int n = string.indexOf(58);
        String string2 = "";
        try {
            string2 = string.substring(0, n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        KitLstToken kitLstToken = (KitLstToken)map.get(string2);
        if (string.startsWith("STARTPACK:")) {
            kit = new Kit();
            kit.setSourceCampaign(campaignSourceEntry.getCampaign());
            kit.setSourceURI(campaignSourceEntry.getURI());
            if (kitPrereq != null) {
                kit.addPreReq(kitPrereq);
            }
            if (globalTokens != null) {
                for (String string3 : globalTokens) {
                    PObjectLoader.parseTag(kit, string3);
                }
            }
        }
        if (kitLstToken != null) {
            String string4 = string.substring(n + 1);
            LstUtils.deprecationCheck(kitLstToken, kit, string4);
            if (!kitLstToken.parse(kit, string4, campaignSourceEntry.getURI())) {
                Logging.errorPrint("Error parsing Kit tag " + kit.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string + "\"");
            }
        } else {
            Logging.errorPrint("Unknown kit info " + campaignSourceEntry.toString() + ":" + " \"" + string + "\"");
        }
        return kit;
    }

    @Override
    protected void performForget(Kit kit) {
    }

    public static void addGlobalToken(String string) {
        if (globalTokens == null) {
            globalTokens = new ArrayList<String>();
        }
        globalTokens.add(string);
    }

    public static void setKitPrerequisite(Prerequisite prerequisite) {
        kitPrereq = prerequisite;
    }

    public static void clearGlobalTokens() {
        globalTokens = null;
    }

    public static void clearKitPrerequisites() {
        kitPrereq = null;
    }

    @Override
    protected void loadLstFile(CampaignSourceEntry campaignSourceEntry) {
        KitLoader.clearGlobalTokens();
        KitLoader.clearKitPrerequisites();
        super.loadLstFile(campaignSourceEntry);
    }
}

