/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LanguageLstToken;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LanguageLoader
extends LstObjectFileLoader<Language> {
    @Override
    public Language parseLine(Language language, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Language language2 = language;
        if (language2 == null) {
            language2 = new Language();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(LanguageLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LanguageLstToken languageLstToken = (LanguageLstToken)map.get(string3);
            if (n == 0) {
                language2.setName(string2);
                language2.setSourceCampaign(campaignSourceEntry.getCampaign());
                language2.setSourceURI(campaignSourceEntry.getURI());
            } else if (languageLstToken != null) {
                String string4 = string2.substring(n2 + 1).trim();
                LstUtils.deprecationCheck(languageLstToken, language2, string4);
                if (!languageLstToken.parse(language2, string4)) {
                    Logging.errorPrint("Error parsing language " + language2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                }
            } else {
                if (PObjectLoader.parseTag(language2, string2)) continue;
                Logging.errorPrint("Unknown tag '" + string2 + "' in " + campaignSourceEntry.getURI());
            }
            ++n;
        }
        this.completeObject(campaignSourceEntry, language2);
        return null;
    }

    @Override
    protected Language getObjectKeyed(String string) {
        return Globals.getLanguageKeyed(string);
    }

    @Override
    protected void performForget(Language language) {
        Globals.getLanguageList().remove(language);
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.getLanguageList().add((Language)pObject);
    }
}

