/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Observable;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.util.Logging;

public abstract class LstFileLoader
extends Observable {
    public static final char LINE_COMMENT_CHAR = '#';

    public void logError(String string) {
        Logging.errorPrint(string);
        this.setChanged();
        this.notifyObservers(new Exception(string));
    }

    protected final boolean isComment(String string) {
        return string.length() == 0 || string.charAt(0) == '#';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readFromURI(URI uRI) throws PersistenceLayerException {
        URL uRL;
        if (uRI == null) {
            throw new PersistenceLayerException("LstFileLoader.readFromURI() received a null uri parameter!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            uRL = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new PersistenceLayerException("LstFileLoader.readFromURI() could not convert parameter to a URL: " + malformedURLException.getLocalizedMessage());
        }
        InputStream inputStream = null;
        try {
            if (!CoreUtility.isNetURL(uRL) || SettingsHandler.isLoadURLs()) {
                char[] cArray;
                inputStream = uRL.openStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                int n = inputStreamReader.read(cArray = new char[512], 0, 1);
                if (n == 1 && cArray[0] != '\ufeff') {
                    stringBuilder.append(cArray, 0, 1);
                }
                while ((n = inputStreamReader.read(cArray)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            } else {
                ShowMessageDelegate.showMessageDialog("Preferences are currently set to NOT allow\nloading of sources from web links. \n" + uRL + " is a web link", "PCGen", MessageType.ERROR);
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("ERROR:" + uRL + "\n" + "Exception type:" + iOException.getClass().getName() + "\n" + "Message:" + iOException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", iOException);
                }
            }
        }
        return stringBuilder;
    }
}

