/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.SourceLoader;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LstObjectFileLoader<T extends PObject>
extends LstFileLoader {
    public static final String FIELD_SEPARATOR = "\t";
    public static final String LINE_SEPARATOR = "\r\n";
    public static final String INCLUDE_TAG = "INCLUDE";
    public static final String EXCLUDE_TAG = "EXCLUDE";
    public static final String COPY_SUFFIX = ".COPY";
    public static final String MOD_SUFFIX = ".MOD";
    public static final String FORGET_SUFFIX = ".FORGET";
    private List<ModEntry> copyLineList = new ArrayList<ModEntry>();
    private List<String> forgetLineList = new ArrayList<String>();
    private List<List<ModEntry>> modEntryList = new ArrayList<List<ModEntry>>();
    private Map<String, String> sourceMap = null;
    protected List<String> excludedObjects = new ArrayList<String>();

    public void loadLstFiles(List<CampaignSourceEntry> list) throws PersistenceLayerException {
        TreeSet<URI> treeSet = new TreeSet<URI>();
        for (CampaignSourceEntry campaignSourceEntry : list) {
            URI uRI;
            if (campaignSourceEntry == null || treeSet.contains(uRI = campaignSourceEntry.getURI())) continue;
            this.loadLstFile(campaignSourceEntry);
            treeSet.add(uRI);
        }
        this.processCopies();
        this.sourceMap = null;
        this.processMods();
        this.processForgets();
    }

    public abstract T parseLine(T var1, String var2, CampaignSourceEntry var3) throws PersistenceLayerException;

    public void completeObject(CampaignSourceEntry campaignSourceEntry, PObject pObject) throws PersistenceLayerException {
        if (pObject == null) {
            return;
        }
        if (this.sourceMap != null) {
            try {
                pObject.setSourceMap(this.sourceMap);
            }
            catch (ParseException parseException) {
                throw new PersistenceLayerException(parseException.toString());
            }
        }
        if (this.includeObject(campaignSourceEntry, pObject)) {
            this.finishObject(pObject);
            T t = this.getObjectKeyed(pObject.getKeyName());
            if (t == null || !pObject.equals(t)) {
                this.addGlobalObject(pObject);
            } else if (!((PObject)t).getSourceURI().equals(pObject.getSourceURI())) {
                if (SettingsHandler.isAllowOverride()) {
                    Date date = pObject.getSourceEntry().getSourceBook().getDate();
                    Date date2 = ((PObject)t).getSourceEntry().getSourceBook().getDate();
                    if (date != null && (date2 == null || date.compareTo(date2) > 0)) {
                        this.performForget(t);
                        this.addGlobalObject(pObject);
                    }
                } else {
                    Logging.errorPrintLocalised("Warnings.LstFileLoader.DuplicateObject", pObject.getKeyName(), ((PObject)t).getSourceURI(), pObject.getSourceURI());
                }
            }
        } else {
            this.excludedObjects.add(pObject.getKeyName());
        }
    }

    protected abstract void addGlobalObject(PObject var1);

    protected void finishObject(PObject pObject) {
    }

    protected final boolean includeObject(CampaignSourceEntry campaignSourceEntry, PObject pObject) {
        if (pObject == null || pObject.getDisplayName() == null || pObject.getDisplayName().trim().length() == 0 || pObject.getKeyName() == null || pObject.getKeyName().trim().length() == 0) {
            return false;
        }
        List<String> list = campaignSourceEntry.getIncludeItems();
        if (!list.isEmpty()) {
            return list.contains(pObject.getKeyName());
        }
        List<String> list2 = campaignSourceEntry.getExcludeItems();
        if (!list2.isEmpty()) {
            return !list2.contains(pObject.getKeyName());
        }
        return true;
    }

    protected abstract T getObjectKeyed(String var1);

    protected void loadLstFile(CampaignSourceEntry campaignSourceEntry) {
        StringBuilder stringBuilder;
        this.setChanged();
        this.notifyObservers(campaignSourceEntry.getURI());
        this.sourceMap = null;
        try {
            stringBuilder = LstObjectFileLoader.readFromURI(campaignSourceEntry.getURI());
        }
        catch (PersistenceLayerException persistenceLayerException) {
            this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.LoadError", campaignSourceEntry.getURI(), persistenceLayerException.getMessage()));
            return;
        }
        String string = stringBuilder.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_SEPARATOR);
        PObject pObject = null;
        ArrayList<ModEntry> arrayList = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            String string2 = stringTokenizer.nextToken().trim();
            if (this.isComment(string2)) continue;
            int n2 = string2.indexOf(FIELD_SEPARATOR);
            String string3 = n2 == -1 ? string2 : string2.substring(0, n2);
            if (arrayList != null) {
                if (string3.startsWith("CLASS:")) {
                    this.modEntryList.add(arrayList);
                    arrayList = null;
                } else {
                    arrayList.add(new ModEntry(campaignSourceEntry, string2, n, this.sourceMap));
                    continue;
                }
            }
            if (this.isComment(string2)) continue;
            if (string2.startsWith("SOURCE")) {
                this.sourceMap = SourceLoader.parseLine(string2, campaignSourceEntry.getURI());
                continue;
            }
            if (string3.indexOf(COPY_SUFFIX) > 0) {
                this.copyLineList.add(new ModEntry(campaignSourceEntry, string2, n, this.sourceMap));
                continue;
            }
            if (string3.indexOf(MOD_SUFFIX) > 0) {
                if (string3.startsWith("CLASS:")) {
                    arrayList = new ArrayList<ModEntry>();
                    arrayList.add(new ModEntry(campaignSourceEntry, string2, n, this.sourceMap));
                    continue;
                }
                ArrayList<ModEntry> arrayList2 = new ArrayList<ModEntry>();
                arrayList2.add(new ModEntry(campaignSourceEntry, string2, n, this.sourceMap));
                this.modEntryList.add(arrayList2);
                continue;
            }
            if (string3.indexOf(FORGET_SUFFIX) > 0) {
                this.forgetLineList.add(string2);
                continue;
            }
            try {
                pObject = this.parseLine(pObject, string2, campaignSourceEntry);
                this.completeObject(campaignSourceEntry, pObject);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.ParseError", campaignSourceEntry.getURI(), n, persistenceLayerException.getMessage()));
                Logging.debugPrint("Parse error:", persistenceLayerException);
            }
            catch (Throwable throwable) {
                this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.ParseError", campaignSourceEntry.getURI(), n, throwable.getMessage()));
                Logging.errorPrint(PropertyFactory.getString("Errors.LstFileLoader.Ignoring"), throwable);
            }
        }
        if (arrayList != null) {
            this.modEntryList.add(arrayList);
        }
    }

    protected abstract void performForget(T var1);

    private T performCopy(String string, String string2) throws PersistenceLayerException {
        T t = this.getObjectKeyed(string);
        try {
            if (t == null) {
                this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.CopyObjectNotFound", string));
                return null;
            }
            PObject pObject = ((PObject)t).clone();
            pObject.setName(string2);
            pObject.setKeyName(string2);
            return (T)pObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.CopyNotSupported", t.getClass().getName(), string, string2));
            return null;
        }
    }

    private void performCopy(ModEntry modEntry) throws PersistenceLayerException {
        String string;
        int n;
        String string2 = modEntry.getLstLine();
        int n2 = string2.indexOf(FIELD_SEPARATOR);
        String string3 = n2 != -1 ? string2.substring(0, n2) : string2;
        String string4 = string3.substring(0, n = string3.indexOf(COPY_SUFFIX));
        T t = this.performCopy(string4, string = string3.substring(n + 6));
        if (t != null) {
            if (n2 != -1) {
                String string5 = modEntry.getLstLine().substring(n + 6);
                this.parseLine(t, string5, modEntry.getSource());
            }
            this.completeObject(modEntry.getSource(), (PObject)t);
        }
    }

    private void performMod(List<ModEntry> list) {
        ModEntry modEntry = list.get(0);
        int n = modEntry.getLstLine().indexOf(MOD_SUFFIX);
        String string = modEntry.getLstLine().substring(0, n);
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            string = string.substring(n2 + 1);
        }
        if (this.excludedObjects.contains(string)) {
            return;
        }
        T t = this.getObjectKeyed(string);
        if (t == null) {
            this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.ModObjectNotFound", modEntry.getSource().getURI(), modEntry.getLineNumber(), string));
            return;
        }
        try {
            for (ModEntry modEntry2 : list) {
                try {
                    boolean bl = ((PObject)t).getSourceEntry() == null;
                    int n3 = 0;
                    if (!bl) {
                        n3 = ((PObject)t).getSourceEntry().hashCode();
                    }
                    this.parseLine(t, modEntry2.getLstLine(), modEntry2.getSource());
                    if ((!bl || ((PObject)t).getSourceEntry() == null) && (bl || n3 == ((PObject)t).getSourceEntry().hashCode())) continue;
                    try {
                        ((PObject)t).setSourceMap(modEntry2.getSourceMap());
                    }
                    catch (ParseException parseException) {
                        Logging.errorPrintLocalised("Errors.LstFileLoader.ParseDate", this.sourceMap);
                    }
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.ModParseError", modEntry2.getSource().getURI(), modEntry2.getLineNumber(), persistenceLayerException.getMessage()));
                }
            }
            this.completeObject(modEntry.getSource(), (PObject)t);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            this.logError(PropertyFactory.getFormattedString("Errors.LstFileLoader.ModParseError", modEntry.getSource().getURI(), modEntry.getLineNumber(), persistenceLayerException.getMessage()));
        }
    }

    private void processCopies() throws PersistenceLayerException {
        for (ModEntry modEntry : this.copyLineList) {
            this.performCopy(modEntry);
        }
        this.copyLineList.clear();
    }

    private void processForgets() {
        for (String string : this.forgetLineList) {
            T t;
            if (this.excludedObjects.contains(string = string.substring(0, string.indexOf(FORGET_SUFFIX))) || (t = this.getObjectKeyed(string)) == null) continue;
            this.performForget(t);
        }
        this.forgetLineList.clear();
    }

    private void processMods() {
        for (List<ModEntry> list : this.modEntryList) {
            this.performMod(list);
        }
        this.modEntryList.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModEntry {
        private CampaignSourceEntry source = null;
        private String lstLine = null;
        private int lineNumber = 0;
        private Map<String, String> sourceMap = null;

        public ModEntry(CampaignSourceEntry campaignSourceEntry, String string, int n, Map<String, String> map) {
            if (campaignSourceEntry == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("lstLine must not be null");
            }
            this.source = campaignSourceEntry;
            this.lstLine = string;
            this.lineNumber = n;
            this.sourceMap = map;
        }

        public String getLstLine() {
            return this.lstLine;
        }

        public CampaignSourceEntry getSource() {
            return this.source;
        }

        public Map<String, String> getSourceMap() {
            return this.sourceMap;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

