/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.PCAlignment;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PCAlignmentLstToken;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public final class PCAlignmentLoader
extends LstLineFileLoader {
    public void parseLine(String string, URI uRI) throws PersistenceLayerException {
        PCAlignment pCAlignment = new PCAlignment();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PCAlignmentLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PCAlignmentLstToken pCAlignmentLstToken = (PCAlignmentLstToken)map.get(string3);
            if (pCAlignmentLstToken != null) {
                String string4 = string2.substring(n + 1).trim();
                LstUtils.deprecationCheck(pCAlignmentLstToken, pCAlignment, string4);
                if (pCAlignmentLstToken.parse(pCAlignment, string4)) continue;
                Logging.errorPrint("Error parsing alignment " + pCAlignment.getDisplayName() + ':' + uRI.toString() + ':' + string2 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(pCAlignment, string2)) continue;
            Logging.errorPrint("Illegal alignment info '" + string + "' in " + uRI.toString());
        }
        if (!SettingsHandler.getGame().getUnmodifiableAlignmentList().contains(pCAlignment)) {
            SettingsHandler.getGame().addToAlignmentList(pCAlignment);
        }
    }
}

