/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pcgen.core.Ability;
import pcgen.core.Campaign;
import pcgen.core.PObject;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.persistence.lst.utils.FeatParser;
import pcgen.persistence.lst.utils.PObjectHelper;

public final class PObjectLoader {
    private static List<PObjectHelper> featList = new ArrayList<PObjectHelper>();

    private PObjectLoader() {
    }

    public static boolean parseTag(PObject pObject, String string) throws PersistenceLayerException {
        return PObjectLoader.parseTagLevel(pObject, string, -9);
    }

    public static boolean parseTagLevel(PObject pObject, String string, int n) throws PersistenceLayerException {
        if (pObject == null || string.length() < 1) {
            return false;
        }
        pObject.setNewItem(false);
        string.charAt(0);
        boolean bl = false;
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return false;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(GlobalLstToken.class);
        LstToken lstToken = map.get(string2);
        if (lstToken != null) {
            LstUtils.deprecationCheck(lstToken, pObject, string3);
            bl = ((GlobalLstToken)lstToken).parse(pObject, string3, n);
        } else {
            bl = true;
            if (!string.startsWith("CAMPAIGN:") || pObject instanceof Campaign) {
                if (PreParserFactory.isPreReqString(string) || string.startsWith("RESTRICT:")) {
                    if (string.equalsIgnoreCase("PRE:.CLEAR")) {
                        pObject.clearPreReq();
                    } else {
                        string = CoreUtility.replaceAll(string, "<this>", pObject.getKeyName());
                        try {
                            PreParserFactory preParserFactory = PreParserFactory.getInstance();
                            pObject.addPreReq(preParserFactory.parse(string), n);
                        }
                        catch (PersistenceLayerException persistenceLayerException) {
                            throw new PersistenceLayerException("Unable to parse a prerequisite: " + persistenceLayerException.getMessage());
                        }
                    }
                } else if (string.startsWith("VFEAT:")) {
                    featList.add(new PObjectHelper(pObject, string.substring(6), n));
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static void finishFeatProcessing() {
        for (PObjectHelper pObjectHelper : featList) {
            List<Ability> list = FeatParser.parseVirtualFeatList(pObjectHelper.getTag());
            pObjectHelper.getObject().addVirtualFeats(list);
        }
        featList.clear();
    }
}

