/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.RaceLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RaceLoader
extends LstObjectFileLoader<Race> {
    @Override
    public Race parseLine(Race race, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Race race2 = race;
        if (race2 == null) {
            race2 = new Race();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = -1;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(RaceLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RaceLstToken raceLstToken = (RaceLstToken)map.get(string3);
            if (n < 10 && string2.indexOf(58) >= 0) {
                n = 10;
            }
            if (n == 0) {
                race2.setName(string2);
                race2.setSourceCampaign(campaignSourceEntry.getCampaign());
                race2.setSourceURI(campaignSourceEntry.getURI());
                continue;
            }
            if (string2.startsWith("CHOOSE:LANGAUTO:")) {
                race2.setChooseLanguageAutos(string2.substring(16));
                continue;
            }
            if (raceLstToken != null) {
                String string4 = string2.substring(n2 + 1).trim();
                LstUtils.deprecationCheck(raceLstToken, race2, string4);
                if (raceLstToken.parse(race2, string4)) continue;
                Logging.errorPrint("Error parsing race " + race2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(race2, string2)) continue;
            Logging.errorPrint("Illegal race tag '" + string2 + "' in " + campaignSourceEntry.getURI());
        }
        if (race2.getLevelAdjustment(null) != 0 && race2.getCR() == 0) {
            race2.setCR(race2.getLevelAdjustment(null));
        }
        if (race2.getRaceType().equals("None")) {
            // empty if block
        }
        this.completeObject(campaignSourceEntry, race2);
        return null;
    }

    @Override
    protected Race getObjectKeyed(String string) {
        return Globals.getRaceKeyed(string);
    }

    @Override
    protected void performForget(Race race) {
        Globals.removeRaceKeyed(race.getKeyName());
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.addRace((Race)pObject);
    }
}

