/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.Skill;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.SkillLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SkillLoader
extends LstObjectFileLoader<Skill> {
    @Override
    public Skill parseLine(Skill skill, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Skill skill2 = skill;
        if (skill2 == null) {
            skill2 = new Skill();
            skill2.setSourceCampaign(campaignSourceEntry.getCampaign());
            skill2.setSourceURI(campaignSourceEntry.getURI());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        skill2.setName(stringTokenizer.nextToken());
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(SkillLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SkillLstToken skillLstToken = (SkillLstToken)map.get(string3);
            if ("REQ".equals(string2)) {
                Logging.errorPrint("You are using a deprecated tag (REQ) in Skills " + skill2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2);
                Logging.errorPrint("  Use USEUNTRAINED instead");
                skill2.setRequired(true);
                continue;
            }
            if (skillLstToken != null) {
                String string4 = string2.substring(n + 1).trim();
                LstUtils.deprecationCheck(skillLstToken, skill2, string4);
                if (skillLstToken.parse(skill2, string4)) continue;
                Logging.errorPrint("Error parsing skill " + skill2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(skill2, string2)) continue;
            Logging.errorPrint("Illegal skill info '" + string + "' in " + campaignSourceEntry.toString());
        }
        this.completeObject(campaignSourceEntry, skill2);
        return null;
    }

    @Override
    protected Skill getObjectKeyed(String string) {
        return Globals.getSkillKeyed(string);
    }

    @Override
    protected void performForget(Skill skill) {
        Globals.getSkillList().remove(skill);
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.getSkillList().add((Skill)pObject);
    }
}

