/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.SourceLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceLoader {
    public static Map<String, String> parseLine(String string, URI uRI) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(SourceLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            SourceLstToken sourceLstToken = (SourceLstToken)map.get(string3);
            if (sourceLstToken != null) {
                String string4 = string2.substring(n + 1);
                LstUtils.deprecationCheck(sourceLstToken, "SOURCE", uRI, string4);
                if (sourceLstToken.parse(hashMap, string4)) continue;
                Logging.errorPrint("Error parsing source: " + string2 + " in: " + uRI);
                continue;
            }
            Logging.errorPrint("Unknown tag '" + string2 + "' in: " + uRI);
        }
        return hashMap;
    }

    public static Map<String, String> parseSource(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.indexOf("|") != -1) {
            LstUtils.deprecationWarning("Use of SOURCELONG:<value>|SOURCESHORT:<value>|SOURCEWEB:<value>|SOURCEPAGE:<value> is deprecated.  These need to be split up into separate tokens");
            LstUtils.deprecationWarning("The line was: " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.substring(6, string2.indexOf(58));
            String string4 = string2.substring(string2.indexOf(58) + 1);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }
}

