/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.SpellLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpellLoader
extends LstObjectFileLoader<Spell> {
    @Override
    public Spell parseLine(Spell spell, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Spell spell2 = spell;
        if (spell2 == null) {
            spell2 = new Spell();
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(SpellLstToken.class);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SpellLstToken spellLstToken = (SpellLstToken)map.get(string3);
            if (n == 0) {
                if (!string2.equals(spell2.getKeyName()) && string2.indexOf(".MOD") < 0) {
                    this.completeObject(campaignSourceEntry, spell2);
                    spell2 = new Spell();
                    spell2.setName(string2);
                    spell2.setSourceCampaign(campaignSourceEntry.getCampaign());
                    spell2.setSourceURI(campaignSourceEntry.getURI());
                }
                ++n;
                continue;
            }
            if (spellLstToken != null) {
                String string4 = string2.substring(n2 + 1).trim();
                LstUtils.deprecationCheck(spellLstToken, spell2, string4);
                if (spellLstToken.parse(spell2, string4)) continue;
                Logging.errorPrint("Error parsing spell " + spell2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(spell2, string2)) continue;
            Logging.errorPrint("Illegal spell info '" + string2 + "' in " + campaignSourceEntry.getURI());
        }
        this.completeObject(campaignSourceEntry, spell2);
        return null;
    }

    @Override
    protected Spell getObjectKeyed(String string) {
        return Globals.getSpellKeyed(string);
    }

    @Override
    protected void finishObject(PObject pObject) {
    }

    @Override
    protected void performForget(Spell spell) {
        Globals.removeFromSpellMap(spell.getKeyName());
    }

    public static void setLevelList(Spell spell, String string, String string2) throws PersistenceLayerException {
        String string3 = null;
        int n = string2.lastIndexOf(91);
        int n2 = string2.lastIndexOf(93);
        if (n2 < n) {
            Logging.errorPrint("Warning: Close Bracket before Open Bracket in Level List: " + string2);
            n2 = string2.length();
        }
        if (n >= 0) {
            string3 = string2.substring(n + 1, n2);
            if (string3.length() == 0) {
                Logging.errorPrint("Warning: Empty Prerequisite in Level List: " + string2);
            }
            string2 = string2.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=", false);
            while (stringTokenizer2.hasMoreTokens()) {
                String string5 = stringTokenizer2.nextToken();
                if (!stringTokenizer2.hasMoreTokens()) {
                    throw new PersistenceLayerException("Badly formed spell " + string + " data: " + string2);
                }
                String string6 = stringTokenizer2.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string5, ",", false);
                while (stringTokenizer3.hasMoreTokens()) {
                    String string7 = stringTokenizer3.nextToken();
                    if (string3 != null) {
                        PreParserFactory preParserFactory = PreParserFactory.getInstance();
                        Prerequisite prerequisite = preParserFactory.parse(string3);
                        spell.addPreReqMapEntry(string + "|" + string7, prerequisite);
                    }
                    spell.setLevelInfo(string + "|" + string7, string6);
                }
            }
        }
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Object obj = Globals.getSpellMap().get(pObject.getKeyName());
        if (obj == null) {
            Globals.addToSpellMap(pObject.getKeyName(), pObject);
        } else {
            ArrayList<Spell> arrayList;
            if (obj instanceof Spell) {
                arrayList = new ArrayList<Spell>();
                Globals.removeFromSpellMap(((Spell)obj).getKeyName());
                Globals.addToSpellMap(pObject.getKeyName(), arrayList);
                arrayList.add((Spell)obj);
            } else {
                arrayList = (ArrayList<Spell>)obj;
            }
            arrayList.add((Spell)pObject);
        }
    }
}

