/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.SponsorLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public class SponsorLoader
extends LstLineFileLoader {
    public void parseLine(String string, URI uRI) throws PersistenceLayerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(SponsorLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            SponsorLstToken sponsorLstToken = (SponsorLstToken)map.get(string3);
            if (sponsorLstToken != null) {
                String string4 = string2.substring(n + 1).trim();
                LstUtils.deprecationCheck(sponsorLstToken, "sponsors.lst", uRI, string4);
                if (sponsorLstToken.parse(hashMap, string4)) continue;
                Logging.errorPrint("Error parsing sponsor: from sponsors.lst ");
                continue;
            }
            Logging.errorPrint("Invalid sub tag " + sponsorLstToken + " on SPONSOR line");
            throw new PersistenceLayerException("Invalid sub tag " + sponsorLstToken + " on SPONSOR line");
        }
        Globals.addSponsor(hashMap);
    }

    public static String getConvertedSponsorPath(String string) {
        String string2 = SettingsHandler.getPcgenSponsorDir().getAbsolutePath() + File.separator + string;
        if (!(string2 = CoreUtility.fixFilenamePath(string2)).startsWith(File.separator)) {
            string2 = File.separator + string2;
        }
        try {
            return new URL("file:" + string2).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }
}

