/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.persistence.lst.AbilityCategoryLstToken;
import pcgen.persistence.lst.AbilityLstToken;
import pcgen.persistence.lst.AddLstToken;
import pcgen.persistence.lst.AutoLstToken;
import pcgen.persistence.lst.BaseDiceLstToken;
import pcgen.persistence.lst.BaseKitLstToken;
import pcgen.persistence.lst.BonusSpellLstToken;
import pcgen.persistence.lst.CampaignLstToken;
import pcgen.persistence.lst.CompanionModLstToken;
import pcgen.persistence.lst.DeityLstToken;
import pcgen.persistence.lst.DomainLstToken;
import pcgen.persistence.lst.EqSizePenaltyLstToken;
import pcgen.persistence.lst.EquipSlotLstToken;
import pcgen.persistence.lst.EquipmentLstToken;
import pcgen.persistence.lst.EquipmentModifierLstToken;
import pcgen.persistence.lst.GameModeLstToken;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.KitAbilityLstToken;
import pcgen.persistence.lst.KitClassLstToken;
import pcgen.persistence.lst.KitDeityLstToken;
import pcgen.persistence.lst.KitFundsLstToken;
import pcgen.persistence.lst.KitGearLstToken;
import pcgen.persistence.lst.KitLevelAbilityLstToken;
import pcgen.persistence.lst.KitLstToken;
import pcgen.persistence.lst.KitProfLstToken;
import pcgen.persistence.lst.KitSkillLstToken;
import pcgen.persistence.lst.KitSpellsLstToken;
import pcgen.persistence.lst.KitStartpackLstToken;
import pcgen.persistence.lst.KitTableLstToken;
import pcgen.persistence.lst.LanguageLstToken;
import pcgen.persistence.lst.LevelLstToken;
import pcgen.persistence.lst.LoadInfoLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.PCAlignmentLstToken;
import pcgen.persistence.lst.PCCheckLstToken;
import pcgen.persistence.lst.PCClassLstToken;
import pcgen.persistence.lst.PCStatLstToken;
import pcgen.persistence.lst.PCTemplateLstToken;
import pcgen.persistence.lst.PaperInfoLstToken;
import pcgen.persistence.lst.PointBuyLstToken;
import pcgen.persistence.lst.PointBuyMethodLstToken;
import pcgen.persistence.lst.PointBuyStatLstToken;
import pcgen.persistence.lst.RaceLstToken;
import pcgen.persistence.lst.RollMethodLstToken;
import pcgen.persistence.lst.RuleCheckLstToken;
import pcgen.persistence.lst.SizeAdjustmentLstToken;
import pcgen.persistence.lst.SkillLstToken;
import pcgen.persistence.lst.SourceLstToken;
import pcgen.persistence.lst.SpellLstToken;
import pcgen.persistence.lst.SponsorLstToken;
import pcgen.persistence.lst.StatsAndChecksLstToken;
import pcgen.persistence.lst.SubClassLstToken;
import pcgen.persistence.lst.SubstitutionClassLstToken;
import pcgen.persistence.lst.TabLstToken;
import pcgen.persistence.lst.UnitSetLstToken;
import pcgen.persistence.lst.WeaponProfLstToken;
import pcgen.persistence.lst.WieldCategoryLstToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenStore {
    private static TokenStore inst;
    private HashMap<Class<? extends LstToken>, Map<String, LstToken>> tokenTypeMap = new HashMap();
    private final List<Class<? extends LstToken>> tokenTypeList = new ArrayList<Class<? extends LstToken>>();

    private TokenStore() {
        this.populateTokenTypeList();
    }

    public static TokenStore inst() {
        if (inst == null) {
            inst = new TokenStore();
        }
        return inst;
    }

    private void populateTokenTypeList() {
        this.tokenTypeList.add(GlobalLstToken.class);
        this.tokenTypeList.add(AbilityLstToken.class);
        this.tokenTypeList.add(CampaignLstToken.class);
        this.tokenTypeList.add(PCClassLstToken.class);
        this.tokenTypeList.add(CompanionModLstToken.class);
        this.tokenTypeList.add(DeityLstToken.class);
        this.tokenTypeList.add(DomainLstToken.class);
        this.tokenTypeList.add(EquipmentLstToken.class);
        this.tokenTypeList.add(EquipmentModifierLstToken.class);
        this.tokenTypeList.add(LanguageLstToken.class);
        this.tokenTypeList.add(RaceLstToken.class);
        this.tokenTypeList.add(PCTemplateLstToken.class);
        this.tokenTypeList.add(SkillLstToken.class);
        this.tokenTypeList.add(SpellLstToken.class);
        this.tokenTypeList.add(SourceLstToken.class);
        this.tokenTypeList.add(SubClassLstToken.class);
        this.tokenTypeList.add(SubstitutionClassLstToken.class);
        this.tokenTypeList.add(WeaponProfLstToken.class);
        this.tokenTypeList.add(KitLstToken.class);
        this.tokenTypeList.add(BaseKitLstToken.class);
        this.tokenTypeList.add(KitAbilityLstToken.class);
        this.tokenTypeList.add(KitClassLstToken.class);
        this.tokenTypeList.add(KitDeityLstToken.class);
        this.tokenTypeList.add(KitFundsLstToken.class);
        this.tokenTypeList.add(KitGearLstToken.class);
        this.tokenTypeList.add(KitLevelAbilityLstToken.class);
        this.tokenTypeList.add(KitProfLstToken.class);
        this.tokenTypeList.add(KitSkillLstToken.class);
        this.tokenTypeList.add(KitSpellsLstToken.class);
        this.tokenTypeList.add(KitStartpackLstToken.class);
        this.tokenTypeList.add(KitTableLstToken.class);
        this.tokenTypeList.add(GameModeLstToken.class);
        this.tokenTypeList.add(AbilityCategoryLstToken.class);
        this.tokenTypeList.add(BaseDiceLstToken.class);
        this.tokenTypeList.add(EqSizePenaltyLstToken.class);
        this.tokenTypeList.add(RollMethodLstToken.class);
        this.tokenTypeList.add(TabLstToken.class);
        this.tokenTypeList.add(UnitSetLstToken.class);
        this.tokenTypeList.add(WieldCategoryLstToken.class);
        this.tokenTypeList.add(StatsAndChecksLstToken.class);
        this.tokenTypeList.add(PCAlignmentLstToken.class);
        this.tokenTypeList.add(BonusSpellLstToken.class);
        this.tokenTypeList.add(PCCheckLstToken.class);
        this.tokenTypeList.add(PCStatLstToken.class);
        this.tokenTypeList.add(SizeAdjustmentLstToken.class);
        this.tokenTypeList.add(RuleCheckLstToken.class);
        this.tokenTypeList.add(PointBuyLstToken.class);
        this.tokenTypeList.add(PointBuyMethodLstToken.class);
        this.tokenTypeList.add(PointBuyStatLstToken.class);
        this.tokenTypeList.add(LevelLstToken.class);
        this.tokenTypeList.add(EquipSlotLstToken.class);
        this.tokenTypeList.add(LoadInfoLstToken.class);
        this.tokenTypeList.add(PaperInfoLstToken.class);
        this.tokenTypeList.add(SponsorLstToken.class);
        this.tokenTypeList.add(AutoLstToken.class);
        this.tokenTypeList.add(AddLstToken.class);
    }

    public void addToTokenMap(LstToken lstToken) {
        for (Class<? extends LstToken> clazz : this.tokenTypeList) {
            Map<String, LstToken> map;
            LstToken lstToken2;
            if (!clazz.isAssignableFrom(lstToken.getClass()) || (lstToken2 = (map = this.getTokenMap(clazz)).put(lstToken.getTokenName(), lstToken)) == null) continue;
            Logging.errorPrint("More than one " + clazz.getName() + " has the same token name: '" + lstToken.getTokenName() + "'");
        }
    }

    public Map<String, LstToken> getTokenMap(Class<? extends LstToken> clazz) {
        Map<String, LstToken> map = this.tokenTypeMap.get(clazz);
        if (map == null) {
            map = new HashMap<String, LstToken>();
            this.tokenTypeMap.put(clazz, map);
        }
        return map;
    }
}

