/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.util.HashMap;
import java.util.Map;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteMultWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;
import pcgen.util.Logging;

public class PrerequisiteWriterFactory {
    private static PrerequisiteWriterFactory instance = null;
    private static Map<String, PrerequisiteWriterInterface> parserLookup = new HashMap<String, PrerequisiteWriterInterface>();

    private PrerequisiteWriterFactory() {
    }

    public static PrerequisiteWriterFactory getInstance() {
        if (instance == null) {
            instance = new PrerequisiteWriterFactory();
        }
        return instance;
    }

    public PrerequisiteWriterInterface getWriter(String string) {
        PrerequisiteWriterInterface prerequisiteWriterInterface = null;
        if (string == null) {
            prerequisiteWriterInterface = new PrerequisiteMultWriter();
        } else {
            prerequisiteWriterInterface = parserLookup.get(string.toLowerCase());
            if (prerequisiteWriterInterface == null) {
                Logging.errorPrintLocalised("PrerequisiteTestFactory.error.cannot_find_test", string);
            }
        }
        return prerequisiteWriterInterface;
    }

    public static void register(PrerequisiteWriterInterface prerequisiteWriterInterface) throws PersistenceLayerException {
        String string = prerequisiteWriterInterface.kindHandled();
        PrerequisiteWriterInterface prerequisiteWriterInterface2 = parserLookup.get(string.toLowerCase());
        if (prerequisiteWriterInterface2 != null) {
            throw new PersistenceLayerException("Error registering '" + prerequisiteWriterInterface.getClass().getName() + "' as test '" + string + "'. The test is already registered to '" + prerequisiteWriterInterface2.getClass().getName() + "'");
        }
        parserLookup.put(string.toLowerCase(), prerequisiteWriterInterface);
    }
}

