/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import pcgen.util.DiceExpressionConstants;
import pcgen.util.DiceExpressionFunctions;
import pcgen.util.DiceExpressionTokenManager;
import pcgen.util.Logging;
import pcgen.util.ParseException;
import pcgen.util.SimpleCharStream;
import pcgen.util.Token;

public class DiceExpression
extends DiceExpressionFunctions
implements DiceExpressionConstants {
    public static final int BAD_VALUE = Integer.MIN_VALUE;
    private String dieExpression = "";
    private Stack argStack = new Stack();
    public DiceExpressionTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public DiceExpression(String string) {
        this.dieExpression = string;
    }

    private void initialize() {
        int n;
        this.argStack.clear();
        StringReader stringReader = new StringReader(this.dieExpression);
        this.jj_input_stream = new SimpleCharStream(stringReader, 1, 1);
        this.token_source = new DiceExpressionTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 14; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public static void main(String[] stringArray) throws ParseException {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            DiceExpression diceExpression = new DiceExpression(stringArray[i]);
            try {
                int n2 = diceExpression.rollDice();
                if (n2 == Integer.MIN_VALUE) {
                    System.exit(0);
                }
                System.out.println(stringArray[i] + " = " + n2);
                continue;
            }
            catch (ParseException parseException) {
                Logging.debugPrint("Exiting.");
                throw parseException;
            }
        }
    }

    private static void initFunction(String string) {
        if (string.equals("maxroll")) {
            DiceExpression.setMaxRoll(true);
        }
    }

    private static String badfun(String string, Object[] objectArray) {
        String string2 = "Bad function: " + string + "(";
        if (objectArray.length > 0) {
            if (objectArray[0] instanceof Integer) {
                string2 = string2 + "int";
            }
        } else {
            string2 = string2 + "int[]";
        }
        for (int i = 1; i < objectArray.length; ++i) {
            string2 = objectArray[i] instanceof Integer ? string2 + ",int" : string2 + ",int[]";
        }
        string2 = string2 + ")";
        return string2;
    }

    private static Object[] repack(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Integer) continue;
            Object[] objectArray2 = (Object[])objectArray[i];
            int[] nArray = new int[objectArray2.length];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = (Integer)objectArray2[j];
            }
            objectArray[i] = nArray;
        }
        return objectArray;
    }

    private static Class[] typesOf(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] instanceof Integer ? Integer.TYPE : int[].class;
        }
        return classArray;
    }

    public final int rollDice() throws ParseException {
        this.initialize();
        DiceExpression.setMaxRoll(false);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: {
                this.sum();
                this.jj_consume_token(0);
                return (Integer)this.argStack.pop();
            }
            case 0: {
                this.jj_consume_token(0);
                return Integer.MIN_VALUE;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void sum() throws ParseException {
        this.term();
        block7: while (true) {
            Token token;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    token = this.jj_consume_token(5);
                    break;
                }
                case 6: {
                    token = this.jj_consume_token(6);
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.term();
            int n = (Integer)this.argStack.pop();
            int n2 = (Integer)this.argStack.pop();
            if (token.kind == 5) {
                this.argStack.push(new Integer(n2 + n));
                continue;
            }
            this.argStack.push(new Integer(n2 - n));
        }
    }

    public final void term() throws ParseException {
        this.exp();
        block8: while (true) {
            Token token;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    token = this.jj_consume_token(7);
                    break;
                }
                case 8: {
                    token = this.jj_consume_token(8);
                    break;
                }
                case 9: {
                    token = this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.exp();
            int n = (Integer)this.argStack.pop();
            int n2 = (Integer)this.argStack.pop();
            if (token.kind == 7) {
                this.argStack.push(new Integer(n2 * n));
                continue;
            }
            if (token.kind == 8) {
                this.argStack.push(new Integer(n2 / n));
                continue;
            }
            this.argStack.push(new Integer(n2 % n));
        }
    }

    public final void exp() throws ParseException {
        this.unary();
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(10);
            this.exp();
            int n = (Integer)this.argStack.pop();
            int n2 = (Integer)this.argStack.pop();
            this.argStack.push(new Integer(DiceExpression.pow(n2, n)));
        }
    }

    public final void unary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: {
                Token token;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        token = this.jj_consume_token(5);
                        break;
                    }
                    case 6: {
                        token = this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.dice();
                int n = (Integer)this.argStack.pop();
                if (token.kind == 5) {
                    this.argStack.push(new Integer(n));
                    break;
                }
                this.argStack.push(new Integer(-n));
                break;
            }
            case 11: {
                this.unary_die();
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 19: {
                this.dice();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void unary_die() throws ParseException {
        this.jj_consume_token(11);
        this.dice();
        int n = (Integer)this.argStack.pop();
        this.argStack.push(new Integer(DiceExpression.roll(1, n)));
    }

    public final void dice() throws ParseException {
        this.element();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(11);
            this.element();
            int n = (Integer)this.argStack.pop();
            int n2 = (Integer)this.argStack.pop();
            this.argStack.push(new Integer(DiceExpression.roll(n2, n)));
        }
    }

    public final void element() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                this.argStack.push(new Integer(DiceExpression.roll(1, 100)));
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                try {
                    this.argStack.push(Integer.valueOf(this.token.image));
                }
                catch (NumberFormatException numberFormatException) {
                    this.argStack.push(new Integer(Integer.MIN_VALUE));
                }
                break;
            }
            case 16: {
                this.function();
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                this.sum();
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void simple_arg_list() throws ParseException {
        int n = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: {
                this.sum();
                ++n;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                    this.sum();
                    ++n;
                }
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        Object[] objectArray = new Object[n];
        int n2 = n;
        while (--n2 >= 0) {
            objectArray[n2] = this.argStack.pop();
        }
        this.argStack.push(objectArray);
    }

    public final void full_arg() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                this.simple_arg_list();
                this.jj_consume_token(23);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: {
                this.sum();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void complex_arg_list() throws ParseException {
        int n = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                this.full_arg();
                ++n;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                    this.full_arg();
                    ++n;
                }
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        Object[] objectArray = new Object[n];
        int n2 = n;
        while (--n2 >= 0) {
            objectArray[n2] = this.argStack.pop();
        }
        this.argStack.push(DiceExpression.repack(objectArray));
    }

    public final void function() throws ParseException {
        this.jj_consume_token(16);
        String string = this.token.image;
        DiceExpression.initFunction(string);
        this.jj_consume_token(19);
        this.complex_arg_list();
        this.jj_consume_token(20);
        Object[] objectArray = (Object[])this.argStack.pop();
        Class[] classArray = DiceExpression.typesOf(objectArray);
        Method method = null;
        if ("maxroll".equals(string) && objectArray.length == 1) {
            DiceExpression.setMaxRoll(false);
            this.argStack.push(objectArray[0]);
            return;
        }
        try {
            method = DiceExpression.class.getMethod(string, classArray);
            this.argStack.push(method.invoke(null, objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Logging.errorPrint(DiceExpression.badfun(string, objectArray) + ": " + throwable, invocationTargetException);
            this.argStack.push(new Integer(Integer.MIN_VALUE));
            return;
        }
        catch (Exception exception) {
            Logging.errorPrint(DiceExpression.badfun(string, objectArray) + " [" + method + "]", exception);
            this.argStack.push(new Integer(Integer.MIN_VALUE));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    private final boolean jj_3_1() {
        return this.jj_scan_token(10);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{604257, 96, 96, 896, 896, 96, 604256, 2048, 602112, 0x200000, 604256, 4798560, 0x200000, 4798560};
    }

    public DiceExpression(InputStream inputStream) {
        this(inputStream, null);
    }

    public DiceExpression(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new DiceExpressionTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 14; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 14; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public DiceExpression(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new DiceExpressionTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 14; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 14; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public DiceExpression(DiceExpressionTokenManager diceExpressionTokenManager) {
        int n;
        this.token_source = diceExpressionTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 14; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(DiceExpressionTokenManager diceExpressionTokenManager) {
        int n;
        this.token_source = diceExpressionTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 14; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[24];
        for (n2 = 0; n2 < 24; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 14; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 24; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        DiceExpression.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

